/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCDHCPCommand
extends SuperBladeCommand {
    public BladeBMCDHCPCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (!bladeEntity.isSimCardDetectPin()) {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
            return;
        }
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.parameters != null && this.parameters.length == 1) {
            String isOn = this.parameters[0];
            boolean result = false;
            if (isOn.equalsIgnoreCase("enable")) {
                result = ipmiLanCommand.setLanSettingType((byte)2);
            } else if (isOn.equalsIgnoreCase("disable")) {
                result = ipmiLanCommand.setLanSettingType((byte)1);
            } else {
                MOut.G(this).println("Parameter error!");
                this.statusCode = 147;
                return;
            }
            if (result) {
                MOut.G(this).println("Done");
                this.printDHCPStatus(ipmiLanCommand);
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else {
            this.printDHCPStatus(ipmiLanCommand);
            this.statusCode = 0;
        }
    }

    private void printDHCPStatus(IPMILanCommand ipmiLanCommand) {
        byte data = ipmiLanCommand.getLanSettingType();
        switch (data) {
            case 2: {
                MOut.G(this).println("DHCP enabled");
                break;
            }
            case 1: {
                MOut.G(this).println("static IP enabled");
                break;
            }
            default: {
                MOut.G(this).println("unknown LAN setting");
            }
        }
    }
}

