/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCUserPasswordCommand
extends SuperBladeCommand {
    byte userID;
    String password;

    public BladeBMCUserPasswordCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        String usage = "Usage: user setpwd <user id> <password>";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        this.password = this.parameters[1];
        if (this.password.length() > 20) {
            MOut.G(this).println("password should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMB ipmb = new IPMB(ipmiMessagingCommand.getIPMIInterface());
            ipmb.setIpmbType(1);
            ipmiMessagingCommand.setIPMIInterface(ipmb);
            byte index = Byte.parseByte((String)this.preParameters.get(1));
            ipmb.setChannel(index);
            if (!ipmiMessagingCommand.setUserPasswordByID(this.userID, this.password)) {
                MOut.G(this).println("Set user password failed");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
        }
    }
}

