/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeGetSerialNumberCommand
extends SuperBladeCommand {
    public BladeGetSerialNumberCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            this.statusCode = 147;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        FRUInfo fruInfo = null;
        IPMIFRUCommand ipmifruCommand = new IPMIFRUCommand(null);
        ipmifruCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmifruCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmifruCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(bladeIndex);
        this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(false);
        fruInfo = ipmifruCommand.getFRUData();
        this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(true);
        if (fruInfo != null) {
            MOut.G(this).println(new String(fruInfo.fru.product.productSerialNumber));
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Get fruInfo fail");
            this.statusCode = 149;
        }
    }
}

