/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class BladeLEDStatusCommand
extends SuperBladeCommand {
    public static byte LED_OFF = 0;
    public static byte LED_ON = 1;
    public static byte LED_UNKNOWN = (byte)2;

    @Override
    public void runCommand() throws Exception {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = IPMIMessagingCommand.getSystemGUIDbyConfig(this.config);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ArrayList sdrList = null;
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
            MOut.G(this).println("Model: CMM-3");
            byte[] raw = new byte[]{-61, 50};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                MOut.G(this).println("LED Status: on");
                MOut.G(this).println("\nAnalyzing......\n");
                this.checkCMMSensor(sdrList, ipmiSDRCommand);
                this.checkCMMFailure(ipmiOEMCommand);
            } else if (result == 1) {
                MOut.G(this).println("LED Status: off");
            } else {
                MOut.G(this).println("LED Status: unknown");
            }
            this.statusCode = 0;
            return;
        }
        if (IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            MOut.G(this).println("Model: CMM-6");
            byte[] raw = new byte[]{-61, 121};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                MOut.G(this).println("LED Status: off");
            } else if (result == 1) {
                MOut.G(this).println("LED Status: on");
                MOut.G(this).println("\nAnalyzing......\n");
                this.checkCMMSensor(sdrList, ipmiSDRCommand);
                this.checkCMMFailure(ipmiOEMCommand);
            } else {
                MOut.G(this).println("LED Status: unknown");
            }
            this.statusCode = 0;
            return;
        }
        byte[] boardIDfromBMC = ipmiOEMCommand.getProductID();
        byte result = this.checkLEDStatus(boardIDfromBMC, ipmiOEMCommand);
        MOut.G(this).println("Board Model:" + IPMIOEMCommand.getBoardModel(boardIDfromBMC));
        if (result == LED_OFF) {
            MOut.G(this).println("LED Status: off");
        } else if (result == LED_ON) {
            MOut.G(this).println("LED Status: on");
            MOut.G(this).println("\nAnalyzing......\n");
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                MOut.G(this).println("Get SDR Repository error, skipped");
            } else {
                try {
                    sdrList = ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
                    for (SDRRecord item : sdrList) {
                        if (item.getSensorType() != 1) continue;
                        byte value = ipmiSDRCommand.getSensorReading(item.getSensorNumber(), item.getSensorType());
                        String reading = "";
                        if (value == -128) {
                            reading = "N/A";
                            continue;
                        }
                        reading = this.showCandF((int)item.calSensorReading(value));
                        if (this.checkSensorValue(value, item) != 1) continue;
                        MOut.G(this).println("Failure :  " + item.getSensorName() + " overheat " + reading);
                    }
                }
                catch (IPMIException iter) {
                }
                catch (Exception e) {
                    MOut.G(this).println("Get SDR failed:" + e.getMessage());
                }
            }
            this.checkfailure(boardIDfromBMC, ipmiOEMCommand);
            MOut.G(this).println("Done");
        } else {
            MOut.G(this).println("LED Status: unknown");
        }
        this.statusCode = 0;
    }

    private byte checkLEDStatus(byte[] boardID, IPMIOEMCommand ipmiOEMCommand) throws IPMIException {
        if (boardID[0] == -127 && boardID[1] == 28) {
            byte[] raw = new byte[]{-8, 12};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_OFF;
            }
            if (result == 1) {
                return LED_ON;
            }
        } else if (boardID[0] == 7 && boardID[1] == 26) {
            byte[] raw = new byte[]{-61, 3};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                return LED_OFF;
            }
        } else if ((boardID[0] == 51 || boardID[0] == 50) && boardID[1] == 27) {
            byte[] raw = new byte[]{-61, 3};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                return LED_OFF;
            }
        } else if (boardID[0] == 35 && boardID[1] == 29) {
            byte[] raw = new byte[]{-61, -55, 0};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_OFF;
            }
            if (result == 1) {
                return LED_ON;
            }
        } else if (boardID[0] == 70 && boardID[1] == 28 || boardID[0] == 51 && boardID[1] == 28) {
            IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
            if (deviceInfo.firmwareRevision1 == 1) {
                byte[] raw = new byte[]{-61, 3, 0};
                byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
                if (result == 0) {
                    return LED_ON;
                }
                if (result == 1) {
                    return LED_OFF;
                }
            } else {
                byte[] raw = new byte[]{-8, 12};
                byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
                if (result == 0) {
                    return LED_OFF;
                }
                if (result == 1) {
                    return LED_ON;
                }
            }
        } else if (boardID[0] == 41 && boardID[1] == 27) {
            byte[] raw = new byte[]{-61, 3};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                return LED_OFF;
            }
        } else if ((boardID[0] == 49 || boardID[0] == 81) && boardID[1] == 9) {
            byte[] raw = new byte[]{-61, 18};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                return LED_OFF;
            }
        } else if (boardID[0] == 45 && boardID[1] == 28 || boardID[0] == -126 && boardID[1] == 27 || boardID[0] == 60 && boardID[1] == 28) {
            byte[] raw = new byte[]{-8, 12};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                raw = new byte[]{-61, -55, 0};
                byte result2 = ipmiOEMCommand.getBladeLEDStatus(raw);
                if (result2 == 0) {
                    return LED_ON;
                }
                if (result2 == 1) {
                    return LED_OFF;
                }
            } else if (result == 1) {
                return LED_ON;
            }
        } else if (boardID[0] == -105 && boardID[1] == 9) {
            byte[] raw = new byte[]{-61, 3};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                byte result2 = ipmiOEMCommand.getB11DPELEDStatus();
                if (result2 == 0) {
                    return LED_ON;
                }
                if (result2 == 1) {
                    return LED_OFF;
                }
            }
        } else if (boardID[0] == 102 && boardID[1] == 9) {
            byte[] raw = new byte[]{-61, 3};
            byte result = ipmiOEMCommand.getBladeLEDStatus(raw);
            if (result == 0) {
                return LED_ON;
            }
            if (result == 1) {
                return LED_OFF;
            }
        }
        return LED_UNKNOWN;
    }

    private void checkfailure(byte[] boardID, IPMIOEMCommand ipmiOEMCommand) throws IPMIException {
        if (boardID[0] == 45 && boardID[1] == 28 || boardID[0] == -126 && boardID[1] == 27 || boardID[0] == 60 && boardID[1] == 28) {
            byte throttle;
            byte prochot = ipmiOEMCommand.detectB12ProHot();
            if ((prochot & 0x80) == 128 || (prochot & 0x40) == 64) {
                MOut.G(this).println("Failure : ProcHot");
            }
            if (((throttle = ipmiOEMCommand.detectB12CPUThrottle()) & 0x80) == 128) {
                MOut.G(this).println("Failure : CPU2 throttle");
            } else if ((throttle & 0x40) == 64) {
                MOut.G(this).println("Failure : CPU1 throttle");
            }
        } else if (boardID[0] == 7 && boardID[1] == 26 || (boardID[0] == 51 || boardID[0] == 50) && boardID[1] == 27 || boardID[0] == -105 && boardID[1] == 9 || boardID[0] == 102 && boardID[1] == 9 || boardID[0] == 70 && boardID[1] == 28 || boardID[0] == 51 && boardID[1] == 28 || boardID[0] == 41 && boardID[1] == 27) {
            IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(this.ipmiCMMOEMCommand.getIPMIInterface(), 3, 112);
            byte[] data = new byte[]{2};
            try {
                byte prochot = ipmiI2CPMBusCommand.sendPMBusCommand((byte)1, data)[0];
                if ((prochot & 0x80) == 128 || (prochot & 0x40) == 64) {
                    MOut.G(this).println("Failure : ProcHot");
                }
                if ((prochot & 0x20) == 32 || (prochot & 0x10) == 16) {
                    MOut.G(this).println("Failure : CPU thermal trip");
                }
                data[0] = 0;
                byte throttle = ipmiI2CPMBusCommand.sendPMBusCommand((byte)1, data)[0];
                if ((throttle & 0x80) == 128) {
                    MOut.G(this).println("Failure : CPU2 throttle");
                } else if ((throttle & 0x40) == 64) {
                    MOut.G(this).println("Failure : CPU1 throttle");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (boardID[0] == -127 && boardID[1] == 28 || boardID[0] == 35 && boardID[1] == 29) {
            IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(this.ipmiCMMOEMCommand.getIPMIInterface(), 1, 112);
            byte[] data = new byte[]{2};
            try {
                byte prochot = ipmiI2CPMBusCommand.sendPMBusCommand((byte)1, data)[0];
                if ((prochot & 0x80) == 128 || (prochot & 0x40) == 64) {
                    MOut.G(this).println("Failure : ProcHot");
                }
                if ((prochot & 0x20) == 32 || (prochot & 0x10) == 16) {
                    MOut.G(this).println("Failure : CPU thermal trip");
                }
                data[0] = 0;
                byte throttle = ipmiI2CPMBusCommand.sendPMBusCommand((byte)1, data)[0];
                if ((throttle & 0x80) == 128) {
                    MOut.G(this).println("Failure : CPU2 throttle");
                } else if ((throttle & 0x40) == 64) {
                    MOut.G(this).println("Failure : CPU1 throttle");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkCMMSensor(ArrayList sdrList, IPMISDRCommand ipmiSDRCommand) {
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo == null) {
            MOut.G(this).println("Get SDR Repository error, skipped");
        } else {
            try {
                sdrList = ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
                for (SDRRecord item : sdrList) {
                    String value;
                    if (item.getSensorType() == 4) {
                        byte value2 = ipmiSDRCommand.getSensorReading(item.getSensorNumber(), item.getSensorType());
                        String reading = "";
                        if (value2 == -1 || value2 == 0) {
                            reading = "N/A";
                            continue;
                        }
                        reading = "" + (int)item.calSensorReading(value2 & 0xFF) + " RPM";
                        if (this.checkSensorValue(value2, item) != 1) continue;
                        MOut.G(this).println("Failure :  " + item.getSensorName() + " reading " + reading + " failed");
                        continue;
                    }
                    if (item.getEventReadingTypeCode() != 111) continue;
                    byte discreteReading = this.getDiscreteOffset(ipmiSDRCommand, item.getSensorNumber());
                    int offset = -1;
                    if (discreteReading != -1) {
                        for (int i = 0; i < 8; ++i) {
                            if ((discreteReading >> i & 1) != 1) continue;
                            offset = (byte)i;
                        }
                    }
                    if (item.getSensorType() == 8) {
                        if (offset == 0) continue;
                        MOut.G(this).println("Failure :  " + item.getSensorName() + " failed");
                        continue;
                    }
                    if (item.getSensorType() == -61) {
                        value = Byte.toString(discreteReading);
                        continue;
                    }
                    if (item.getSensorType() != -60) continue;
                    if (discreteReading == 0) {
                        value = "Normal";
                    }
                    if (discreteReading == 1) {
                        value = "Warning";
                        MOut.G(this).println("Failure :  " + item.getSensorName() + " " + value + " failed");
                        continue;
                    }
                    if (discreteReading == 2) {
                        value = "Critical";
                        MOut.G(this).println("Failure :  " + item.getSensorName() + " " + value + " failed");
                        continue;
                    }
                    if (discreteReading == 4) {
                        value = "Flashing";
                        continue;
                    }
                    if (discreteReading != 5) continue;
                    String string = "Initializing";
                }
            }
            catch (IPMIException iter) {
            }
            catch (Exception e) {
                MOut.G(this).println("Get SDR failed:" + e.getMessage());
            }
        }
    }

    private void checkCMMFailure(IPMIOEMCommand ipmiOEMCommand) {
        byte[] overpower = null;
        try {
            overpower = ipmiOEMCommand.detectCMMTrottle();
        }
        catch (IPMIException e) {
            e.printStackTrace();
        }
        if (overpower != null && overpower[0] == 0 && overpower[1] == 0) {
            MOut.G(this).println("Failure : Insufficient power");
        }
    }

    private String showCandF(int c) {
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + f + "F";
    }

    private int checkSensorValue(byte reading, SDRRecord item) {
        double value;
        if (item.getSensorType() == 1) {
            if (reading == -128) {
                return 2;
            }
            value = item.calSensorReading(reading);
        } else {
            if (reading == -1 || reading == 0) {
                return 2;
            }
            value = item.calSensorReading(reading & 0xFF);
        }
        double hi = item.getHiLimit();
        double low = item.getLowLimit();
        boolean isLowLimitActive = true;
        boolean isHighLimitActive = true;
        if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 2) != 2) {
            isLowLimitActive = false;
        }
        if ((item.getDiscreteReadingMask_SettableThresholdMask_ReadableThreasholdMask()[0] & 0x10) != 16) {
            isHighLimitActive = false;
        }
        if (isLowLimitActive && value <= low || isHighLimitActive && value >= hi) {
            return 1;
        }
        return 0;
    }

    public byte getDiscreteOffset(IPMISDRCommand ipmiSDRCommand, byte sensorNumber) {
        IPMIMessage resMessage = ipmiSDRCommand.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[2];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Cannot execute Get Sensor Reading.");
        return -1;
    }
}

