/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class DCMIPowerReadingCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMICommand ipmiDCMICommand = new IPMIDCMICommand(null);
        ipmiDCMICommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int maxRetries = 5;
        int currentRetry = 0;
        while (currentRetry < maxRetries) {
            try {
                IPMIDCMICommand.DCMIPowerReading powerStatus = ipmiDCMICommand.getPowerStatus();
                MOut.G(this).println(powerStatus.toFormatedString());
                this.statusCode = 0;
                break;
            }
            catch (Exception e) {
                if (e.getMessage().equals(GlobalDefine.getCompletionCodeString((byte)-63))) {
                    MOut.G(this).println("DCMI power reading is not supported.");
                    this.statusCode = 153;
                    break;
                }
                if (e.getMessage().equals(GlobalDefine.getCompletionCodeString((byte)0))) continue;
                ++currentRetry;
                Thread.sleep(1000L);
            }
        }
        if (currentRetry == maxRetries) {
            MOut.G(this).println("Get DCMI power reading failed.");
            this.statusCode = 149;
        }
    }
}

