/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DCPMMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.LinkedList;

public class DCPMMStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        DCPMMCommand dcpmmCommand = new DCPMMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] bitmap = dcpmmCommand.getDCMMPresentBitmap();
        LinkedList<DCPMMCommand.DIMM> presentDimm = new LinkedList<DCPMMCommand.DIMM>();
        if (bitmap == null) {
            MOut.G(this).println("Can't execute GetDCPMM Bitmap Command");
            this.statusCode = 149;
            return;
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((bitmap[i] & 1 << j) != 1 << j) continue;
                DCPMMCommand dCPMMCommand = dcpmmCommand;
                dCPMMCommand.getClass();
                DCPMMCommand.DIMM dimm = dCPMMCommand.new DCPMMCommand.DIMM(i, j);
                presentDimm.add(dimm);
            }
        }
        String f = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(f, "DIMM Locate", "Firmware version"));
        fStr.append(String.format(f, "---------------", "-------------------------"));
        for (int i = 0; i < presentDimm.size(); ++i) {
            DCPMMCommand.DIMM dimm = (DCPMMCommand.DIMM)presentDimm.get(i);
            String fwVersion = dcpmmCommand.getDimmFWVersion((byte)dimm.getCpu(), (byte)dimm.getChannel(), (byte)dimm.getSlot());
            if (fwVersion != null) {
                dimm.setVersion(fwVersion);
                fStr.append(String.format(f, ((DCPMMCommand.DIMM)presentDimm.get(i)).getName(), ((DCPMMCommand.DIMM)presentDimm.get(i)).getVersion()));
                continue;
            }
            fStr.append(String.format(f, ((DCPMMCommand.DIMM)presentDimm.get(i)).getName(), ""));
        }
        MOut.G(this).println(fStr.toString());
        this.statusCode = 0;
    }
}

