/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.deploy.DeployManager;
import com.supermicro.ipmi.text.deploy.DeployTarget;
import java.io.File;

public class DeployOneCommand
extends SuperBladeCommand {
    String isoFilename = "";

    public DeployOneCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("ISO filename needed");
            return false;
        }
        this.isoFilename = this.parameters[0];
        File file = new File(this.isoFilename);
        if (!file.isFile()) {
            MOut.G(this).println("ISO filename is not exist");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean ifSupport = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            ifSupport = true;
        } else if (IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isSIMBL(guid)) {
            ifSupport = true;
        }
        if (!ifSupport) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        if (DeployManager.getInstance().getDeployTargets().containsKey(this.config.getIp())) {
            MOut.G(this).println("The deploy task of IP:" + this.config.getIp() + " is already running");
            MOut.G(this).println("Try \"deploy status\" command to check status");
            MOut.G(this).println("Try \"deply clear\" command to clear task");
            return;
        }
        DeployTarget dTarget = DeployManager.getInstance().createDeployTarget(this.config, "Server");
        dTarget.getDeployTask().setIsoFilename(this.isoFilename);
        Thread t = new Thread(dTarget.deployTask);
        t.start();
        MOut.G(this).println("Task started. Using \"deploy status\" command to check deploy status");
        MOut.G(this).println("Please execute \"deploy clear\" after task finished");
    }
}

