/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.HDDStatusLogical;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class HDDDiskLogicalCommand
extends SuperBladeCommand {
    int index;

    @Override
    public boolean preValidate() {
        this.index = -1;
        if (this.parameters != null) {
            try {
                this.index = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid Index");
                return false;
            }
        } else {
            MOut.G(this).println("Index required");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        block6: {
            IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
            ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            try {
                IPMIHDDOEMCommand.HDDLogicalMap map = ipmiHDDOEMCommand.getLogicalHDDMap();
                if (map == null) {
                    MOut.G(this).println("This device does not support HDD interface");
                    this.statusCode = 153;
                    return;
                }
                if (map.isExist(this.index)) {
                    HDDStatusLogical status = ipmiHDDOEMCommand.getLogicalHDDInfoStructureNew((byte)this.index);
                    if (status != null) {
                        MOut.G(this).print(status.toString());
                    } else {
                        MOut.G(this).print("Call getHDDInfoStructure failed");
                    }
                    break block6;
                }
                MOut.G(this).println("This HDD is not present");
                return;
            }
            catch (IPMIException ex) {
                MOut.G(this).println("This device does not support HDD interface");
                this.statusCode = 153;
            }
        }
        this.statusCode = 0;
    }
}

