/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.HostBuffer;
import com.supermicro.ipmi.text.MOut;
import java.io.IOException;
import java.io.Serializable;

public class HostCenter
implements Serializable {
    public static HostCenter instance = new HostCenter();
    public static final String CURRENT_HOSTS_FILENAME = "hosts.ser";
    public static final String FOUND_HOSTS_FILENAME = "found.ser";
    HostBuffer curr;
    HostBuffer hosts;
    HostBuffer found;
    boolean isFindAvailable = false;

    public static HostCenter getInstance() {
        return instance;
    }

    public HostCenter() {
        try {
            this.hosts = new HostBuffer();
            this.found = new HostBuffer();
            this.curr = this.hosts;
            this.hosts.setFilename(CURRENT_HOSTS_FILENAME);
            this.hosts.load();
            MOut.G().println("Managed hosts loaded");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.found.setFilename(FOUND_HOSTS_FILENAME);
            this.found.load();
            MOut.G().println("Found hosts loaded");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HostBuffer getDefaultHostBuffer() {
        return this.hosts;
    }

    public HostBuffer getCurrHostBuffer() {
        return this.curr;
    }

    public HostBuffer getFoundHostBuffer() {
        return this.found;
    }

    public int size() {
        return this.curr.getHosts().size();
    }

    public IPMIInterfaceConfig getHost(int index) {
        return this.curr.getHosts().get(index);
    }

    public void removeHostByIndex(int index) {
        this.curr.getHosts().remove(index);
    }

    public void addHost(IPMIInterfaceConfig config) {
        this.curr.addHost(config);
    }

    public void removeHost(IPMIInterfaceConfig config) {
        this.curr.removeHost(config);
    }

    public IPMIInterfaceConfig findbyIP(String ip) {
        return this.curr.findbyIP(ip);
    }

    public IPMIInterfaceConfig PreviousHost() {
        if (!this.isFindAvailable) {
            return this.curr.PreviousHost();
        }
        return this.PreviousAvailableHost();
    }

    public IPMIInterfaceConfig PreviousAvailableHost() {
        IPMIInterfaceConfig ipmiInterfaceConfig;
        IPMIInterfaceConfig currInterfaceConfig = this.curr.getHost(this.curr.currentHostIndex);
        do {
            if ((ipmiInterfaceConfig = this.curr.PreviousHost()) == null || ipmiInterfaceConfig.fwType == null) continue;
            return ipmiInterfaceConfig;
        } while (!currInterfaceConfig.equals(ipmiInterfaceConfig));
        return ipmiInterfaceConfig;
    }

    public IPMIInterfaceConfig nextHost() {
        if (!this.isFindAvailable) {
            return this.curr.nextHost();
        }
        return this.nextAvailableHost();
    }

    public IPMIInterfaceConfig nextAvailableHost() {
        IPMIInterfaceConfig ipmiInterfaceConfig;
        IPMIInterfaceConfig currInterfaceConfig = this.curr.getHost(this.curr.currentHostIndex);
        do {
            if ((ipmiInterfaceConfig = this.curr.nextHost()) == null || ipmiInterfaceConfig.fwType == null) continue;
            return ipmiInterfaceConfig;
        } while (!currInterfaceConfig.equals(ipmiInterfaceConfig));
        return ipmiInterfaceConfig;
    }

    public String toFormatedString() {
        return this.curr.toFormatedString();
    }

    public String toFormatedStringWithTagLoc() {
        return this.curr.toFormatedStringWithTagLoc();
    }

    public String toString() {
        return this.curr.toString();
    }

    public void save() throws IOException {
        this.curr.save();
    }

    public void saveAs(String filename) throws IOException {
        this.curr.saveAs(filename);
    }

    public void load(String filename) throws IOException, ClassNotFoundException {
        this.curr = new HostBuffer();
        this.curr.setFilename(filename);
        this.curr.load();
    }

    public void clear() {
        this.curr.clear();
    }

    public void switchToDefault() {
        this.curr = this.hosts;
    }

    public void switchToFound() {
        this.curr = this.found;
    }

    public boolean isDefault() {
        return this.curr == this.hosts;
    }

    public boolean isFound() {
        return this.curr == this.found;
    }

    public void sort() {
        this.curr.sort();
    }
}

