/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            String newIP = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(newIP)) {
                MOut.G(this).println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (newIP.equals("0.0.0.0")) {
                MOut.G(this).println("IP cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            if (this.isDHCPEnabled(ipmiLanCommand)) {
                MOut.G(this).println("It is not allow to set IP when DHCP is enalbed");
                this.statusCode = 147;
                return;
            }
            byte data = ipmiLanCommand.getLanSettingType();
            if (data == 2) {
                MOut.G(this).println("IP can not be changed because DHCP is enabled.");
                this.statusCode = 146;
                return;
            }
            String oldIP = ipmiLanCommand.getIP();
            boolean result = ipmiLanCommand.setIP(newIP);
            if (result) {
                MOut.G(this).println("old IP:" + oldIP);
                MOut.G(this).println("new IP:" + newIP);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(oldIP);
                MOut.G(this).println("Update IP failed");
                this.statusCode = 149;
            }
        } else {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                MOut.G(this).println(ip);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(MessageCenter.getInstance().getMessage());
                this.statusCode = 148;
            }
        }
    }

    boolean isDHCPEnabled(IPMILanCommand ipmiLanCommand) {
        byte data = ipmiLanCommand.getLanSettingType();
        switch (data) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        MOut.G(this).println("unknown LAN setting");
        return false;
    }
}

