/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMIpv6Command;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.text.DNSRedfishService;
import com.supermicro.redfish.text.SMTPRedfishHelper;

public class IPMILanIPV6DNSCommand
extends SuperBladeCommand
implements DNSRedfishService {
    @Override
    public boolean preValidate() {
        block7: {
            block8: {
                block9: {
                    if (this.parameters == null) break block8;
                    if (this.parameters.length < 2) break block9;
                    try {
                        int value = Integer.parseInt(this.parameters[1]);
                        if (value < 1) break block7;
                        if (2 < value) {
                        }
                    }
                    catch (NumberFormatException e) {}
                    break block7;
                }
                if (!"clear".equalsIgnoreCase(this.parameters[0]) && !SMTPRedfishHelper.isValidIPv6(this.parameters[0])) break block7;
            }
            return true;
        }
        MOut.G(this).println("Invalid parameter");
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        IPMIOEMIpv6Command ipmioemipv6Command = new IPMIOEMIpv6Command(null);
        ipmioemipv6Command.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            byte[] data;
            String dns1 = null;
            String dns2 = null;
            try {
                data = ipmioemipv6Command.getIPV6DNS(1);
                dns1 = data == null ? "empty" : new String(data);
            }
            catch (IPMIException ex) {
                MOut.G(this).println(ex.getLocalizedMessage());
                this.statusCode = 149;
                return;
            }
            try {
                data = ipmioemipv6Command.getIPV6DNS(2);
                dns2 = data == null ? "empty" : new String(data);
            }
            catch (IPMIException data2) {
                // empty catch block
            }
            if (dns2 == null) {
                MOut.G(this).println("DNS: " + dns1);
            } else {
                MOut.G(this).println("DNS1: " + dns1);
                MOut.G(this).println("DNS2: " + dns2);
            }
            this.printUsage();
            this.statusCode = 0;
        } else if (this.parameters[0].equalsIgnoreCase("clear")) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            int index = 1;
            if (this.getParameters().length >= 2) {
                index = Integer.parseInt(this.getParameters()[1]);
            }
            if (ipmioemipv6Command.clearIPV6DNS(index)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("DNS is empty");
                this.statusCode = 0;
            }
        } else {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            if (this.isRedfishDNSIPv6AutoMode(super.getConfig())) {
                MOut.G(this).println("Unable to set DNS in IPv6 auto mode");
                this.statusCode = 149;
                return;
            }
            IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            byte index = 1;
            byte protocol = 1;
            if (this.getParameters().length >= 2) {
                index = (byte)Integer.parseInt(this.getParameters()[1]);
            }
            if (command.setDNS(this.getParameters()[0], protocol, index)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Set DNS failed");
                this.printUsage();
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("");
        MOut.G(this).println("To set DNS  : ipmi lan ipv6 dns <ip> [number (1 to 2)]");
        MOut.G(this).println("To clear DNS: ipmi lan ipv6 dns clear [number (1 to 2)]");
    }
}

