/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.util.regex.Pattern;

public class IPMIOEMAlertMailCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private Pattern EMAIL_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    @Override
    public boolean preValidate() {
        block7: {
            try {
                if (this.parameters.length == 1) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    break block7;
                }
                if (this.parameters.length == 2) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    if (!this.isValidEmail(this.parameters[1]) && this.parameters[1].length() != 0) {
                        MOut.G(this).println("Email format error!");
                        return false;
                    }
                    break block7;
                }
                MOut.G(this).println("Parameter error!");
                return false;
            }
            catch (Exception ex) {
                MOut.G(this).println("Parameter error!");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported() || !this.isBeforeX12()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters.length == 1) {
            String mail = new String(ipmiOEMWebSettingCommand.getAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)1));
            MOut.G(this).println(mail.length() == 0 ? "N/A" : mail);
        } else {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            byte[] mail = new byte[this.parameters[1].length() + 1];
            System.arraycopy(this.parameters[1].getBytes(), 0, mail, 0, this.parameters[1].length());
            ipmiOEMWebSettingCommand.setAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)4, mail);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }

    private boolean isValidEmail(String email) {
        boolean result = false;
        if (this.EMAIL_PATTERN.matcher(email).matches()) {
            result = true;
        }
        return result;
    }
}

