/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMLANInterfaceCommand
extends SuperBladeCommand {
    public static final byte GET_LAN_MODE = -1;
    public static final byte DEDICATED = 0;
    public static final byte SHARE = 1;
    public static final byte FAILOVER = 2;
    public static final byte SHARE_AIOM = 3;
    public static final byte SHARE_AOC = 4;
    public static final byte FAILOVER_AIOM = 5;
    public static final byte FAILOVER_AOC = 6;
    public static final byte SHARE_ONBOARD = 7;
    public static final byte FAILOVER_ONBOARD = 8;
    private byte commandArgs;

    @Override
    public boolean preValidate() {
        this.commandArgs = (byte)-2;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("0")) {
                this.commandArgs = 0;
            } else if (this.parameters[0].equalsIgnoreCase("1")) {
                this.commandArgs = 1;
            } else if (this.parameters[0].equalsIgnoreCase("2")) {
                this.commandArgs = (byte)2;
            } else if (this.parameters[0].equalsIgnoreCase("3")) {
                this.commandArgs = (byte)3;
            } else if (this.parameters[0].equalsIgnoreCase("4")) {
                this.commandArgs = (byte)4;
            } else if (this.parameters[0].equalsIgnoreCase("5")) {
                this.commandArgs = (byte)5;
            } else if (this.parameters[0].equalsIgnoreCase("6")) {
                this.commandArgs = (byte)6;
            } else if (this.parameters[0].equalsIgnoreCase("7")) {
                this.commandArgs = (byte)7;
            } else if (this.parameters[0].equalsIgnoreCase("8")) {
                this.commandArgs = (byte)8;
            }
        } else {
            this.commandArgs = (byte)-1;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] supportedMaskBytes = this.getLANModeMask(ipmiAMIOEMCommand);
        int supportedMask = this.getIntegerMask(supportedMaskBytes);
        int returnCode = 0;
        switch (this.commandArgs) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                returnCode = this.setLANMode(ipmiAMIOEMCommand, supportedMask);
                break;
            }
            case -1: {
                returnCode = this.getLANMode(ipmiAMIOEMCommand, supportedMask);
                break;
            }
            default: {
                returnCode = this.errorHandle(supportedMask);
            }
        }
        this.statusCode = returnCode;
    }

    private byte[] getLANModeMask(IPMIAMIOEMCommand command) {
        try {
            return command.getLANModeCap();
        }
        catch (IPMIException e) {
            return null;
        }
    }

    private int getLANMode(IPMIAMIOEMCommand command, int supportedMask) throws IPMIException {
        try {
            byte currentLANMode = command.getLANMode();
            this.printUsage(currentLANMode, supportedMask);
            return 0;
        }
        catch (IPMIException e) {
            MOut.G(this).println(e.getMessage());
            return 149;
        }
    }

    private int setLANMode(IPMIAMIOEMCommand command, int supportedMask) throws IPMIException {
        try {
            if (supportedMask == 0 || (supportedMask & 1 << this.commandArgs) != 0) {
                command.setLANMode(this.commandArgs);
                MOut.G(this).println("done");
                return 0;
            }
            MOut.G(this).println("This mode is not supported\n");
            this.getLANMode(command, supportedMask);
            return 153;
        }
        catch (IPMIException e) {
            MOut.G(this).println(e.getMessage());
            return 149;
        }
    }

    private int getIntegerMask(byte[] maskBytes) {
        int supportedMask = 0;
        if (maskBytes != null) {
            supportedMask = maskBytes[0] & 0xFF;
            if (maskBytes.length > 1) {
                supportedMask |= maskBytes[1] << 8;
            }
        }
        return supportedMask;
    }

    private int errorHandle(int supportedMask) {
        MOut.G(this).println("Invalid parameters");
        this.printUsage((byte)-1, supportedMask);
        return 147;
    }

    private void printUsage(byte currentMode, int supportedMask) {
        MOut.G(this).println("Current LAN interface is [ " + IPMIAMIOEMCommand.getLanModeText(currentMode) + " ]");
        MOut.G(this).println("\n" + (supportedMask != 0 ? "Supported parameter " : "Parameter ") + "for setting:");
        if (supportedMask == 0 || (supportedMask & 1) != 0) {
            MOut.G(this).println("0:Dedicated");
        }
        if (supportedMask == 0 || (supportedMask & 2) != 0) {
            MOut.G(this).println("1:Shared");
        }
        if (supportedMask == 0 || (supportedMask & 4) != 0) {
            MOut.G(this).println("2:Failover");
        }
        if ((supportedMask & 8) != 0) {
            MOut.G(this).println("3:Share-AIOM");
        }
        if ((supportedMask & 0x10) != 0) {
            MOut.G(this).println("4:Share-AOC");
        }
        if ((supportedMask & 0x20) != 0) {
            MOut.G(this).println("5:Failover-AIOM");
        }
        if ((supportedMask & 0x40) != 0) {
            MOut.G(this).println("6:Failover-AOC");
        }
        if ((supportedMask & 0x80) != 0) {
            MOut.G(this).println("7:Share-Onboard");
        }
        if ((supportedMask & 0x100) != 0) {
            MOut.G(this).println("8:Failover-Onboard");
        }
    }
}

