/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.NTPRedfishService;
import java.util.ArrayList;

public class IPMIOEMNTPDaylightCommand
extends IPMIX10OEMWebSettingAbstractCommand
implements NTPRedfishService {
    private static final byte NTPSetting = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && !this.parameters[0].equalsIgnoreCase("yes") && !this.parameters[0].equalsIgnoreCase("no")) {
            MOut.G(this).println("Parameter error!");
            MOut.G(this).println("Usage: ipmi oem x10cfg ntp daylight [yes|no]");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isRedfishAutoDSTSupported;
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
        boolean bl = isRedfishAutoDSTSupported = isBeforeX12 ? false : this.isNTPRedfishAutoDSTSupported(super.getConfig());
        if (isRedfishAutoDSTSupported) {
            if (this.parameters == null) {
                try {
                    boolean isAutoDstEnable = this.isNTPRedfishAutoDSTEnabled(super.getConfig());
                    MOut.G(this).println(isAutoDstEnable ? "Yes" : "No");
                    this.statusCode = 0;
                }
                catch (IPMIException ex) {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else {
                if (this.checkIfSystemLockdown()) {
                    return;
                }
                boolean autoDstState = this.parameters[0].equalsIgnoreCase("yes");
                int result = this.setNTPRedfishAutoDSTEnable(super.getConfig(), autoDstState);
                if (result == 0) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else if (result == 1) {
                    MOut.G(this).println("This timezone does not support auto DST");
                    this.statusCode = 149;
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            }
        } else {
            IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            byte[] ntpData = command.getNTPDateTime((byte)0);
            if (this.parameters == null) {
                if (ntpData.length >= 7) {
                    boolean isAutoDstEnable = ntpData[6] == 1;
                    MOut.G(this).println(isAutoDstEnable ? "Yes" : "No");
                    this.statusCode = 0;
                } else if (ntpData.length >= 4) {
                    boolean isAutoDstEnable = ntpData[3] == 1;
                    MOut.G(this).println(isAutoDstEnable ? "Yes" : "No");
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else {
                if (this.checkIfSystemLockdown()) {
                    return;
                }
                if (ntpData.length >= 7) {
                    ntpData[6] = this.parameters[0].equalsIgnoreCase("yes") ? (byte)1 : 0;
                    command.setNTPDateTime((byte)0, ntpData);
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else if (ntpData.length >= 4) {
                    int index = ntpData[1] & 0xFF;
                    ArrayList<Boolean> autoDSTSupportList = IPMIOEMWebSettingCommand.getNTPTimeZoneSupportAutoList();
                    if (0 < index && index <= autoDSTSupportList.size()) {
                        if (autoDSTSupportList.get(index - 1).booleanValue()) {
                            ntpData[3] = this.parameters[0].equalsIgnoreCase("yes") ? (byte)1 : 0;
                            command.setNewNTPSettings(ntpData);
                            MOut.G(this).println("Done");
                            this.statusCode = 0;
                        } else {
                            MOut.G(this).println("This timezone does not support auto DST setting");
                            this.statusCode = 149;
                        }
                    } else {
                        MOut.G(this).println("Failed");
                        this.statusCode = 149;
                    }
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            }
        }
    }
}

