/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.NTPRedfishService;
import java.util.ArrayList;

public class IPMIOEMNTPTimeZoneCommand
extends IPMIX10OEMWebSettingAbstractCommand
implements NTPRedfishService {
    private static final byte NTPSetting = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void runCommand() throws Exception {
        block27: {
            block26: {
                boolean isRedfishTimeZoneNameSupported;
                if (!this.isX10CFGSupported()) {
                    MOut.G(this).println("This device is not supported");
                    this.statusCode = 153;
                    return;
                }
                byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
                boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
                boolean bl = isRedfishTimeZoneNameSupported = isBeforeX12 ? false : this.isNTPRedfishTimezoneSupported(super.getConfig());
                if (!isRedfishTimeZoneNameSupported) break block27;
                ArrayList<String> timeZoneNameList = IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList();
                if (this.parameters == null) {
                    String timeZoneName = this.getNTPRedfishTimezone(super.getConfig());
                    if (timeZoneName != null && !timeZoneName.isEmpty()) {
                        int index = timeZoneNameList.indexOf(timeZoneName) + 1;
                        this.printTimeZoneNameFormat();
                        MOut.G(this).println("----------------------");
                        MOut.G(this).println("Time Zone[" + index + "]: " + timeZoneName);
                        this.statusCode = 0;
                        return;
                    } else {
                        this.statusCode = 149;
                        MOut.G(this).println("Failed");
                    }
                    return;
                }
                int index = 0;
                this.statusCode = 144;
                if (!this.checkIfSystemLockdown()) {
                    try {
                        String indexString = this.parameters[0];
                        if (indexString.startsWith("0") || indexString.contains("+") || (index = Integer.parseInt(indexString)) < 1) break block26;
                        if (timeZoneNameList.size() < index) {
                        }
                    }
                    catch (NumberFormatException ex) {}
                    break block26;
                    String timeZoneName = timeZoneNameList.get(index - 1);
                    boolean result = this.setNTPRedfishTimezone(super.getConfig(), timeZoneName);
                    if (!result) {
                        this.statusCode = 149;
                        MOut.G(this).println("Failed");
                    } else {
                        this.statusCode = 0;
                        MOut.G(this).println("Done");
                    }
                }
            }
            if (this.statusCode != 144) return;
            this.statusCode = 147;
            MOut.G(this).println("Invalid index");
            this.printTimeZoneVaildIndex();
            return;
        }
        IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] ntpData = command.getNTPDateTime((byte)0);
        if (this.parameters == null) {
            if (ntpData.length >= 7) {
                MOut.G(this).println(new String(ntpData).substring(1, 6));
                this.statusCode = 0;
                return;
            } else if (ntpData.length >= 4) {
                int index = ntpData[1] & 0xFF;
                ArrayList<String> timeZoneList = IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList();
                if (0 < index && index <= timeZoneList.size()) {
                    String timeZoneName = IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList().get(index - 1);
                    this.printTimeZoneNameFormat();
                    MOut.G(this).println("----------------------");
                    MOut.G(this).println("Time Zone[" + index + "]: " + timeZoneName);
                    this.statusCode = 0;
                    return;
                } else {
                    MOut.G(this).println("Time Zone index is out of range: " + index);
                    this.statusCode = 149;
                }
                return;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        if (ntpData != null && ntpData[0] == 1) {
            if (ntpData.length >= 7) {
                if (!this.isNTPValidParams()) {
                    return;
                }
                System.arraycopy(this.parameters[0].getBytes(), 0, ntpData, 1, 5);
                command.setNTPDateTime((byte)0, ntpData);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            if (ntpData.length >= 4) {
                int index = 0;
                try {
                    index = Integer.parseInt(this.parameters[0]);
                }
                catch (NumberFormatException ex) {
                    this.statusCode = 147;
                    MOut.G(this).println("Invalid index");
                    return;
                }
                ArrayList<Boolean> autoDSTSupportList = IPMIOEMWebSettingCommand.getNTPTimeZoneSupportAutoList();
                ArrayList<String> timeZoneList = IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList();
                if (0 < index && index <= timeZoneList.size()) {
                    ntpData[1] = (byte)index;
                    boolean forceDisableAutoDST = autoDSTSupportList.get(index - 1) == false;
                    command.setNewNTPSettings(ntpData, forceDisableAutoDST);
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    return;
                } else {
                    this.statusCode = 147;
                    MOut.G(this).println("Invalid index");
                }
                return;
            }
            MOut.G(this).println("Setting NTP timezone failed, because unexpected response length");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Setting NTP timezone failed, because NTP status is disabled.");
        this.statusCode = 149;
    }

    private boolean isNTPValidParams() {
        block6: {
            try {
                if (this.parameters[0].substring(0, 1).equals("-")) {
                    if (Integer.parseInt(this.parameters[0].substring(1, 3)) > 12 || Integer.parseInt(this.parameters[0].substring(1, 3)) < 1) {
                        MOut.G(this).println("Parameter error!\n");
                        this.printTimeZoneFormat();
                        this.statusCode = 147;
                        return false;
                    }
                    break block6;
                }
                if (this.parameters[0].substring(0, 1).equals("+")) {
                    if (Integer.parseInt(this.parameters[0].substring(1, 3)) > 14 || Integer.parseInt(this.parameters[0].substring(1, 3)) < 0) {
                        MOut.G(this).println("Parameter error!\n");
                        this.printTimeZoneFormat();
                        this.statusCode = 147;
                        return false;
                    }
                    break block6;
                }
                MOut.G(this).println("Parameter error!\n");
                this.printTimeZoneFormat();
                this.statusCode = 147;
                return false;
            }
            catch (Exception ex) {
                MOut.G(this).println("Parameter error!\n");
                this.printTimeZoneFormat();
                this.statusCode = 147;
                return false;
            }
        }
        return true;
    }

    private void printTimeZoneVaildIndex() {
        MOut.G(this).println("Time Zone Index: 1 ~ " + IPMIOEMWebSettingCommand.getNTPTimeZoneSupportAutoList().size());
    }

    private void printTimeZoneNameFormat() throws IPMIException {
        String formatPattern = "%3s %11s %-55s" + System.lineSeparator();
        MOut.G(this).print(IPMIOEMWebSettingCommand.getNTPTimeZoneNameList(formatPattern));
    }

    void printTimeZoneFormat() {
        MOut.G(this).println("Time Zone Range: -1200 ~ +1400");
    }
}

