/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.text.MBTLinkService;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.SessionLoginClient;

public class MBTOEMCommand
extends SuperBladeCommand {
    String taskID = "";
    public static final int BMC1 = 0;
    public static final int BMC2 = 1;
    public static final int BIOS1 = 2;
    public static final int BIOS2 = 3;
    public static final int NO_COMMAND = 99;
    private int subCommand = -1;

    public void printUsage() {
        MOut.G(this).println("Usage: mbt oem $TASKID <option>");
        MOut.G(this).println("Available commands: bmc1,bmc2,bios1,bios2");
        MOut.G(this).println("   bmc1:  record BMC version (before update)");
        MOut.G(this).println("   bmc2:  record BMC version (after update)");
        MOut.G(this).println("   bios1: record BIOS version (before update)");
        MOut.G(this).println("   bios2: record BIOS version (after update)");
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters == null || this.parameters.length < 2) {
            this.printUsage();
            return false;
        }
        this.taskID = this.parameters[0];
        if (this.parameters != null) {
            if (this.parameters[1].equalsIgnoreCase("bmc1")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bmc2")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bios1")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bios2")) {
                this.subCommand = 3;
                passValidate = true;
            }
        } else {
            this.subCommand = 99;
            passValidate = false;
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIX9BIOSOEMCommand biosOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        BTaskVariable bTaskVariable = BTaskManager.getInstance().getBTaskVariable(this.taskID);
        String versionNumber = null;
        if (bTaskVariable == null) {
            MOut.G(this).println("TaskID(" + this.taskID + ") not found");
            this.statusCode = 147;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                DeviceInfo deviceInfo1 = ipmiGlobalCommand.getDevice();
                StringBuffer bmcVer1 = new StringBuffer("" + deviceInfo1.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo1.firmwareRevision2));
                if (deviceInfo1.usingAuxiliaryFWVesion) {
                    bmcVer1.append("." + ByteUtility.byteToHex(deviceInfo1.auxiliaryFirmwareRevisionInfo[0]));
                }
                MOut.G(this).println(bmcVer1.toString());
                bTaskVariable.put("$BMC_VER_1", bmcVer1.toString());
                break;
            }
            case 1: {
                if (!MBTLinkService.isLinkRecovery(this, 30)) {
                    this.statusCode = 145;
                    break;
                }
                DeviceInfo deviceInfo2 = ipmiGlobalCommand.getDevice();
                StringBuffer bmcVer2 = new StringBuffer("" + deviceInfo2.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo2.firmwareRevision2));
                if (deviceInfo2.usingAuxiliaryFWVesion) {
                    bmcVer2.append("." + ByteUtility.byteToHex(deviceInfo2.auxiliaryFirmwareRevisionInfo[0]));
                }
                MOut.G(this).println(bmcVer2.toString());
                bTaskVariable.put("$BMC_VER_2", bmcVer2.toString());
                break;
            }
            case 2: {
                if (IPMIMessagingCommand.isBeforeX12(ipmiMessagingCommand.getSystemGUID())) {
                    IPMIX9BIOSOEMCommand.BIOSInfo biosInfo = biosOEMCommand.getBIOSInfo(0x1000000);
                    versionNumber = biosInfo.toStringFromBMC().trim();
                } else {
                    versionNumber = this.getVersionNumber("BIOS Staging");
                }
                MOut.G(this).println(versionNumber);
                bTaskVariable.put("$BIOS_VER_1", versionNumber);
                break;
            }
            case 3: {
                if (!MBTLinkService.isLinkRecovery(this, 30)) {
                    this.statusCode = 145;
                    break;
                }
                try {
                    this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, this.ipmiCMMOEMCommand);
                    ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                }
                catch (IPMIException biosInfo) {
                    // empty catch block
                }
                if (IPMIMessagingCommand.isBeforeX12(ipmiMessagingCommand.getSystemGUID())) {
                    biosOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    IPMIX9BIOSOEMCommand.BIOSInfo biosInfo = biosOEMCommand.getBIOSInfo(0x1000000);
                    versionNumber = biosInfo.toStringFromBMC().trim();
                } else {
                    versionNumber = this.getVersionNumber("BIOS Staging");
                }
                MOut.G(this).println(versionNumber);
                bTaskVariable.put("$BIOS_VER_2", versionNumber);
                break;
            }
        }
        this.statusCode = 0;
    }

    private String getVersionNumber(String verName) {
        SessionLoginClient sessionLoginClient = new SessionLoginClient(this.config);
        String url = "https://" + this.config.getIp() + "/redfish/v1/UpdateService/" + "FirmwareInventory";
        try {
            ObjectMapper mapper;
            JsonNode node;
            JsonNode member;
            int result = sessionLoginClient.send_https_get(url);
            if (result >= 200 && result <= 210 && (member = (node = (mapper = new ObjectMapper()).readTree(sessionLoginClient.getResponseString())).path("Members")).isArray()) {
                for (JsonNode l : member) {
                    url = "https://" + this.config.getIp() + l.path("@odata.id").asText();
                    int result2 = sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result > 210) continue;
                    JsonNode inventory = mapper.readTree(sessionLoginClient.getResponseString());
                    JsonNode name = inventory.path("Name");
                    JsonNode versionNumber = inventory.path("Version");
                    if (!name.asText().trim().equalsIgnoreCase(verName)) continue;
                    return versionNumber.asText();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != sessionLoginClient) {
            try {
                sessionLoginClient.closeSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            sessionLoginClient = null;
        }
        return null;
    }
}

