/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeStatusCommand
extends MicroBladeCommand {
    String bladeIndex;
    int nodeIndex = 0;
    byte bIndex = 0;
    int powerIndex = -1;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.printUsage();
            return false;
        }
        if (this.parameters.length >= 3) {
            try {
                this.powerIndex = Integer.parseInt(this.getParameters()[2]);
            }
            catch (Exception e) {
                this.printUsage();
                return false;
            }
            if (this.powerIndex < 0 || this.powerIndex > 5) {
                this.printUsage();
                return false;
            }
        }
        if (this.parameters.length >= 2) {
            this.bladeIndex = this.getParameters()[0];
            this.bIndex = (byte)NodeSensorInfo.getBladeIndex(this.bladeIndex);
            if (this.bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                return false;
            }
            try {
                this.nodeIndex = Integer.parseInt(this.getParameters()[1]);
            }
            catch (Exception e) {
                MOut.G(this).println("The node index must be 1-4");
                return false;
            }
            if (this.nodeIndex < 1 || this.nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 2) {
            BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
            NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            byte status = this.ipmiMicroBladeOEMCommand.getNodeStatus((int)this.bIndex, this.nodeIndex - 1);
            MOut.G(this).println("For power status options:");
            MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
            if (status == 0) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " current power off");
            } else if (status == 1) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " current power on");
            }
        } else if (this.getParameters().length == 3) {
            if (this.powerIndex == 4) {
                this.powerIndex = 24;
            }
            BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
            NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            --this.nodeIndex;
            this.ipmiMicroBladeOEMCommand.setNodeStatus(this.bIndex, this.nodeIndex, this.powerIndex);
            MOut.G(this).println("done");
        } else {
            this.printUsage();
        }
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("\nUsage: microbBlade node power <bladeID> <nodeID> [options]");
        MOut.G(this).println("For power status options:");
        MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
    }
}

