/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.MidplaneFRUCommand;
import com.supermicro.ipmi.MidplaneSystemInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MidplaneFRUWriteCommand
extends SuperBladeCommand {
    String field;
    byte valueByte;
    String valueString;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.printUsage();
            return false;
        }
        this.valueByte = 0;
        this.valueString = "";
        this.field = this.parameters[0].toUpperCase();
        if (this.field.equals("CT") || this.field.equals("CP") || this.field.equals("CS") || this.field.equals("SGP") || this.field.equals("PPM") || this.field.equals("ZON") || this.field.equals("PS") || this.field.equals("PAT") || this.field.equals("PM") || this.field.equals("PN") || this.field.equals("PV")) {
            if (this.field.contentEquals("SGP")) {
                try {
                    this.valueByte = Byte.parseByte(this.parameters[1]);
                }
                catch (NumberFormatException e) {
                    this.SGPIOUsage();
                    return false;
                }
                if (this.valueByte != 0 && this.valueByte != 1) {
                    this.SGPIOUsage();
                    return false;
                }
            } else if (this.field.contentEquals("ZON")) {
                try {
                    this.valueByte = Byte.parseByte(this.parameters[1]);
                }
                catch (NumberFormatException e) {
                    this.ZoneUsage();
                    return false;
                }
                if (this.valueByte < 0 || this.valueByte > 3) {
                    this.ZoneUsage();
                    return false;
                }
            } else {
                if (this.field.contentEquals("PPM") || this.field.contentEquals("PS") || this.field.contentEquals("PM") || this.field.contentEquals("PN") || this.field.contentEquals("PV") || this.field.contentEquals("PAT")) {
                    if (this.parameters.length > 1) {
                        for (int i = 1; i < this.parameters.length; ++i) {
                            this.valueString = i == 1 ? this.parameters[i] : this.valueString + " " + this.parameters[i];
                        }
                        if (this.valueString.length() > 32) {
                            MOut.G(this).println("Maximum length exceeded");
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (this.field.equals("CT")) {
                    short chassisType;
                    if (this.parameters.length == 2 && ((chassisType = Short.parseShort(this.parameters[1], 16)) >= 0 && chassisType <= 36 || chassisType == 39)) {
                        return true;
                    }
                    MOut.G(this).println("Invalid chassis type.");
                    MOut.G(this).println("");
                    this.chassTypeUsage();
                    return false;
                }
            }
        } else {
            MOut.G(this).println("Invalid field.");
            MOut.G(this).println("");
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        MidplaneFRUCommand midplaneFRUCommand = new MidplaneFRUCommand(null);
        midplaneFRUCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        FRUInfo chassisFRU = midplaneFRUCommand.getChassisFRU();
        if (chassisFRU != null) {
            if (this.field.equals("PPM") || this.field.equals("PS") || this.field.equals("SGP") || this.field.equals("ZON") || this.field.equals("PAT")) {
                MidplaneSystemInfo mid = new MidplaneSystemInfo();
                byte[] sysInfo = midplaneFRUCommand.getSystemInfoStructure();
                if (sysInfo == null) {
                    MOut.G(this).println("Get system info structure fail");
                    this.statusCode = 149;
                    return;
                }
                mid.fromRaw(sysInfo);
                if (this.field.equals("PPM")) {
                    mid.setSystemModelNumber(this.valueString.length() > 21 ? this.valueString.substring(0, 21) : this.valueString);
                    chassisFRU.fru.product.productPartModelNumber = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                } else if (this.field.equals("PS")) {
                    mid.setSystemSerialNumber(this.valueString);
                    chassisFRU.fru.product.productSerialNumber = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                } else if (this.field.equals("SGP")) {
                    mid.setSGPIOMode(this.valueByte);
                } else if (this.field.equals("ZON")) {
                    mid.setZoneConfig(this.valueByte);
                } else if (this.field.equals("PAT")) {
                    mid.setReservedByte(this.parameters[1].length() > 31 ? this.parameters[1].substring(0, 31).getBytes() : this.parameters[1].getBytes());
                    chassisFRU.fru.product.assetTag = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                }
                if (midplaneFRUCommand.writeSystemInfo(mid.toRaw()) && midplaneFRUCommand.writeChassisInfo(chassisFRU.fru.toRaw())) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else {
                if (this.field.equals("CT")) {
                    chassisFRU.fru.chassis.chassisType = Byte.parseByte(this.parameters[1], 16);
                    chassisFRU.fru.isChassisExist = true;
                } else if (this.field.contentEquals("CP")) {
                    chassisFRU.fru.chassis.partNumber = this.parameters[1].getBytes();
                    chassisFRU.fru.isChassisExist = true;
                } else if (this.field.contentEquals("CS")) {
                    chassisFRU.fru.chassis.serialNumber = this.parameters[1].getBytes();
                    chassisFRU.fru.isChassisExist = true;
                } else if (this.field.contentEquals("PM")) {
                    chassisFRU.fru.product.productManufacturerName = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                } else if (this.field.contentEquals("PN")) {
                    chassisFRU.fru.product.productName = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                } else if (this.field.contentEquals("PV")) {
                    chassisFRU.fru.product.productVersion = this.parameters[1].getBytes();
                    chassisFRU.fru.isProductExist = true;
                }
                if (midplaneFRUCommand.writeChassisInfo(chassisFRU.fru.toRaw())) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            }
        } else {
            MOut.G(this).println("Get chassis FRU fail");
            this.statusCode = 149;
        }
    }

    public byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(this.charToByte(achar[pos]) << 4 | this.charToByte(achar[pos + 1]));
        }
        return result;
    }

    private byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public void printUsage() {
        MOut.G(this).println("Usage: midFRU write <field> <value>");
        MOut.G(this).println("");
        MOut.G(this).println("Available Fields for FRU:");
        MOut.G(this).println("  Chassis Info Fields:");
        MOut.G(this).println("    CT  :Chassis Type");
        MOut.G(this).println("    CP  :Chassis Part number");
        MOut.G(this).println("    CS  :Chassis Serial number");
        MOut.G(this).println("  Product Info Fields:");
        MOut.G(this).println("    PM  :Product Manufacturer ");
        MOut.G(this).println("    PN  :Product Name ");
        MOut.G(this).println("    PPM :Product Part/Model Number");
        MOut.G(this).println("    PV  :Product Version ");
        MOut.G(this).println("    PS  :Product Serial Number");
        MOut.G(this).println("    PAT :Asset Tag");
        MOut.G(this).println("    SGP :SGPIO");
        MOut.G(this).println("    ZON :Zoning mode");
    }

    public void chassTypeUsage() {
        MOut.G(this).println("  01h = Other");
        MOut.G(this).println("  02h = Unknown");
        MOut.G(this).println("  03h = Desktop");
        MOut.G(this).println("  04h = Low Profile Desktop");
        MOut.G(this).println("  05h = Pizza Box");
        MOut.G(this).println("  06h = Mini Tower");
        MOut.G(this).println("  07h = Tower");
        MOut.G(this).println("  08h = Portable");
        MOut.G(this).println("  09h = LapTop");
        MOut.G(this).println("  0Ah = Notebook");
        MOut.G(this).println("  0Bh = Hand Held");
        MOut.G(this).println("  0Ch = Docking Station");
        MOut.G(this).println("  0Dh = All in One");
        MOut.G(this).println("  0Eh = Sub Notebook");
        MOut.G(this).println("  0Fh = Space-saving");
        MOut.G(this).println("  10h = Lunch Box");
        MOut.G(this).println("  11h = Main Server Chassis");
        MOut.G(this).println("  12h = Expansion Chassis");
        MOut.G(this).println("  13h = SubChassis");
        MOut.G(this).println("  14h = Bus Expansion Chassis");
        MOut.G(this).println("  15h = Peripheral Chassis");
        MOut.G(this).println("  16h = RAID Chassis");
        MOut.G(this).println("  17h = Rack Mount Chassis");
        MOut.G(this).println("  18h = Sealed-case PC");
        MOut.G(this).println("  19h = Multi-system chassis");
        MOut.G(this).println("  1Ah = Compact PCI");
        MOut.G(this).println("  1Bh = Advanced TCA");
        MOut.G(this).println("  1Ch = Blade");
        MOut.G(this).println("  1Dh = Blade Enclosure");
        MOut.G(this).println("  1Eh = Tablet");
        MOut.G(this).println("  1Fh = Convertible");
        MOut.G(this).println("  20h = Detachable");
        MOut.G(this).println("  21h = IoT Gateway");
        MOut.G(this).println("  22h = Embedded PC");
        MOut.G(this).println("  23h = Mini PC");
        MOut.G(this).println("  24h = Stick PC");
    }

    public void SGPIOUsage() {
        MOut.G(this).println("SGPIO mode");
        MOut.G(this).println("0: Disabled     1:Enabled");
    }

    public void ZoneUsage() {
        MOut.G(this).println("Zoning mode must be 0~3");
    }
}

