/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NM20CpuMemoryTemperatureCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        boolean isExtendChannel = false;
        boolean isEnableDIMMChannel = true;
        try {
            IPMINM20Command.CpuMemoryTemperature cpuMemoryTemp = null;
            try {
                cpuMemoryTemp = this.ipmiNM20Command.getCPUandMemoryTemperature(isExtendChannel, 0, isEnableDIMMChannel);
            }
            catch (IPMIException e) {
                cpuMemoryTemp = this.ipmiNM20Command.getCPUandMemoryTemperature(isExtendChannel, 0, !isEnableDIMMChannel);
            }
            IPMINM20Command.CpuMemoryTemperature cpuMemoryTemp2 = null;
            try {
                cpuMemoryTemp2 = this.ipmiNM20Command.getCPUandMemoryTemperature(!isExtendChannel, 0, isEnableDIMMChannel);
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
            for (int i = 0; i < 4; ++i) {
                try {
                    byte value = this.ipmiNM20Command.getSensorReading((byte)(48 + i));
                    if (value == 0) continue;
                    cpuMemoryTemp.setTjmaxValue((byte)i, value);
                    continue;
                }
                catch (IPMIException ex1) {
                    byte[] getTempRawPECI = new byte[]{48, 5, 5, -95, 0, 16, 0, 0};
                    getTempRawPECI[0] = (byte)(48 + i);
                    try {
                        byte[] value2 = this.ipmiNM20Command.sendRawPECI(getTempRawPECI);
                        cpuMemoryTemp.setTjmaxValue((byte)i, value2[6]);
                        continue;
                    }
                    catch (IPMIException value2) {
                        // empty catch block
                    }
                }
            }
            IPMINM20Command.CpuMemoryTemperature cpuMemoryTemp3 = null;
            try {
                cpuMemoryTemp3 = this.ipmiNM20Command.getCPUandMemoryTemperature(isExtendChannel, 1, isEnableDIMMChannel);
            }
            catch (IPMIException e) {
                if (cpuMemoryTemp != null) {
                    try {
                        cpuMemoryTemp3 = this.ipmiNM20Command.getCPUandMemoryTemperature(isExtendChannel, 1, !isEnableDIMMChannel);
                    }
                    catch (Exception getTempRawPECI) {}
                }
                cpuMemoryTemp3 = this.ipmiNM20Command.getCPUandMemoryTemperature(isExtendChannel, 1, !isEnableDIMMChannel);
            }
            IPMINM20Command.CpuMemoryTemperature cpuMemoryTemp4 = null;
            try {
                cpuMemoryTemp4 = this.ipmiNM20Command.getCPUandMemoryTemperature(!isExtendChannel, 1, isEnableDIMMChannel);
            }
            catch (IPMIException getTempRawPECI) {
                // empty catch block
            }
            if (cpuMemoryTemp3 != null) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        byte value = this.ipmiNM20Command.getSensorReading((byte)(247 + i));
                        if (value == 0) continue;
                        cpuMemoryTemp3.setTjmaxValue((byte)i, value);
                        continue;
                    }
                    catch (IPMIException ex1) {
                        byte[] getTempRawPECI = new byte[]{48, 5, 5, -95, 0, 16, 0, 0};
                        getTempRawPECI[0] = (byte)(247 + i);
                        try {
                            byte[] value2 = this.ipmiNM20Command.sendRawPECI(getTempRawPECI);
                            cpuMemoryTemp3.setTjmaxValue((byte)i, value2[6]);
                            continue;
                        }
                        catch (IPMIException iPMIException) {
                            // empty catch block
                        }
                    }
                }
            }
            List<String> cpuLists = null;
            List memLists = null;
            if (cpuMemoryTemp != null) {
                cpuLists = cpuMemoryTemp.getCPUList().stream().sorted().collect(Collectors.toList());
                memLists = cpuMemoryTemp.getMemoryList(isExtendChannel).stream().sorted().collect(Collectors.toList());
            }
            if (cpuMemoryTemp2 != null) {
                memLists = memLists == null ? cpuMemoryTemp2.getMemoryList(!isExtendChannel).stream().sorted().collect(Collectors.toList()) : Stream.concat(memLists.stream(), cpuMemoryTemp2.getMemoryList(!isExtendChannel).stream()).sorted().collect(Collectors.toList());
            }
            if (cpuMemoryTemp3 != null) {
                cpuMemoryTemp3.setCpuSet(1);
                cpuLists = cpuLists == null ? cpuMemoryTemp3.getCPUList().stream().sorted().collect(Collectors.toList()) : Stream.concat(cpuLists.stream(), cpuMemoryTemp3.getCPUList().stream()).sorted().collect(Collectors.toList());
                memLists = memLists == null ? cpuMemoryTemp3.getMemoryList(isExtendChannel).stream().sorted().collect(Collectors.toList()) : Stream.concat(memLists.stream(), cpuMemoryTemp3.getMemoryList(isExtendChannel).stream()).sorted().collect(Collectors.toList());
            }
            if (cpuMemoryTemp4 != null) {
                cpuMemoryTemp4.setCpuSet(1);
                memLists = memLists == null ? cpuMemoryTemp4.getMemoryList(!isExtendChannel).stream().sorted().collect(Collectors.toList()) : Stream.concat(memLists.stream(), cpuMemoryTemp4.getMemoryList(!isExtendChannel).stream()).sorted().collect(Collectors.toList());
            }
            if (cpuLists != null && cpuLists.size() == 0) {
                MOut.G(this).println("Not available");
                this.statusCode = 0;
                return;
            }
            cpuLists.forEach(str -> MOut.G(this).println((String)str));
            if (memLists != null) {
                for (int i = 0; i < memLists.size(); ++i) {
                    MOut.G(this).println((String)memLists.get(i));
                }
            }
        }
        catch (IPMIException ex) {
            if (ex.getIPMIMessage() != null && ex.getIPMIMessage().completionCode == -63) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        this.statusCode = 0;
    }
}

