/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SELCSVCommand
extends SuperBladeCommand {
    String filename;
    private boolean isIPMI;

    @Override
    public boolean preValidate() {
        this.isIPMI = false;
        if (this.parameters == null) {
            MOut.G(this).println("Please specify filename");
            return false;
        }
        for (int idx = 0; this.parameters.length > 1 && idx < this.parameters.length; ++idx) {
            if (!this.parameters[idx].equals("--ipmi")) continue;
            this.isIPMI = true;
            break;
        }
        this.filename = this.parameters[0];
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isHGIMEZZGUID(guid) || this.isIPMI) {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmiSDRCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            byte[] productID = ipmiOEMCommand.getProductID();
            if (productID == null) {
                productID = new byte[2];
            }
            MOut.G(this).println("Getting SDR records ...");
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
            SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
            MOut.G(this).println("Getting SEL records ...");
            ArrayList list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
            int count = 0;
            if (list.size() != 0) {
                FileWriter fw = new FileWriter(this.filename);
                BufferedWriter bw = new BufferedWriter(fw);
                for (SELRecord item : list) {
                    ArrayList raw = new ArrayList();
                    bw.write("" + (count + 1));
                    bw.write("," + ByteUtility.fourByteToDateFormat2(item.getTimeStamp()));
                    bw.write("," + GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                    if (this.parameters != null && this.parameters.length >= 1 && this.parameters[0].equals("-v")) {
                        System.out.println(item.toString());
                    }
                    if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197) {
                        bw.write(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()) + " " + (byte)(item.getSensorNumber() & 0xFF));
                    } else {
                        Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                        if (sensorName != null) {
                            bw.write("," + sensorName.toString());
                        } else {
                            bw.write(",");
                        }
                    }
                    String reading = "";
                    if (item.getEventType() == 1) {
                        byte offset = item.getEventData1();
                        double readingValue = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData2() & 0xFF);
                        double threshold = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData3() & 0xFF);
                        if (item.getSensorType() == 4) {
                            reading = reading + ", Reading = " + (int)readingValue + " RPM, Threshold = " + (int)threshold + " RPM";
                        } else if (item.getSensorType() == 2) {
                            reading = reading + ", Reading = " + String.format("%3.2f", readingValue) + " V, Threshold = " + String.format("%3.2f", threshold) + " V";
                        } else if (item.getSensorType() == 1) {
                            reading = reading + ", Reading = " + String.format("%3.2f", readingValue) + " C, Threshold = " + String.format("%3.2f", threshold) + " C";
                        }
                    }
                    String description = GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3(), productID, (byte)(item.getSensorNumber() & 0xFF));
                    bw.write(",\"" + description + reading + "\"");
                    bw.write("\n");
                    ++count;
                }
                bw.close();
                fw.close();
                MOut.G(this).println("file \"" + this.filename + "\" saved");
            } else {
                MOut.G(this).println("SEL empty");
            }
        } else {
            RedfishHttpUtils utils = new RedfishHttpUtils();
            String url = "https://" + RedfishHttpUtils.getUrlIP(super.getConfig().getIp()) + "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
            utils.sendRedfishGet(super.getConfig(), url);
            List<HashMap<String, String>> entryList = utils.getEntryList();
            if (entryList.size() != 0) {
                FileWriter fw = new FileWriter(this.filename);
                BufferedWriter bw = new BufferedWriter(fw);
                for (int index = 0; index < entryList.size(); ++index) {
                    bw.write("" + entryList.get(index).get("Id"));
                    bw.write(",\"" + utils.convertDatetimeFormat(entryList.get(index).get("Created")) + "\"");
                    bw.write("," + entryList.get(index).get("Severity"));
                    bw.write("," + (entryList.get(index).containsKey("SensorType") ? entryList.get(index).get("SensorType") : entryList.get(index).get("OemSensorType")));
                    bw.write(",\"" + entryList.get(index).get("Message") + "\"");
                    bw.write("," + entryList.get(index).get("EntryCode"));
                    bw.write("\n");
                }
                bw.close();
                fw.close();
                MOut.G(this).println("file \"" + this.filename + "\" saved");
            } else {
                MOut.G(this).println("SEL empty");
            }
        }
        this.statusCode = 0;
    }
}

