/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class TPBPLocationCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMITwinProCommand ipmiTwinProCommand = new IPMITwinProCommand(null);
        ipmiTwinProCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (!ipmiTwinProCommand.isSupportTwinProCommand()) {
                this.statusCode = 153;
                MOut.G(this).println("Not supported device");
                return;
            }
        }
        catch (Exception e) {
            this.statusCode = 153;
            MOut.G(this).println("Cannot get MCU Info");
            return;
        }
        byte configID = ipmiTwinProCommand.getConfigID();
        if (this.parameters == null) {
            byte bpLocation = ipmiTwinProCommand.getBPLocation();
            if (configID == 12) {
                MOut.G(this).println(String.valueOf(bpLocation));
            } else if (bpLocation == 16) {
                MOut.G(this).println("2");
            } else if (bpLocation == 1) {
                MOut.G(this).println("1");
            } else {
                MOut.G(this).println("N/A");
            }
        } else if (this.parameters.length == 1) {
            int bpLocation;
            if (configID == 12) {
                this.statusCode = 0;
                MOut.G(this).println("This function is only supported in FatTwin");
                return;
            }
            if (this.parameters[0].equals("1")) {
                bpLocation = 1;
            } else if (this.parameters[0].equals("2")) {
                bpLocation = 16;
            } else {
                try {
                    bpLocation = (byte)Integer.parseInt(this.parameters[0], 16);
                }
                catch (NumberFormatException ex) {
                    this.statusCode = 147;
                    MOut.G(this).println("Paremeters failed");
                    return;
                }
            }
            ipmiTwinProCommand.setBPLocation((byte)bpLocation);
            MOut.G(this).println("Done");
        } else {
            this.statusCode = 147;
            MOut.G(this).println("Paremeters failed");
            return;
        }
        this.statusCode = 0;
    }
}

