/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TPLCMCUpdateCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("LCMC FW filename (*.jed) is needed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 7;
        byte slaveAddr = -64;
        if (this.parameters == null) {
            MOut.G(this).println("Please specify the jed file path.");
        } else {
            if (this.speedTest() > 50) {
                MOut.G(this).println("Network connection between server and client are too slow, abort updating");
                this.statusCode = 0;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            if (!this.translateFileToHex(this.parameters[0])) {
                this.statusCode = 148;
                return;
            }
            ipmiI2CPMBusCommand.enableConfigurationMode();
            if (!ipmiI2CPMBusCommand.checkLCMCDeviceID()) {
                MOut.G(this).println("Not supported chipset");
                this.statusCode = 153;
                return;
            }
            do {
                ipmiI2CPMBusCommand.CFGFlashErase();
                Thread.sleep(2000L);
                MOut.G(this).print("Erasing........");
                while (ipmiI2CPMBusCommand.checkLCMCBusy()) {
                }
                ipmiI2CPMBusCommand.resetCFGAddress();
                MOut.G(this).print("Done\n");
                MOut.G(this).println("Writing data. It will take several minutes, please wait");
            } while (!ipmiI2CPMBusCommand.CFGFlashWrite("temp.bin"));
            MOut.G(this).println("Done");
            ipmiI2CPMBusCommand.resetCFGAddress();
            MOut.G(this).print("Verifying........");
            if (!ipmiI2CPMBusCommand.CFGFlashCompare("temp.bin")) {
                MOut.G(this).println("Verifying failure, value mismatch");
                this.statusCode = 148;
                return;
            }
            MOut.G(this).print("Done\n");
            ipmiI2CPMBusCommand.programCFGDone();
            ipmiI2CPMBusCommand.disableConfigurationModeAndBypass();
            ipmiI2CPMBusCommand.deviceRefresh();
            this.statusCode = 0;
            MOut.G(this).print("Update Complete");
        }
    }

    public boolean translateFileToHex(String fileName) throws IOException {
        FileWriter fw;
        FileReader fr;
        try {
            fr = new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            MOut.G(this).println("Open file fail.");
            return false;
        }
        BufferedReader br = new BufferedReader(fr);
        boolean readingFlag = false;
        try {
            fw = new FileWriter("temp.bin");
        }
        catch (IOException e) {
            MOut.G(this).println("Can not create tempory Hex file");
            br.close();
            fr.close();
            return false;
        }
        while (br.ready()) {
            String s = br.readLine();
            if (s == null) continue;
            if (s.contains("L0000000")) {
                readingFlag = true;
                continue;
            }
            if (s.contains("END CONFIG DATA")) {
                readingFlag = false;
                fw.flush();
                fw.close();
                break;
            }
            if (!readingFlag || s.length() != 128) continue;
            for (int i = 0; i < 128; i += 4) {
                String sub_s = s.substring(i, i + 4);
                int decimal = Integer.parseInt(sub_s, 2);
                String hexStr = Integer.toString(decimal, 16).toUpperCase();
                fw.write(hexStr);
            }
            fw.write("\n");
        }
        br.close();
        fr.close();
        fw.close();
        return true;
    }

    public int speedTest() throws IPMIException {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            ACPIInfo acpi = ipmiGlobalCommand.getACPI();
            if (acpi != null) continue;
            throw new IPMIException("test speed failed");
        }
        long end = System.currentTimeMillis();
        return (int)((end - start) / 10L);
    }
}

