/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.auth.AuthGeneric;
import com.supermicro.ipmi.trap.parser.SNMPv3Parser;
import com.supermicro.ipmi.trap.privacy.PrivacyGeneric;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import com.supermicro.ipmi.trap.usm.AuthProtocol;
import com.supermicro.ipmi.trap.usm.PrivProtocol;
import com.supermicro.ipmi.trap.usm.UserTable;
import com.supermicro.ipmi.trap.usm.UserTableUtils;
import java.util.List;

public class TrapV3ListCommand
extends SuperBladeCommand {
    private int authProtocolEnum = 0;
    private int privProtocolEnum = 0;
    private String username = null;
    private String authPassword = null;
    private String privPassword = null;

    @Override
    public boolean preValidate() {
        this.init();
        boolean isValid = false;
        if (this.parameters == null) {
            isValid = true;
        } else if (this.parameters != null && this.parameters.length < 5) {
            MOut.G(this).println("Not enough parameters.");
        } else if (this.parameters.length > 5) {
            MOut.G(this).println("Too many parameters.");
        } else if (!this.isInteger(this.parameters[1])) {
            MOut.G(this).println("Authentication Protocol Enum should be a integer.");
        } else if (!this.isInteger(this.parameters[3])) {
            MOut.G(this).println("Decryption Protocol Enum should be a integer.");
        } else {
            this.username = this.parameters[0];
            this.authProtocolEnum = Integer.valueOf(this.parameters[1]);
            this.authPassword = this.parameters[2];
            this.privProtocolEnum = Integer.valueOf(this.parameters[3]);
            this.privPassword = this.parameters[4];
            if (this.authProtocolEnum < 0 || this.authProtocolEnum > 1) {
                MOut.G(this).println("Authentication Protocol Enum is out of range.");
            } else if (this.privProtocolEnum < 0 || this.privProtocolEnum > 1) {
                MOut.G(this).println("Decryption Protocol Enum is out of range.");
            } else {
                isValid = true;
            }
        }
        if (!isValid) {
            this.usage();
        }
        return isValid;
    }

    @Override
    public void runCommand() throws Exception {
        int sizeOfTrapV3 = Receiver.getInstance().getTrapCollector().getTrapV3Count();
        if (sizeOfTrapV3 != 0) {
            List<UserTable> listUserTable = this.getUsertableList();
            if (listUserTable.isEmpty()) {
                MOut.G(this).println("There is no enough information to parse SNMPv3 Trap.");
                MOut.G(this).println("Please input parameters or add the configuration to user table.");
                this.statusCode = 149;
                return;
            }
            SNMPv3Parser parser = new SNMPv3Parser();
            for (int trapIndex = 0; trapIndex < sizeOfTrapV3; ++trapIndex) {
                SNMPv3Trap trapV3 = Receiver.getInstance().getTrapCollector().getSNMPv3Traps().get(trapIndex);
                MOut.G(this).println("\n-------------------------------------------------------------------------");
                MOut.G(this).print("Trap (" + (trapIndex + 1) + ")");
                parser.setup();
                for (UserTable userTable : listUserTable) {
                    byte[] decryptedPDU;
                    if (!parser.isUsernameMatch(trapV3, userTable.getName())) continue;
                    int authPtclEnum = AuthGeneric.getProtocolEnum(userTable.getAuthProtocol().getProtocol());
                    int privPtclEnum = PrivacyGeneric.getProtocolEnum(userTable.getPrivProtocol().getProtocol());
                    if (!parser.isAuthenticated(trapV3, userTable.getAuthPassword().getBytes(), authPtclEnum) || null == (decryptedPDU = parser.decrypt(trapV3, userTable.getPrivPassword().getBytes(), privPtclEnum, authPtclEnum)) || !parser.loadPDU(trapV3, decryptedPDU)) continue;
                    MOut.G(this).println(trapV3.dumpFormatTrap());
                    trapV3.flushTrap();
                    if (!parser.isLoadSuccessful()) continue;
                    break;
                }
                if (parser.isLoadSuccessful()) continue;
                MOut.G(this).println("\n" + parser.getErrorMessage());
            }
        } else {
            MOut.G(this).println("No trap received");
        }
        this.statusCode = 0;
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    private void init() {
        this.authProtocolEnum = 0;
        this.privProtocolEnum = 0;
        this.username = null;
        this.authPassword = null;
        this.privPassword = null;
    }

    private List<UserTable> getUsertableList() {
        List<UserTable> listUserTable = UserTableUtils.readPropertyFile(UserTableUtils.DEFAULT_FILE_PATH);
        if (this.username != null && this.authPassword != null && this.privPassword != null) {
            listUserTable.add(new UserTable(this.username, new AuthProtocol(AuthGeneric.getProtocolStr(this.authProtocolEnum)), this.authPassword, new PrivProtocol(PrivacyGeneric.getProtocolStr(this.privProtocolEnum)), this.privPassword));
        }
        return listUserTable;
    }

    private void usage() {
        MOut.G(this).println("");
        MOut.G(this).println("Usage: trap listV3 [<username> <authenticationProtocol> <authenticationPassword> <decryptionProtocol> <decryptionPassword>]");
        MOut.G(this).println("authenticationProtocol: ");
        MOut.G(this).println(" MD5   : 0");
        MOut.G(this).println(" " + (GlobalDefine.THALES_PROJECT ? "SHA96" : "SHA-1") + " : " + 1);
        MOut.G(this).println("decryptionProtocol: ");
        MOut.G(this).println(" DES    : 0");
        MOut.G(this).println(" AES128 : 1");
        MOut.G(this).println("authenticationPassword/decryptionPassword: ");
        MOut.G(this).println(" Need lowercase, uppercase and numbers. Should be in the range of 8-64 characters.");
    }
}

