/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.UserAccountHelper;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.Arrays;
import java.util.List;

public class UserEnableTypeCommand
extends SuperBladeCommand {
    private int userID;
    private int typeIndex;
    private boolean status;
    private String authProtocoIndex;
    private String privProtocoIndex;
    private String authKey;
    private String privKey;

    @Override
    public boolean preValidate() {
        block18: {
            block19: {
                String[] params;
                block20: {
                    int paramsCount;
                    block17: {
                        block16: {
                            params = super.getParameters();
                            int n = paramsCount = params != null ? params.length : 0;
                            if (params == null || paramsCount < 3) {
                                MOut.G(this).println("Not enough parameters");
                            } else {
                                try {
                                    this.userID = Integer.valueOf(params[0]);
                                    if (this.userID < 2 || 15 < this.userID) {
                                        MOut.G(this).println("user id is out of range");
                                    }
                                    break block16;
                                }
                                catch (NumberFormatException ex) {
                                    MOut.G(this).println("Invalid parameter <user id>");
                                }
                            }
                            break block18;
                        }
                        try {
                            this.typeIndex = Integer.valueOf(params[1]);
                            if (this.typeIndex != 0) {
                                MOut.G(this).println("Not supported account type");
                            }
                            break block17;
                        }
                        catch (NumberFormatException ex) {
                            MOut.G(this).println("Invalid parameter <type>");
                        }
                        break block18;
                    }
                    try {
                        int value = Integer.valueOf(params[2]);
                        if (value < 0 || 1 < value) {
                            MOut.G(this).println("Invalid parameter <status>");
                            break block18;
                        }
                        this.status = value == 1;
                    }
                    catch (NumberFormatException ex) {
                        MOut.G(this).println("Invalid parameter <status>");
                        break block18;
                    }
                    if (this.typeIndex != 0 || !this.status) break block19;
                    if (paramsCount >= 11) break block20;
                    MOut.G(this).println("Not enough parameters");
                    break block18;
                }
                if (!this.isValidOptionSNMP(params)) break block18;
            }
            return true;
        }
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB12RoTHW1GUID(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        Object[] params = new Object[]{this.authProtocoIndex, this.authKey, this.privProtocoIndex, this.privKey};
        UserAccountHelper helper = new UserAccountHelper();
        int result = helper.enableAccountType(super.getConfig(), this.userID, this.typeIndex, this.status, params);
        switch (result) {
            case 0: {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                break;
            }
            case 18: {
                MOut.G(this).println("User ID " + this.userID + " is disabled");
                this.statusCode = 149;
                break;
            }
            default: {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        }
    }

    private void usage() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Usage: user enableType <user id> <type> <status> [options]").append(lineSeparator);
        strBuilder.append("user id:").append(lineSeparator);
        strBuilder.append("  2 ~ 16 - enabled user id").append(lineSeparator);
        strBuilder.append("type:").append(lineSeparator);
        strBuilder.append("  0 - SNMP").append(lineSeparator);
        strBuilder.append("status:").append(lineSeparator);
        strBuilder.append("  0 - Disable").append(lineSeparator);
        strBuilder.append("  1 - Enable").append(lineSeparator);
        strBuilder.append("----------------------------------------------------------").append(lineSeparator);
        strBuilder.append("options:").append(lineSeparator);
        strBuilder.append(" * If enable SNMP type, following options are mandatory").append(lineSeparator);
        strBuilder.append(" * Key require 8 to 64 characters includes at least").append(lineSeparator);
        strBuilder.append("   3 of character classes from 'a-z', 'A-Z', '0-9'").append(lineSeparator);
        strBuilder.append(" * Example: user enableType 3 0 1 -ap 0 -pp 0 -ak P@ssw0rd -pk P@ssw0rd").append(lineSeparator);
        strBuilder.append("-ap: authentication protocol").append(lineSeparator);
        strBuilder.append("  0 - " + SNMPBaseCommand.SNMP_AUTH_PROTOCOL_ABBR_MD5).append(lineSeparator);
        strBuilder.append("  1 - " + SNMPBaseCommand.SNMP_AUTH_PROTOCOL_ABBR_SHA).append(lineSeparator);
        strBuilder.append("-pp: private protocol").append(lineSeparator);
        strBuilder.append("  0 - " + SNMPBaseCommand.SNMP_PRIV_PROTOCOL_ABBR_DES).append(lineSeparator);
        strBuilder.append("  1 - " + SNMPBaseCommand.SNMP_PRIV_PROTOCOL_ABBR_AES).append(lineSeparator);
        strBuilder.append("-ak: authentication key").append(lineSeparator);
        strBuilder.append("-pk: private key");
        MOut.G(this).println(strBuilder.toString());
    }

    private String getOptionValue(List<String> paramsList, String key) {
        if (paramsList.contains(key) && paramsList.indexOf(key) != paramsList.size() - 1) {
            return paramsList.get(paramsList.indexOf(key) + 1);
        }
        return null;
    }

    private boolean isValidOptionSNMP(String[] params) {
        List<String> paramsList = Arrays.asList(params);
        this.authProtocoIndex = this.getOptionValue(paramsList, "-ap");
        this.privProtocoIndex = this.getOptionValue(paramsList, "-pp");
        this.authKey = this.getOptionValue(paramsList, "-ak");
        this.privKey = this.getOptionValue(paramsList, "-pk");
        if (this.authProtocoIndex == null || this.privProtocoIndex == null || this.authKey == null || this.privKey == null) {
            MOut.G(this).println("Invalid options");
        } else if (!UserAccountHelper.isValidSNMPPasswordLength(this.authKey) || !UserAccountHelper.isValidSNMPPasswordSecurityPolicy(this.authKey)) {
            MOut.G(this).println("Authentication Key require 8 to 64 characters includes at least 3 of character classes from 'a-z', 'A-Z', '0-9'");
        } else if (!UserAccountHelper.isValidSNMPPasswordLength(this.privKey) || !UserAccountHelper.isValidSNMPPasswordSecurityPolicy(this.privKey)) {
            MOut.G(this).println("Private Key require 8 to 64 characters includes at least 3 of character classes from 'a-z', 'A-Z', '0-9'");
        } else {
            return true;
        }
        return false;
    }
}

