/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIWatchdogCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class WatchdogSetCommand
extends SuperBladeCommand {
    int action;
    int interval;
    int countdown;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 3) {
            try {
                this.action = Byte.parseByte(this.parameters[0], 10);
                if (this.action < 0 || this.action > 3) {
                    MOut.G(this).println("Action out of range.");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Parameter is not valid");
                this.printUsage();
                return false;
            }
            try {
                this.countdown = Integer.parseInt(this.parameters[1], 10);
                if (this.countdown > 6553 || this.countdown < 0) {
                    MOut.G(this).println("Countdown out of range.");
                    return false;
                }
                this.countdown *= 10;
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Parameter is not valid");
                this.printUsage();
                return false;
            }
            try {
                this.interval = Integer.parseInt(this.parameters[2], 10);
                if (this.interval > 255 || this.interval < 0) {
                    MOut.G(this).println("Interval out of range.");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Parameter is not valid");
                this.printUsage();
                return false;
            }
            if (Integer.parseInt(this.parameters[1]) - Integer.parseInt(this.parameters[2]) < 3) {
                MOut.G(this).println("Parameter is not valid");
                this.printCount();
                return false;
            }
            return true;
        }
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIWatchdogCommand ipmiWatchdogCommand = new IPMIWatchdogCommand(null);
        ipmiWatchdogCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiWatchdogCommand.SetTimer(this.action, this.interval, this.countdown)) {
            MOut.G(this).printf("Set Watchdog Timer Successfully", new Object[0]);
        } else {
            MOut.G(this).printf("Set Watchdog Timer Failure", new Object[0]);
        }
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("Usage: watchdog set <action> <countdown> <interval>");
        MOut.G(this).println("action   : Time out action index");
        MOut.G(this).println("           0: No action");
        MOut.G(this).println("           1: Hard reset");
        MOut.G(this).println("           2: Power down");
        MOut.G(this).println("           3: Power cycle");
        MOut.G(this).println("countdown: Initial count down value");
        MOut.G(this).println("interval : Pre-timeout interval in seconds");
    }

    public void printCount() {
        MOut.G(this).println("Hint: To avoid race condition");
        MOut.G(this).println("Please set the Interval no closer than 3 counts");
        MOut.G(this).println("Before the Timeout value is reached.");
    }
}

