/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.parser;

import com.supermicro.ipmi.trap.AsnDecodingException;
import com.supermicro.ipmi.trap.BerDecoder;
import com.supermicro.ipmi.trap.parser.BaseParser;
import com.supermicro.ipmi.trap.parser.SNMPv1Parser;
import com.supermicro.ipmi.trap.parser.SNMPv3Parser;

public class ParserFactory {
    public static BaseParser getTrapParser(byte[] dataBuffer) {
        int trapType = ParserFactory.identifyTrap(dataBuffer);
        BaseParser concreteParser = null;
        switch (trapType) {
            case 0: {
                concreteParser = new SNMPv1Parser();
                break;
            }
            case 1: {
                concreteParser = new SNMPv3Parser();
                break;
            }
            case 2: {
                System.out.println("Redfish is not supported yet.");
                break;
            }
            case 3: {
                System.out.println("SMTP is not supported yet.");
                break;
            }
            default: {
                System.out.println("Trap is unknonwn. Parser cannot identify it.");
            }
        }
        return concreteParser;
    }

    private static int identifyTrap(byte[] dataBuffer) {
        BerDecoder berDecoder = new BerDecoder();
        Object[] value = null;
        try {
            value = berDecoder.parseHeader(dataBuffer, 0);
            value = berDecoder.parseInteger32(dataBuffer, (Integer)value[0]);
        }
        catch (AsnDecodingException e) {
            e.printStackTrace();
        }
        if (value != null) {
            int type = (Integer)value[2];
            if (type == 0) {
                return 0;
            }
            if (type == 3) {
                return 1;
            }
            return -1;
        }
        return -1;
    }
}

