/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.trap.parser;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.trap.AsnDecodingException;
import com.supermicro.ipmi.trap.PETAcknowledge;
import com.supermicro.ipmi.trap.parser.BaseParser;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.SNMPv1Trap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;

public class SNMPv1Parser
extends BaseParser {
    @Override
    public BaseTrap decode(byte[] dataBuffer, int dataLength) {
        int offset = 0;
        SNMPv1Trap trap = new SNMPv1Trap();
        try {
            offset = this.getMessagePreamble(trap, dataBuffer, offset);
            offset = this.getPDUHeader(trap, dataBuffer, offset);
            offset = this.getPDUBody(trap, dataBuffer, offset, dataLength);
        }
        catch (AsnDecodingException e) {
            e.printStackTrace();
        }
        trap.copyDataBuff(dataBuffer);
        trap.setDataLength(dataLength);
        return trap;
    }

    private int getMessagePreamble(SNMPv1Trap trap, byte[] databuff, int offset) throws AsnDecodingException {
        offset = this.getMessageLength(trap, this.berDecoder.parseHeader(databuff, offset));
        offset = this.getMessageVersion(trap, this.berDecoder.parseInteger32(databuff, offset));
        offset = this.getCommunity(trap, this.berDecoder.parseString(databuff, offset));
        return offset;
    }

    private int getPDUHeader(SNMPv1Trap trap, byte[] databuff, int offset) throws AsnDecodingException {
        offset = this.getPDUType(trap, this.berDecoder.parseHeader(databuff, offset));
        offset = this.getEnterpriseMIB(trap, this.berDecoder.parseObjectId(databuff, offset));
        offset = this.getAgentIP(trap, this.berDecoder.parseInteger32(databuff, offset));
        offset = this.getGTrapType(trap, this.berDecoder.parseInteger32(databuff, offset));
        offset = this.getSTrapType(trap, this.berDecoder.parseInteger32(databuff, offset));
        offset = this.getTimeStamp(trap, this.berDecoder.parseUInteger64(databuff, offset));
        return offset;
    }

    private int getPDUBody(SNMPv1Trap trap, byte[] databuff, int offset, int datalength) throws AsnDecodingException {
        offset = this.getLengthBind(trap, this.berDecoder.parseHeader(databuff, offset));
        while (offset < datalength) {
            offset = this.getBindLength(trap, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getBind(trap, databuff, offset);
        }
        return offset;
    }

    private int getMessageLength(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Length: " + xx);
        trap.setMessageLength(Integer.parseInt("" + xx));
        xx = (Integer)value[0];
        return xx;
    }

    private int getMessageVersion(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Version: v" + (xx + 1));
        xx = (Integer)value[0];
        return xx;
    }

    private int getCommunity(SNMPv1Trap trap, Object[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        try {
            strout.write((byte[])value[2]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String yy = strout.toString();
        String string = new String("Community: " + yy);
        trap.setCommunity(yy);
        int xx = (Integer)value[0];
        return xx;
    }

    private int getPDUType(SNMPv1Trap trap, Object[] value) {
        byte zz = (Byte)value[1];
        String string = zz == -92 ? new String("Type: Trap") : new String("Type: unknown");
        int xx = (Integer)value[2];
        string = new String("length: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getEnterpriseMIB(SNMPv1Trap trap, Object[] value) {
        String string = new String("");
        int[] xx = (int[])value[2];
        int xxl = xx.length;
        string = "" + xx[0];
        for (int i = 1; i < xxl; ++i) {
            string = string + "." + xx[i];
        }
        trap.setEnterprise(string);
        string = new String("Enterprise: " + string);
        int yy = (Integer)value[0];
        return yy;
    }

    private int getAgentIP(SNMPv1Trap trap, Object[] value) {
        String string = new String("");
        int xx = (Integer)value[2];
        StringBuffer buf = new StringBuffer();
        buf.append(xx >> 24 & 0xFF);
        buf.append('.');
        buf.append(xx >> 16 & 0xFF);
        buf.append('.');
        buf.append(xx >> 8 & 0xFF);
        buf.append('.');
        buf.append(xx & 0xFF);
        trap.setIp(buf.toString());
        string = new String("Agent IP: " + buf);
        xx = (Integer)value[0];
        return xx;
    }

    private int getGTrapType(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Generic Trap Type: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getSTrapType(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        if ((xx & 0x80) == 128) {
            trap.setAssertionType(1);
        } else {
            trap.setAssertionType(0);
        }
        trap.setEventSensorType((byte)(xx >> 16));
        trap.setEventType((byte)(xx >> 8));
        trap.setEventOffset((byte)xx);
        String string = new String("Specific Trap Type: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getTimeStamp(SNMPv1Trap trap, Object[] value) {
        long yy = ((BigInteger)value[2]).longValue();
        String string = new String("Timeticks : " + yy);
        int xx = (Integer)value[0];
        return xx;
    }

    private int getLengthBind(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Total Length of Variable Binding: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getBindLength(SNMPv1Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Length of Binding: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getBind(SNMPv1Trap trap, byte[] databuff, int offset) throws AsnDecodingException {
        Object[] value = new Object[3];
        String string = new String("");
        value = this.berDecoder.parseObjectId(databuff, offset);
        int[] xx = (int[])value[2];
        int xxl = xx.length;
        string = "" + xx[0];
        for (int i = 1; i < xxl; ++i) {
            string = string + "." + xx[i];
        }
        trap.setOid(string);
        string = new String("OID: " + string);
        offset = (Integer)value[0];
        value = this.berDecoder.parseString(databuff, offset);
        if (string.compareTo("OID: 1.3.6.1.4.1.3183.1.1.1") == 0) {
            this.parsePET(trap, (byte[])value[2]);
        } else {
            ByteArrayOutputStream strout = new ByteArrayOutputStream();
            try {
                strout.write((byte[])value[2]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String yy = strout.toString();
            string = new String("Value: " + yy);
            trap.setDescription(string);
        }
        offset = (Integer)value[0];
        return offset;
    }

    private void parsePET(SNMPv1Trap trap, byte[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        PETAcknowledge petAck = new PETAcknowledge();
        System.arraycopy(value, 16, petAck.sequenceNumber, 0, 2);
        System.arraycopy(value, 18, petAck.timestamp, 0, 4);
        petAck.sequenceNumber = this.reverse(petAck.sequenceNumber);
        petAck.timestamp = this.reverse(petAck.timestamp);
        petAck.eventSourceType = value[25];
        petAck.sensorDevice = value[27];
        petAck.sensorNumber = value[28];
        System.arraycopy(value, 31, petAck.eventData, 0, 3);
        trap.setPETAck(petAck);
        byte[] b = new byte[4];
        System.arraycopy(value, 18, b, 0, 4);
        long localTimeStamp = ByteUtility.fourBytesToLong(b);
        SimpleTimeZone stz = new SimpleTimeZone(0, "PST");
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss EEE");
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        c.add(1, 28);
        c.add(13, (int)localTimeStamp);
        Date d = c.getTime();
        f.setTimeZone(stz);
        trap.setTime(f.format(d));
        byte[] eventData = null;
        byte genericOffset = 0;
        byte sensorNumber = 0;
        int length = 0;
        byte recordType = 0;
        byte sensorType = 0;
        long timeStamp = 0L;
        byte[] sensorName = null;
        String description = null;
        for (int j = 46; j < value.length; ++j) {
            if ((value[j] & 0xFF) != 128) continue;
            eventData = new byte[3];
            System.arraycopy(value, 31, eventData, 0, 3);
            genericOffset = (byte)(eventData[0] & 0xF);
            sensorNumber = value[28];
            length = value[j + 1] & 0x3F;
            recordType = value[j + 2];
            sensorType = value[j + 3];
            sensorName = new byte[length];
            if (trap.getEventSensorType() == -36) {
                description = GlobalDefine.LookupMEEventType(sensorNumber, trap.getEventType(), trap.getEventOffset(), eventData[0], eventData[1], eventData[2]);
                trap.setSensor(GlobalDefine.LookupMESensor(sensorNumber));
            } else if (sensorType == 1 || sensorType == 2 || sensorType == 3 || sensorType == 4) {
                description = GlobalDefine.LookupEventType((byte)1, genericOffset);
                System.arraycopy(value, j + 4, sensorName, 0, length);
                trap.setSensor(new String(sensorName));
            } else {
                description = GlobalDefine.LookupSensorType(sensorType, eventData[0], eventData[1], eventData[2]);
                System.arraycopy(value, j + 4, sensorName, 0, length);
                trap.setSensor(new String(sensorName));
            }
            if (length == 0) {
                if ((sensorType & 0xFF) >= 193 && (sensorType & 0xFF) <= 197 && trap.getEventType() != 112) {
                    trap.setSensor(GlobalDefine.getSensorType(sensorType & 0xFF, eventData[0]));
                } else {
                    Object sensorNameObj = SDRRecord.sensorNumberToSensorName.get("" + (sensorNumber & 0xFF));
                    if (sensorNameObj != null) {
                        trap.setSensor((String)sensorNameObj);
                    }
                }
            }
            trap.setDescription(description);
            break;
        }
        String string = "";
        boolean quota = false;
        boolean square = false;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] < 32 || value[i] > 126) {
                if (!square) {
                    if (quota) {
                        string = string + "\"";
                        quota = false;
                    }
                    string = string + "[";
                    square = true;
                }
                string = string + "x" + new String(Integer.toHexString(this.byteToInt(value[i]))).toUpperCase();
                continue;
            }
            if (!quota) {
                if (square) {
                    string = string + "]";
                    square = false;
                }
                string = string + "\"";
                quota = true;
            }
            strout.write(value, i, 1);
            String yy = strout.toString();
            string = string + yy;
        }
        if (square) {
            string = string + "]";
        }
        if (quota) {
            string = string + "\"";
        }
    }

    private byte[] reverse(byte[] array) {
        int arraySize = array.length;
        byte[] reverseArray = new byte[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            reverseArray[i] = array[arraySize - i - 1];
        }
        return reverseArray;
    }

    private int byteToInt(byte b) {
        return b < 0 ? 256 + b : b;
    }
}

