/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.BIOSConfigurationBaseCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;

public class BIOSConfigurationLoadCommand
extends BIOSConfigurationBaseCommand {
    public static final String BIOS_PATCH_PREFIX = "{\"Attributes\":{";
    public static final String BIOS_PATCH_SUFFIX = "}}";
    public static final int REDFISH_CHUNK_SIZE = 4096;

    @Override
    public boolean preValidate() {
        if (super.getParameters() == null) {
            MOut.G(this).println("File name is empty");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!super.isCommandAvailable()) {
            return;
        }
        String filename = this.parameters[0];
        File inputFile = null;
        FileInputStream inputStream = null;
        try {
            inputFile = new File(filename);
            inputStream = new FileInputStream(inputFile);
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println("Failed");
            this.statusCode = 149;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Properties prop = new Properties();
        prop.load(inputStream);
        prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            try {
                super.getHelper().setAttributeBatch((String)key, (String)value, stringBuffer);
            }
            catch (Exception e) {
                this.statusCode = 149;
            }
            if (stringBuffer.length() > 4096) {
                this.statusCode |= this.setRedfishPatch(stringBuffer) ? 0 : 149;
                stringBuffer.setLength(0);
            }
        }));
        if (stringBuffer.length() != 0) {
            this.statusCode |= this.setRedfishPatch(stringBuffer) ? 0 : 149;
        }
        if (this.statusCode == 0) {
            MOut.G(this).println("Done");
            MOut.G(this).println("Note: BIOS settings will be applied after next boot");
        } else {
            MOut.G(this).println("Failed");
        }
        if (inputStream != null) {
            ((InputStream)inputStream).close();
        }
    }

    private boolean setRedfishPatch(StringBuffer stringBuffer) {
        boolean result = true;
        if (stringBuffer.length() > 0) {
            StringBuffer patchBodyStrBuffer = new StringBuffer();
            patchBodyStrBuffer.append(BIOS_PATCH_PREFIX);
            patchBodyStrBuffer.append(stringBuffer);
            patchBodyStrBuffer.append(BIOS_PATCH_SUFFIX);
            try {
                result = super.getHelper().setAttributeCollectionBuffer(patchBodyStrBuffer);
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                    MOut.G(this).println("Run patch body: " + stringBuffer.length() + " bytes, " + result);
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }
}

