/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class HardwareInfoCommand
extends RedfishTokenCommand {
    boolean isMore = false;

    @Override
    public boolean preValidate() {
        this.isMore = false;
        if (this.parameters != null) {
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                if (!this.parameters[idx].equals("--more")) continue;
                this.isMore = true;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        JsonNode model;
        JsonNode type;
        JsonNode pnode;
        int result2;
        String formatTemplate;
        JsonNode member;
        JsonNode node;
        ObjectMapper mapper;
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Systems/1/" + "Processors";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            StringBuffer fStr;
            JsonNode threads;
            JsonNode cores;
            JsonNode tdp;
            JsonNode speed;
            JsonNode manufacturer;
            JsonNode architecture;
            JsonNode socket;
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            if (this.isMore) {
                formatTemplate = " %-25s | %-45s |\n";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Processors");
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result2 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        socket = pnode.path("Socket");
                        type = pnode.path("ProcessorType");
                        architecture = pnode.path("ProcessorArchitecture");
                        manufacturer = pnode.path("Manufacturer");
                        model = pnode.path("Model");
                        speed = pnode.path("MaxSpeedMHz");
                        tdp = pnode.path("MaxTDPWatts");
                        cores = pnode.findPath("TotalCores");
                        threads = pnode.findPath("TotalThreads");
                        fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, "ProcessorType", type.asText()));
                        fStr.append(String.format(formatTemplate, "Socket", socket.asText()));
                        fStr.append(String.format(formatTemplate, "ProcessorArchitecture", architecture.asText()));
                        fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                        fStr.append(String.format(formatTemplate, "Model", model.asText()));
                        fStr.append(String.format(formatTemplate, "Speed", speed.asText() + " MHz"));
                        fStr.append(String.format(formatTemplate, "TDP Watts", tdp.asText()));
                        fStr.append(String.format(formatTemplate, "TotalCores", cores.asText()));
                        fStr.append(String.format(formatTemplate, "TotalThreads", threads.asText()));
                        MOut.G(this).println(fStr.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                    }
                }
            } else {
                formatTemplate = " %-6s | %-20s | %-46s | %-10s | %-10s |";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Processors");
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    MOut.G(this).println(String.format(formatTemplate, "Socket", "Manufacturer", "Model", "MaxSpeed", "TotalCores"));
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result2 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        socket = pnode.path("Socket");
                        type = pnode.path("ProcessorType");
                        architecture = pnode.path("ProcessorArchitecture");
                        manufacturer = pnode.path("Manufacturer");
                        model = pnode.path("Model");
                        speed = pnode.path("MaxSpeedMHz");
                        tdp = pnode.path("MaxTDPWatts");
                        cores = pnode.findPath("TotalCores");
                        threads = pnode.findPath("TotalThreads");
                        fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, socket.asText(), this.cutString(manufacturer.asText(), 20), this.cutString(model.asText(), 46).trim(), speed.asText() + " MHz", cores.asText()));
                        MOut.G(this).println(fStr.toString());
                    }
                }
            }
        }
        if ((result = this.sessionLoginClient.send_https_get(url = "https://" + ip + "/redfish/v1/Systems/1/" + "Memory")) == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            JsonNode module;
            JsonNode locator;
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            if (this.isMore) {
                formatTemplate = " %-25s | %-45s |\n";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Memory");
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result2 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        locator = pnode.path("DeviceLocator");
                        type = pnode.path("MemoryDeviceType");
                        JsonNode memoryType = pnode.path("MemoryType");
                        JsonNode correction = pnode.path("ErrorCorrection");
                        JsonNode speed = pnode.path("OperatingSpeedMhz");
                        JsonNode size = pnode.path("CapacityMiB");
                        JsonNode manufacturer = pnode.path("Manufacturer");
                        JsonNode serialNumber = pnode.path("SerialNumber");
                        JsonNode partNumber = pnode.path("PartNumber");
                        module = pnode.path("BaseModuleType");
                        JsonNode databits = pnode.path("DataWidthBits");
                        JsonNode busbits = pnode.path("BusWidthBits");
                        StringBuffer fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, "Locator", locator.asText()));
                        fStr.append(String.format(formatTemplate, "MemoryType", memoryType.asText()));
                        fStr.append(String.format(formatTemplate, "DeviceType", type.asText()));
                        fStr.append(String.format(formatTemplate, "Operating Speed", speed.asText() + " MHz"));
                        fStr.append(String.format(formatTemplate, "Size", size.asText() + " MB"));
                        fStr.append(String.format(formatTemplate, "ErrorCorrection", correction.asText()));
                        fStr.append(String.format(formatTemplate, "ModuleType", module.asText()));
                        fStr.append(String.format(formatTemplate, "DataWidthBits", databits.asText()));
                        fStr.append(String.format(formatTemplate, "BusWidthBits", busbits.asText()));
                        fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
                        fStr.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
                        fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                        MOut.G(this).println(fStr.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                    }
                }
            } else {
                formatTemplate = " %-10s | %-15s | %-15s | %-8s | %-21s | %-20s |";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Memory");
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    MOut.G(this).println(String.format(formatTemplate, "Locator", "MemoryType", "OperatingSpeed", "Size", "Manufacturer", "SerialNumber"));
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result2 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        locator = pnode.path("DeviceLocator");
                        type = pnode.path("MemoryDeviceType");
                        JsonNode correction = pnode.path("ErrorCorrection");
                        JsonNode speed = pnode.path("OperatingSpeedMhz");
                        JsonNode size = pnode.path("CapacityMiB");
                        JsonNode manufacturer = pnode.path("Manufacturer");
                        JsonNode serialNumber = pnode.path("SerialNumber");
                        JsonNode partNumber = pnode.path("PartNumber");
                        JsonNode memoryType = pnode.path("MemoryType");
                        module = pnode.path("BaseModuleType");
                        StringBuffer fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, locator.asText(), this.cutString(memoryType.asText(), 15), speed.asText() + " MHz", size.asText() + " MB", manufacturer.asText().trim(), serialNumber.asText()));
                        MOut.G(this).println(fStr.toString());
                    }
                }
            }
        }
        if ((result = this.sessionLoginClient.send_https_get(url = "https://" + ip + "/redfish/v1/Chassis/1/" + "PCIeDevices")) >= 200 && result <= 210) {
            JsonNode serialNumber;
            JsonNode gpuVendor;
            JsonNode manufacturer;
            JsonNode item;
            JsonNode device;
            StringBuffer fStr;
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            if (this.isMore) {
                formatTemplate = " %-25s | %-45s |\n";
                if (member.isArray()) {
                    MOut.G(this).println("\n  PCIeDevices");
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        JsonNode oemSupermicro;
                        JsonNode oem;
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result > 210) continue;
                        fStr = new StringBuffer();
                        device = mapper.readTree(this.sessionLoginClient.getResponseString());
                        item = device.path("Id");
                        manufacturer = device.path("Manufacturer");
                        gpuVendor = device.path("GPUVendor");
                        model = device.path("Model");
                        serialNumber = device.path("SerialNumber");
                        JsonNode partNumber = device.path("PartNumber");
                        JsonNode fwVersion = device.path("FirmwareVersion");
                        JsonNode interfaces = device.path("PCIeInterface");
                        JsonNode type2 = interfaces.path("PCIeType");
                        JsonNode maxType = interfaces.path("MaxPCIeType");
                        JsonNode lanesInUse = interfaces.path("LanesInUse");
                        JsonNode maxLanes = interfaces.path("MaxLanes");
                        String manufactureVender = manufacturer.asText();
                        if ("".equals(manufactureVender) && !"".equals(gpuVendor.asText())) {
                            manufactureVender = gpuVendor.asText();
                        } else if ("".equals(manufactureVender) && "".equals(gpuVendor.asText()) && (oem = device.path("Oem")) != null && (oemSupermicro = oem.path("Supermicro")) != null) {
                            manufactureVender = oemSupermicro.path("GPUVendor").asText();
                        }
                        fStr.append(String.format(formatTemplate, "Item", item.asText()));
                        fStr.append(String.format(formatTemplate, "Manufacturer", manufactureVender));
                        fStr.append(String.format(formatTemplate, "Model", model.asText()));
                        fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText()));
                        fStr.append(String.format(formatTemplate, "PartNumber", partNumber.asText()));
                        fStr.append(String.format(formatTemplate, "FirmwareVersion", fwVersion.asText()));
                        fStr.append(String.format(formatTemplate, "PCIeType", type2.asText()));
                        fStr.append(String.format(formatTemplate, "MaxPCIeType", maxType.asText()));
                        fStr.append(String.format(formatTemplate, "LanesInUse", lanesInUse.asText()));
                        fStr.append(String.format(formatTemplate, "MaxLanes", maxLanes.asText()));
                        MOut.G(this).println(fStr.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                    }
                }
            } else {
                formatTemplate = " %-10s | %-20s | %-20s | %-27s | %-15s |";
                if (member.isArray()) {
                    MOut.G(this).println("\n  PCIeDevices");
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    MOut.G(this).println(String.format(formatTemplate, "Item", "Manufacturer", "Model", "SerialNumber", "FirmwareVersion"));
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        JsonNode oemSupermicro;
                        JsonNode oem;
                        url = "https://" + ip + l.path("@odata.id").asText();
                        result2 = this.sessionLoginClient.send_https_get(url);
                        if (result2 < 200 || result > 210) continue;
                        fStr = new StringBuffer();
                        device = mapper.readTree(this.sessionLoginClient.getResponseString());
                        item = device.path("Id");
                        manufacturer = device.path("Manufacturer");
                        gpuVendor = device.path("GPUVendor");
                        model = device.path("Model");
                        serialNumber = device.path("SerialNumber");
                        JsonNode fwVersion = device.path("FirmwareVersion");
                        String manufactureVender = manufacturer.asText();
                        if ("".equals(manufactureVender) && !"".equals(gpuVendor.asText())) {
                            manufactureVender = gpuVendor.asText();
                        } else if ("".equals(manufactureVender) && "".equals(gpuVendor.asText()) && (oem = device.path("Oem")) != null && (oemSupermicro = oem.path("Supermicro")) != null) {
                            manufactureVender = oemSupermicro.path("GPUVendor").asText();
                        }
                        fStr.append(String.format(formatTemplate, this.cutString(item.asText(), 9), this.cutString(manufactureVender, 20), this.cutString(model.asText().trim(), 20), this.cutString(serialNumber.asText().trim(), 27), this.cutString(fwVersion.asText(), 15)));
                        MOut.G(this).println(fStr.toString());
                    }
                }
            }
        }
        if ((result = this.sessionLoginClient.send_https_get(url = "https://" + ip + "/redfish/v1/Chassis/1/" + "Power")) >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode psu = node.path("PowerSupplies");
            if (this.isMore) {
                formatTemplate = " %-25s | %-45s |\n";
                if (psu.isArray()) {
                    MOut.G(this).println("\n  PSU");
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (psu.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                }
                for (JsonNode l : psu) {
                    StringBuffer fStr = new StringBuffer();
                    JsonNode sensorNumber = l.path("SensorNumber");
                    JsonNode model2 = l.path("Model");
                    JsonNode version = l.path("FirmwareVersion");
                    JsonNode serialNumber = l.path("SerialNumber");
                    JsonNode type3 = l.path("PowerSupplyType");
                    JsonNode powerWatts = l.path("PowerCapacityWatts");
                    fStr.append(String.format(formatTemplate, "Model", model2.asText().trim()));
                    fStr.append(String.format(formatTemplate, "SerialNumber", serialNumber.asText().trim()));
                    fStr.append(String.format(formatTemplate, "Type", type3.asText()));
                    fStr.append(String.format(formatTemplate, "CapacityWatts", powerWatts.asText().length() == 0 ? "" : powerWatts.asText() + " W"));
                    fStr.append(String.format(formatTemplate, "FirmwareVersion", version.asText().indexOf("REV") == 0 ? version.asText().substring(3) : version.asText()));
                    fStr.append(String.format(formatTemplate, "SensorNumber", sensorNumber.asText()));
                    MOut.G(this).println(fStr.toString());
                    MOut.G(this).println("---------------------------------------------------------------------------");
                }
            } else {
                formatTemplate = " %-25s | %-27s | %-10s | %-15s | %-15s |";
                if (psu.isArray()) {
                    MOut.G(this).println("\n  PSU");
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    MOut.G(this).println(String.format(formatTemplate, "Model", "SerialNumber", "Type", "CapacityWatts", "FirmwareVersion"));
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    if (psu.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : psu) {
                        StringBuffer fStr = new StringBuffer();
                        JsonNode model3 = l.path("Model");
                        JsonNode version = l.path("FirmwareVersion");
                        JsonNode serialNumber = l.path("SerialNumber");
                        JsonNode type4 = l.path("PowerSupplyType");
                        JsonNode powerWatts = l.path("PowerCapacityWatts");
                        fStr.append(String.format(formatTemplate, model3.asText().trim(), serialNumber.asText().trim(), type4.asText(), powerWatts.asText().length() == 0 ? "" : powerWatts.asText() + " W", version.asText().indexOf("REV") == 0 ? version.asText().substring(3) : version.asText()));
                        MOut.G(this).println(fStr.toString());
                    }
                }
            }
        }
        if ((result = this.sessionLoginClient.send_https_get(url = "https://" + ip + "/redfish/v1/Systems/1/" + "Storage/")) >= 200 && result <= 210) {
            mapper = new ObjectMapper();
            node = mapper.readTree(this.sessionLoginClient.getResponseString());
            member = node.path("Members");
            if (this.isMore) {
                formatTemplate = " %-25s | %-45s |\n";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Storage");
                    MOut.G(this).println("---------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        int result22 = this.sessionLoginClient.send_https_get(url);
                        if (result22 < 200 || result22 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        JsonNode id = pnode.path("Id");
                        JsonNode manufacturer = pnode.path("Manufacturer");
                        JsonNode model4 = pnode.path("Model");
                        JsonNode fwVersion = pnode.findPath("FirmwareVersion");
                        StringBuffer fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, "ID", id.asText()));
                        fStr.append(String.format(formatTemplate, "Manufacturer", manufacturer.asText()));
                        fStr.append(String.format(formatTemplate, "Model", model4.asText()));
                        fStr.append(String.format(formatTemplate, "FirmwareVersion", fwVersion.asText()));
                        MOut.G(this).println(fStr.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                        if (!url.contains("NVMeSSD") && !url.contains("HA-RAID")) continue;
                        JsonNode drives = pnode.path("Drives");
                        for (JsonNode drive : drives) {
                            String url_drive = "https://" + ip + drive.path("@odata.id").asText();
                            int result3 = this.sessionLoginClient.send_https_get(url_drive);
                            if (result3 < 200 || result3 > 210) continue;
                            JsonNode dnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                            JsonNode d_id = dnode.path("Id");
                            JsonNode d_status = dnode.path("Status");
                            JsonNode d_state = d_status.path("State");
                            JsonNode d_health = d_status.path("Health");
                            JsonNode d_manufacturer = dnode.path("Manufacturer");
                            JsonNode d_serial = dnode.path("SerialNumber");
                            JsonNode d_led = dnode.path("IndicatorLED");
                            JsonNode d_mediaType = dnode.path("MediaType");
                            JsonNode d_capacity = dnode.path("CapacityBytes");
                            StringBuffer fStr2 = new StringBuffer();
                            fStr2.append(String.format(formatTemplate, "ID", d_id.asText()));
                            fStr2.append(String.format(formatTemplate, "State", d_state.asText()));
                            fStr2.append(String.format(formatTemplate, "Health", d_health.asText()));
                            fStr2.append(String.format(formatTemplate, "Manufacturer", d_manufacturer.asText()));
                            fStr2.append(String.format(formatTemplate, "SerialNumber", d_serial.asText()));
                            fStr2.append(String.format(formatTemplate, "IndicatorLED", d_led.asText()));
                            fStr2.append(String.format(formatTemplate, "MediaType", d_mediaType.asText()));
                            fStr2.append(String.format(formatTemplate, "CapacityBytes", d_capacity.asText()));
                            MOut.G(this).print(fStr2.toString());
                            MOut.G(this).println("---------------------------------------------------------------------------");
                        }
                    }
                }
            } else {
                formatTemplate = " %-17s | %-23s | %-17s | %-15s | %-20s |";
                if (member.isArray()) {
                    MOut.G(this).println("\n  Storage");
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    MOut.G(this).println(String.format(formatTemplate, "ID", "Manufacturer", "SerialNumber", "Type", "CapacityBytes"));
                    MOut.G(this).println("-----------------------------------------------------------------------------------------------------------");
                    if (member.size() == 0) {
                        MOut.G(this).println(" None");
                    }
                    for (JsonNode l : member) {
                        url = "https://" + ip + l.path("@odata.id").asText();
                        int result23 = this.sessionLoginClient.send_https_get(url);
                        if (result23 < 200 || result23 > 210) continue;
                        pnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                        if (!url.contains("NVMeSSD") && !url.contains("HA-RAID")) continue;
                        JsonNode drives = pnode.path("Drives");
                        for (JsonNode drive : drives) {
                            String url_drive = "https://" + ip + drive.path("@odata.id").asText();
                            int result3 = this.sessionLoginClient.send_https_get(url_drive);
                            if (result3 < 200 || result3 > 210) continue;
                            JsonNode dnode = mapper.readTree(this.sessionLoginClient.getResponseString());
                            JsonNode d_id = dnode.path("Id");
                            JsonNode d_manufacturer = dnode.path("Manufacturer");
                            JsonNode d_serial = dnode.path("SerialNumber");
                            JsonNode d_mediaType = dnode.path("MediaType");
                            JsonNode d_capacity = dnode.path("CapacityBytes");
                            StringBuffer fStr2 = new StringBuffer();
                            fStr2.append(String.format(formatTemplate, d_id.asText().trim(), d_manufacturer.asText().trim(), d_serial.asText().trim(), d_mediaType.asText().trim(), d_capacity.asText().trim()));
                            MOut.G(this).println(fStr2.toString());
                        }
                    }
                }
            }
        }
        this.statusCode = 0;
    }

    public String cutString(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length - 1);
        }
        return s;
    }
}

