/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class IPCtrlListCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode ServiceEnabled = node.path("ServiceEnabled");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/" + "FilterRules";
                int result2 = this.sessionLoginClient.send_https_get(url);
                if (result2 == 404) {
                    MOut.G(this).println("404 not found");
                    this.statusCode = 153;
                    return;
                }
                if (result2 >= 200 && result2 <= 210) {
                    mapper = new ObjectMapper();
                    node = mapper.readTree(this.sessionLoginClient.getResponseString());
                    JsonNode member = node.path("Members");
                    String formatTemplate = " %-10s | %-40s | %10s\n";
                    StringBuffer header = new StringBuffer();
                    header.append(String.format(formatTemplate, "Rule No", "IP Address/Prefix", "Policy"));
                    header.append(String.format(formatTemplate, "----------", "----------------------------------------", "----------"));
                    MOut.G(this).print(header.toString());
                    StringBuffer fStr = new StringBuffer();
                    if (member.isArray()) {
                        for (JsonNode l : member) {
                            url = "https://" + ip + l.path("@odata.id").asText();
                            int result3 = this.sessionLoginClient.send_https_get(url);
                            if (result3 < 200 || result3 > 210) continue;
                            JsonNode rule = mapper.readTree(this.sessionLoginClient.getResponseString());
                            JsonNode number = rule.path("Id");
                            JsonNode address = rule.path("Address");
                            JsonNode prefix = rule.path("PrefixLength");
                            JsonNode policy = rule.path("Policy");
                            fStr.append(String.format(formatTemplate, number.asText(), address.asText() + "/" + prefix.asText(), policy.asText()));
                        }
                        MOut.G(this).println(fStr.toString());
                        this.statusCode = 0;
                    }
                } else {
                    this.printFailMessage(result2, this.sessionLoginClient.getResponseString());
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("IP Access Control is disabled");
                this.statusCode = 149;
            }
        }
    }
}

