/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishFlash;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.util.HashMap;

public class MotherBoardCPLDUpdate
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Motherboard CPLD Image is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("Not a supported device");
            this.statusCode = 153;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/UpdateService/" + "FirmwareInventory" + "/CPLD_Motherboard";
        RedfishHttpUtils utils = new RedfishHttpUtils();
        utils.sendRedfishGet(this.config, url);
        HashMap<String, String> entryMap = utils.getEntry();
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("CPLD upgrade must not be interrupted once it is started.");
        MOut.G(this).println("**************************************************************");
        String body = "{\"Targets\":[\"/redfish/v1/UpdateService/FirmwareInventory/CPLD_Motherboard\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\"\r\n}";
        MOut.G(this).println("Existing CPLD version: " + entryMap.get("Version").toUpperCase());
        MOut.G(this).println("");
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.setMOut(MOut.G(this));
        if (redfishFlash.flashCPLD(this.config, this.parameters[0], body)) {
            Thread.sleep(1000L);
            utils.sendRedfishGet(this.config, url);
            entryMap = utils.getEntry();
            MOut.G(this).println("");
            MOut.G(this).println("Current CPLD version: " + entryMap.get("Version").toUpperCase());
            this.statusCode = 0;
        } else {
            this.statusCode = 149;
        }
        this.ignoreSessionClose(true);
    }
}

