/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;

public class NTPConfigurationHelper {
    public static final String NTP_NODE_ENABLE_STATUS = "NTPEnable";
    public static final String NTP_NODE_PRIMARY_SERVER = "PrimaryNTPServer";
    public static final String NTP_NODE_SECONDARY_SERVER = "SecondaryNTPServer";
    public static final String NTP_NODE_DAYLIGHT_SAVE_TIME = "DaylightSavingTime";
    public static final String MANAGER_NODE_DATE_TIME = "DateTime";
    public static final String MANAGER_NODE_TIME_ZONE = "DateTimeLocalOffset";
    public static final String MANAGER_NODE_TIME_ZONE_NAME = "TimeZoneName";
    public static final String MANAGER_NODE_AUTO_DST = "AutoDSTEnabled";
    public static final String MANAGER_NODE_ODATA_TYPE = "@odata.type";
    public static final String ROOT_REDFISH_VERSION = "RedfishVersion";
    public static final int REDFISH_METHOD_UNKNOWN = -1;
    public static final int REDFISH_METHOD_NOT_SUPPORT = 0;
    public static final int REDFISH_METHOD_SUPPORT = 1;
    private int supportType;
    private IPMIInterfaceConfig ipmiCfg;

    public NTPConfigurationHelper(IPMIInterfaceConfig config) {
        this.ipmiCfg = config;
        this.supportType = -1;
    }

    public boolean isTimeZoneNameSupported() throws IPMIException {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            ObjectMapper mapper;
            JsonNode node;
            JsonNode redfishVerNode;
            int code = client.send_https_get(this.getRedfishRootUrl());
            if (200 <= code && code <= 206 && (redfishVerNode = (node = (mapper = new ObjectMapper()).readTree(client.getResponseString())).path(ROOT_REDFISH_VERSION)) != null) {
                String[] versions;
                String redfishVerString = redfishVerNode.asText();
                String[] stringArray = versions = redfishVerString != null ? redfishVerString.split("\\.") : null;
                if (versions != null) {
                    String firstVer = versions.length > 0 ? versions[0] : null;
                    String secondVer = versions.length > 1 ? versions[1] : null;
                    int firstVerInt = Integer.parseInt(firstVer);
                    int secondVerInt = Integer.parseInt(secondVer);
                    return firstVerInt >= 1 && secondVerInt >= 11;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IPMIException("Failed to get redfish version");
    }

    public boolean isAutoDstSupported() throws IPMIException {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            ObjectMapper mapper;
            JsonNode node;
            JsonNode oDataTypeNode;
            int code = client.send_https_get(this.getDateTimeUrl());
            if (200 <= code && code <= 206 && (oDataTypeNode = (node = (mapper = new ObjectMapper()).readTree(client.getResponseString())).path(MANAGER_NODE_ODATA_TYPE)) != null) {
                String[] l1Versions;
                String oDataString = oDataTypeNode.asText();
                String[] stringArray = l1Versions = oDataString != null ? oDataString.split("\\.") : null;
                if (l1Versions != null) {
                    String l1Version = l1Versions.length > 2 ? l1Versions[1] : null;
                    String[] l2Versions = (l1Version = l1Version.substring(1)).split("_");
                    if (l2Versions != null) {
                        String firstVer = l2Versions.length > 0 ? l2Versions[0] : null;
                        String secondVer = l2Versions.length > 1 ? l2Versions[1] : null;
                        int firstVerInt = Integer.parseInt(firstVer);
                        int secondVerInt = Integer.parseInt(secondVer);
                        return firstVerInt >= 1 && secondVerInt >= 11;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IPMIException("Failed to get redfish manager version");
    }

    public boolean isMethodSupported() {
        if (this.ipmiCfg != null && this.supportType == -1) {
            this.supportType = 0;
            BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
            try {
                int code = client.send_https_get(this.getNTPConfigurationUrl());
                if (200 <= code && code <= 206) {
                    this.supportType = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.supportType == 1;
    }

    public String getTimeZoneName() {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            ObjectMapper mapper;
            JsonNode node;
            JsonNode timeZoneNameNode;
            int code = client.send_https_get(this.getDateTimeUrl());
            if (200 <= code && code <= 206 && (timeZoneNameNode = (node = (mapper = new ObjectMapper()).readTree(client.getResponseString())).path(MANAGER_NODE_TIME_ZONE_NAME)) != null) {
                String timeZoneNameStr = timeZoneNameNode.asText();
                return timeZoneNameStr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean setTimeZoneName(String name) {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            String currentTimeZoneName;
            String managerUrl = this.getDateTimeUrl();
            String patchBody = this.getTimeZoneNameRequestBody(name);
            int code = client.send_https_patch(managerUrl, patchBody);
            if (200 <= code && code <= 206) {
                return true;
            }
            if ((400 == code || client.getResponseString().contains("PropertyValueConflict")) && (currentTimeZoneName = this.getTimeZoneName()) != null && currentTimeZoneName.equals(name)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isAutoDstEnabled() throws IPMIException {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        try {
            HashMap<String, String> entryMap;
            String state;
            int code = utils.sendRedfishGet(this.ipmiCfg, this.getDateTimeUrl());
            if (200 <= code && code <= 206 && (state = (entryMap = utils.getEntry()).get(MANAGER_NODE_AUTO_DST)) != null) {
                boolean stateBool = Boolean.parseBoolean(state);
                return stateBool;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IPMIException("Auto DST state retrieval failed");
    }

    public int setAutoDstEnable(boolean enable) {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            String url = this.getDateTimeUrl();
            String body = this.getAutoDstRequestBody(enable);
            int code = client.send_https_patch(url, body);
            if (200 <= code && code <= 206) {
                return 0;
            }
            if (400 == code && client.getResponseString().contains("PropertyValueConflict")) {
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }

    public boolean setNTPState(boolean enable) {
        BasicAuthClient client = new BasicAuthClient(this.ipmiCfg);
        try {
            String oemNTPUrl = this.getNTPConfigurationUrl();
            String patchBody = this.getNTPStateRequestBody(enable);
            int code = client.send_https_patch(oemNTPUrl, patchBody);
            if (200 <= code && code <= 206) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public NTPAttributes getConfigurationInstance() {
        return new NTPAttributes();
    }

    public NTPAttributes getConfiguration() {
        HashMap<String, String> entryMap;
        int code2;
        if (!this.isMethodSupported()) {
            return null;
        }
        NTPAttributes attributes = new NTPAttributes();
        RedfishHttpUtils helper = new RedfishHttpUtils();
        try {
            code2 = helper.sendRedfishGet(this.ipmiCfg, this.getNTPConfigurationUrl());
            if (200 <= code2 && code2 <= 206) {
                entryMap = helper.getEntry();
                String ntpStatus = entryMap.get(NTP_NODE_ENABLE_STATUS);
                String saveStatus = entryMap.get(NTP_NODE_DAYLIGHT_SAVE_TIME);
                attributes.setNTPEnable(ntpStatus != null ? ntpStatus.equalsIgnoreCase("true") : false);
                attributes.setDaylightSavingTimeEnable(saveStatus != null ? saveStatus.equalsIgnoreCase("true") : false);
                attributes.setPrimaryNTPServer(entryMap.get(NTP_NODE_PRIMARY_SERVER));
                attributes.setSecondaryNTPServer(entryMap.get(NTP_NODE_SECONDARY_SERVER));
            }
        }
        catch (Exception code2) {
            // empty catch block
        }
        try {
            code2 = helper.sendRedfishGet(this.ipmiCfg, this.getDateTimeUrl());
            if (200 <= code2 && code2 <= 206) {
                entryMap = helper.getEntry();
                attributes.setTimezone(entryMap.get(MANAGER_NODE_TIME_ZONE));
                attributes.setDateTime(entryMap.get(MANAGER_NODE_DATE_TIME));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributes;
    }

    public boolean setConfiguration(NTPAttributes attributes) {
        if (!this.isMethodSupported()) {
            return false;
        }
        boolean result = true;
        RedfishHttpUtils helper = new RedfishHttpUtils();
        try {
            int code = helper.sendRedfishPatch(this.ipmiCfg, this.getNTPConfigurationUrl(), this.getNTPRequestBody(attributes));
            if (code < 200 || 206 < code) {
                result = false;
            }
            if ((code = helper.sendRedfishPatch(this.ipmiCfg, this.getDateTimeUrl(), this.getTimeZoneRequestBody(attributes))) < 200 || 206 < code) {
                result = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String getRedfishRootUrl() {
        return "https://" + RedfishHttpUtils.getUrlIP(this.ipmiCfg.getIp()) + "/redfish/v1/";
    }

    private String getNTPConfigurationUrl() {
        return "https://" + RedfishHttpUtils.getUrlIP(this.ipmiCfg.getIp()) + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "NTP";
    }

    private String getDateTimeUrl() {
        return "https://" + RedfishHttpUtils.getUrlIP(this.ipmiCfg.getIp()) + "/redfish/v1/Managers/1/";
    }

    private String getNTPStateRequestBody(boolean enable) {
        return "{\"NTPEnable\":" + (enable ? "true" : "false") + "}";
    }

    private String getTimeZoneNameRequestBody(String name) {
        return "{\"TimeZoneName\":\"" + name + "\"}";
    }

    private String getAutoDstRequestBody(boolean state) {
        return "{\"AutoDSTEnabled\":" + (state ? "true" : "false") + "}";
    }

    private String getTimeZoneRequestBody(NTPAttributes attributes) {
        System.out.println("{\"DateTimeLocalOffset\":\"" + attributes.getTimezone() + "\"}");
        return "{\"DateTimeLocalOffset\":\"" + attributes.getTimezone() + "\"}";
    }

    private String getNTPRequestBody(NTPAttributes attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"").append(NTP_NODE_ENABLE_STATUS).append("\":").append(attributes.isNTPEnable).append(",\"").append(NTP_NODE_DAYLIGHT_SAVE_TIME).append("\":").append(attributes.isDaylightSavingTimeEnable).append(",\"").append(NTP_NODE_PRIMARY_SERVER).append("\":\"").append(attributes.getPrimaryNTPServer()).append("\",\"").append(NTP_NODE_SECONDARY_SERVER).append("\":\"").append(attributes.getSecondaryNTPServer()).append("\"}");
        System.out.println(builder.toString());
        return builder.toString();
    }

    public class NTPAttributes {
        private boolean isNTPEnable;
        private boolean isDaylightSavingTimeEnable;
        private boolean isInsufficientPrivilege;
        private boolean isTimezoneCountrySupported;
        private boolean isAutoDstSupported;
        private String primaryNTPServer;
        private String secondaryNTPServer;
        private String timezone;
        private String dateTime;
        private int timezoneIndex;

        public boolean isNTPEnable() {
            return this.isNTPEnable;
        }

        public boolean isDaylightSavingTimeEnable() {
            return this.isDaylightSavingTimeEnable;
        }

        public boolean isInsufficientPrivilege() {
            return this.isInsufficientPrivilege;
        }

        public boolean isTimezoneCountrySupported() {
            return this.isTimezoneCountrySupported;
        }

        public boolean isAutoDstSupported() {
            return this.isAutoDstSupported;
        }

        public String getPrimaryNTPServer() {
            return this.primaryNTPServer;
        }

        public String getSecondaryNTPServer() {
            return this.secondaryNTPServer;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public int getTimezoneIndex() {
            return this.timezoneIndex;
        }

        public void setNTPEnable(boolean enable) {
            this.isNTPEnable = enable;
        }

        public void setDaylightSavingTimeEnable(boolean enable) {
            this.isDaylightSavingTimeEnable = enable;
        }

        public void setInsufficientPrivilege(boolean isInsufficient) {
            this.isInsufficientPrivilege = isInsufficient;
        }

        public void setTimezoneCountrySupported(boolean supported) {
            this.isTimezoneCountrySupported = supported;
        }

        public void setAutoDstSupported(boolean supported) {
            this.isAutoDstSupported = supported;
        }

        public void setPrimaryNTPServer(String server) {
            this.primaryNTPServer = server;
        }

        public void setSecondaryNTPServer(String server) {
            this.secondaryNTPServer = server;
        }

        public void setTimezone(String tzone) {
            this.timezone = tzone;
        }

        public void setDateTime(String value) {
            this.dateTime = value;
        }

        public void setTimezoneIndex(int index) {
            this.timezoneIndex = index;
        }
    }
}

