/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;

public class NetworkInterfaceHelper {
    public static final String NODE_DHCP_IPV4 = "DHCPv4";
    public static final String NODE_DHCP_IPV6 = "DHCPv6";
    public static final String NODE_USE_DNS_SERVER = "UseDNSServers";
    public static final String NODE_OPERATION_MODE = "OperatingMode";
    public static final String NETWORK_INTERFACE_ROOT = "EthernetInterfaces/1";
    public static final String NETWORK_INTERFACE_IPV4_USE_DNS_SERVER = "DHCPv4/UseDNSServers";
    public static final String NETWORK_INTERFACE_IPV6_USE_DNS_SERVER = "DHCPv6/UseDNSServers";
    public static final String DHCP_IPV6_DISABLED = "Disabled";
    public static final String DHCP_IPV6_STATELESS = "Stateless";
    public static final String DHCP_IPV6_STATEFULE = "Stateful";
    private IPMIInterfaceConfig ipmiCfg;

    public NetworkInterfaceHelper(IPMIInterfaceConfig config) {
        this.ipmiCfg = config;
    }

    public boolean isIPv4UseAutoDNS() throws Exception {
        return this.isUseAutoDNS(true);
    }

    public boolean isIPv6UseAutoDNS() throws Exception {
        return this.isUseAutoDNS(false);
    }

    public int isIPv6UseDisabledMode(HashMap<String, String> map) {
        String key = "DHCPv6/OperatingMode";
        String value = map.get(key);
        if (value != null) {
            return value.equalsIgnoreCase(DHCP_IPV6_DISABLED) ? 1 : 0;
        }
        return -1;
    }

    public int isIPv6UseStatefulMode(HashMap<String, String> map) {
        String key = "DHCPv6/OperatingMode";
        String value = map.get(key);
        if (value != null) {
            return value.equalsIgnoreCase(DHCP_IPV6_STATEFULE) ? 1 : 0;
        }
        return -1;
    }

    public boolean enableIPv4AutoDNS(boolean enable) throws Exception {
        String pathBody = this.getAutoDNSPatchBody(true, enable);
        RedfishHttpUtils helper = new RedfishHttpUtils();
        int code = helper.sendRedfishPatch(this.ipmiCfg, this.getNetworkInterfaceURL(), pathBody);
        return 200 <= code && code <= 206;
    }

    public boolean enableIPv6AutoDNS(boolean enable) throws Exception {
        HashMap<String, String> jsonMap = this.fetchNetworkInterfaceInfo();
        if (jsonMap == null) {
            return false;
        }
        if (enable) {
            int isIPv6Disabled = this.isIPv6UseDisabledMode(jsonMap);
            if (isIPv6Disabled == 1) {
                throw new Exception("Unable to set auto DNS in DHCP disabled mode.");
            }
            if (isIPv6Disabled < 0) {
                return false;
            }
        } else {
            int isIPv6Stateful = this.isIPv6UseStatefulMode(jsonMap);
            if (isIPv6Stateful == 1) {
                throw new Exception("Unable to set manual DNS in DHCP stateful mode.");
            }
            if (isIPv6Stateful < 0) {
                return false;
            }
        }
        String pathBody = this.getAutoDNSPatchBody(false, enable);
        RedfishHttpUtils helper = new RedfishHttpUtils();
        int code = helper.sendRedfishPatch(this.ipmiCfg, this.getNetworkInterfaceURL(), pathBody);
        return 200 <= code && code <= 206;
    }

    public HashMap<String, String> fetchNetworkInterfaceInfo() throws Exception {
        RedfishHttpUtils helper = new RedfishHttpUtils();
        int code = helper.sendRedfishGet(this.ipmiCfg, this.getNetworkInterfaceURL());
        if (200 <= code && code <= 206) {
            return helper.getEntry();
        }
        return null;
    }

    public boolean isUseAutoDNS(HashMap<String, String> jsonMap, boolean isIPv4) throws Exception {
        if (jsonMap != null) {
            String key = isIPv4 ? NETWORK_INTERFACE_IPV4_USE_DNS_SERVER : NETWORK_INTERFACE_IPV6_USE_DNS_SERVER;
            String mode = jsonMap.get(key);
            if (mode != null) {
                return Boolean.valueOf(mode);
            }
            throw new Exception("Failed to get UseDNSServers key");
        }
        throw new Exception("Failed to get networkinterface info");
    }

    private boolean isUseAutoDNS(boolean isIPv4) throws Exception {
        HashMap<String, String> jsonMap = this.fetchNetworkInterfaceInfo();
        if (jsonMap != null) {
            String key = isIPv4 ? NETWORK_INTERFACE_IPV4_USE_DNS_SERVER : NETWORK_INTERFACE_IPV6_USE_DNS_SERVER;
            String mode = jsonMap.get(key);
            if (mode != null) {
                return Boolean.valueOf(mode);
            }
            throw new Exception("Failed to get UseDNSServers key");
        }
        throw new Exception("Failed to get networkinterface info");
    }

    private String getNetworkInterfaceURL() {
        return "https://" + RedfishHttpUtils.getUrlIP(this.ipmiCfg.getIp()) + "/redfish/v1/Managers/1/" + NETWORK_INTERFACE_ROOT;
    }

    private String getAutoDNSPatchBody(boolean isIPv4, boolean enable) {
        String protocol = isIPv4 ? NODE_DHCP_IPV4 : NODE_DHCP_IPV6;
        String mode = enable ? "true" : "false";
        return "{\"" + protocol + "\":{\"" + NODE_USE_DNS_SERVER + "\":" + mode + "}}";
    }
}

