/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;
import java.util.HashMap;

public class SMTPAuthenticationProtocolCommand
extends RedfishCommand {
    private String protocol = null;
    private final String usage = "Usage: redfish eventService smtp authentication [mode] \nMode: \n None       : 0\n AutoDetect : 1\n CRAM_MD5   : 2\n Login      : 3\n Plain      : 4";

    @Override
    public boolean preValidate() {
        this.protocol = null;
        if (this.parameters != null) {
            if (SMTPRedfishHelper.isValidAuthenticationProtocol(this.parameters[0])) {
                this.protocol = SMTPRedfishHelper.getAuthenticationStr(this.parameters[0]);
            } else {
                MOut.G(this).println("Parameter is out of range.");
                MOut.G(this).println("Usage: redfish eventService smtp authentication [mode] \nMode: \n None       : 0\n AutoDetect : 1\n CRAM_MD5   : 2\n Login      : 3\n Plain      : 4");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/EventService";
        if (this.protocol == null) {
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> entryMap = utils.getEntry();
                MOut.G(this.getOriginalParser()).println(entryMap.get("SMTP/Authentication"));
                MOut.G(this.getOriginalParser()).println("Usage: redfish eventService smtp authentication [mode] \nMode: \n None       : 0\n AutoDetect : 1\n CRAM_MD5   : 2\n Login      : 3\n Plain      : 4");
            };
            int httpStatusCode = utils.sendRedfishGet(this.getConfig(), url);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        } else {
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
            String body = utils.getPatchBody(this.getConfig(), url);
            body = utils.updateEntryValue(body, "SMTP/Authentication", this.protocol);
            int httpStatusCode = utils.sendRedfishPatch(this.getConfig(), url, body);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        }
    }
}

