/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;
import java.util.Arrays;
import java.util.List;

public class SMTPPasswordCommand
extends RedfishCommand {
    private String password;

    @Override
    public boolean preValidate() {
        if (null == this.parameters) {
            MOut.G(this).println("Password cannot be empty");
            MOut.G(this).println("Usage: redfish eventService smtp passowrd <passowrd>");
            return false;
        }
        this.password = this.parameters[0];
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/EventService";
        if (!SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
        List<String> whiteList = Arrays.asList("Password");
        String body = utils.getPatchBody(this.getConfig(), url, whiteList);
        body = utils.updateEntryValue(body, "SMTP/Password", this.password);
        int httpStatusCode = utils.sendRedfishPatch(this.getConfig(), url, body);
        this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
    }
}

