/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SMTPSenderAddressCommand
extends RedfishCommand {
    private String address;

    @Override
    public boolean preValidate() {
        String string = this.address = null != this.parameters ? this.parameters[0] : null;
        if (null != this.address && !SMTPRedfishHelper.isValidEMailAddress(this.address)) {
            MOut.G(this).println("This is invalid email address");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/EventService";
        if (!SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (null == this.address) {
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> entryMap = utils.getEntry();
                MOut.G(this.getOriginalParser()).println(entryMap.get("SMTP/FromAddress"));
            };
            int httpStatusCode = utils.sendRedfishGet(this.getConfig(), url);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        } else {
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
            List<String> whiteList = Arrays.asList("FromAddress");
            String body = utils.getPatchBody(this.getConfig(), url, whiteList);
            body = utils.updateEntryValue(body, "SMTP/FromAddress", this.address);
            int httpStatusCode = utils.sendRedfishPatch(this.getConfig(), url, body);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        }
    }
}

