/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;

public class SNMPStatusCommand
extends SNMPBaseCommand {
    private int status;
    private int protocol;
    private String nodePath;
    private final int PROTOCOL_SNMPV1 = 0;
    private final int PROTOCOL_SNMPV2 = 1;
    private final int PROTOCOL_SNMPV3 = 2;

    public SNMPStatusCommand(String path) {
        this.nodePath = path;
        this.protocol = null != this.nodePath && this.nodePath.equals("SNMP/EnableSNMPv2c") ? 1 : (null != this.nodePath && this.nodePath.equals("SNMP/EnableSNMPv3") ? 2 : 0);
    }

    @Override
    public boolean preValidate() {
        if (super.getParameters() != null) {
            try {
                this.status = Integer.valueOf(super.getParameters()[0]);
                if (0 <= this.status && this.status <= 1) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MOut.G(this).println("Invalid parameter");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        RedfishHttpUtils utils = new RedfishHttpUtils();
        if (super.getParameters() == null) {
            if (!(this.protocol != 1 && this.protocol != 2 || this.isProtocolSupported())) {
                return;
            }
            int result = utils.sendRedfishGet(this.config, url);
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> map = utils.getEntry();
                String value = map.get(this.nodePath);
                if (value != null) {
                    if (this.protocol == 1) {
                        MOut.G(this).print("SNMPv2");
                    } else if (this.protocol == 2) {
                        MOut.G(this).print("SNMPv3");
                    } else {
                        MOut.G(this).print("SNMP");
                    }
                    if (value.equalsIgnoreCase("true")) {
                        MOut.G(this).println(" is enabled");
                    } else {
                        MOut.G(this).println(" is disabled");
                    }
                } else {
                    MOut.G(this).println("Failed");
                }
                MOut.G(this).println("");
                this.usage();
            };
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        } else {
            if (this.protocol == 1 || this.protocol == 2) {
                if (!this.isProtocolSupported()) {
                    return;
                }
                if (!this.isProtocolEnabled(utils, "SNMP/ProtocolEnabled")) {
                    return;
                }
            }
            String requestBody = null;
            if (this.protocol == 0 && this.status == 0) {
                String nodeV1 = "SNMP/ProtocolEnabled".replace("SNMP/", "");
                String nodeV2 = "SNMP/EnableSNMPv2c".replace("SNMP/", "");
                String nodeV3 = "SNMP/EnableSNMPv3".replace("SNMP/", "");
                requestBody = "{\"SNMP\": {\"" + nodeV1 + "\": false, \"" + nodeV2 + "\": false, \"" + nodeV3 + "\":false}}";
            } else {
                String nodeName = this.nodePath.replace("SNMP/", "");
                requestBody = "{\"SNMP\": {\"" + nodeName + "\": " + (this.status == 1 ? "true" : "false") + "}}";
            }
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this).println("Done");
            int result = utils.sendRedfishPatch(this.config, url, requestBody);
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        }
    }

    private void usage() {
        String subInfo = "";
        if (this.protocol == 1) {
            subInfo = "snmpv2 ";
        } else if (this.protocol == 2) {
            subInfo = "snmpv3 ";
        }
        String usage = "Usage: redfish eventService snmp " + subInfo + "status [enabled]\n       disable : 0\n       enable  : 1";
        MOut.G(this).println(usage);
    }
}

