/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SNMPBaseCommand;
import java.util.HashMap;

public class SNMPv2CommunityModeCommand
extends SNMPBaseCommand {
    private int status;

    @Override
    public boolean preValidate() {
        if (super.getParameters() != null && super.getParameters().length >= 1) {
            try {
                this.status = Integer.valueOf(super.getParameters()[0]);
                if (0 <= this.status && this.status <= 1) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            return true;
        }
        MOut.G(this).println("Invalid parameters");
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isProtocolSupported()) {
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/NetworkProtocol";
        if (super.getParameters() == null) {
            int result = utils.sendRedfishGet(this.config, url);
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> map = utils.getEntry();
                String value = map.get("SNMP/HideCommunityStrings");
                if (value != null) {
                    if (value.equalsIgnoreCase("true")) {
                        MOut.G(this).println("Community string is in hide mode");
                    } else {
                        MOut.G(this).println("Community string is in show mode");
                    }
                } else {
                    MOut.G(this).println("Empty");
                }
                MOut.G(this).println("");
                this.usage();
            };
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        } else {
            if (!this.isProtocolEnabled(utils, "SNMP/ProtocolEnabled") || !this.isProtocolEnabled(utils, "SNMP/EnableSNMPv2c")) {
                return;
            }
            String requestBody = "{\"SNMP\": {\"HideCommunityStrings\": " + (this.status == 1 ? "false" : "true") + "}}";
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this).println("Done");
            int result = utils.sendRedfishPatch(this.config, url, requestBody);
            this.statusCode = this.statusCodeHandler(callback, result, utils.getRedfishResponse());
        }
    }

    private void usage() {
        String usage = "Usage: redfish eventService snmp snmpv2 communityString [mode]\n       Hide : 0\n       Show : 1";
        MOut.G(this).println("Usage: redfish eventService snmp snmpv2 communityString [mode]\n       Hide : 0\n       Show : 1");
    }
}

