/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text.scc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SCCCheckingSSDPCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String status;
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Managers/1/" + "NetworkProtocol";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode ssdp = node.path("SSDP");
            JsonNode enabled = ssdp.path("ProtocolEnabled");
            String string = status = enabled.asBoolean() ? "Enabled" : "Disabled";
            if (enabled.isNull()) {
                status = "N/A";
            }
        } else {
            MOut.G(this).println("redfish/v1/Managers/1 connection failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("---------------------------------------------------------------------------");
        String formatTemplate = " %-25s | %-45s |\n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(formatTemplate, "SSDP", status));
        MOut.G(this).print(fStr.toString());
        MOut.G(this).println("---------------------------------------------------------------------------");
        this.statusCode = 0;
    }
}

