/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.swproductkey;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermicro.swproductkey.AESSecretData;
import com.supermicro.swproductkey.AESTool;
import com.supermicro.swproductkey.IPMICannotLoginException;
import com.supermicro.swproductkey.IPMICmdErrorCompletionCodeException;
import com.supermicro.swproductkey.InvalidIpmiIdPwException;
import com.supermicro.swproductkey.InvalidProductKeyFormatException;
import com.supermicro.swproductkey.InvalidProductKeyListFormatException;
import com.supermicro.swproductkey.InvalidSWFRUIndexException;
import com.supermicro.swproductkey.NoSWFRUSupportException;
import com.supermicro.swproductkey.ProductKey;
import com.supermicro.swproductkey.ProductKeyActivation;
import com.supermicro.swproductkey.ProductKeyListInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.log4j.Appender;
import org.apache.log4j.varia.NullAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationTool {
    private static Logger logger = LoggerFactory.getLogger(ActivationTool.class);
    static final String buildVersion = "20150303";

    public ProductKeyListInstance[] getProductKeyListFromFile(String aFile) throws InvalidProductKeyListFormatException, FileNotFoundException {
        ArrayList<ProductKeyListInstance> keyInstanceList = new ArrayList<ProductKeyListInstance>();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            File file = new File(aFile);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            fileReader.close();
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Error! Can not find \"" + aFile + "\".");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int lineCount = 0;
        for (String line : lines) {
            if (line.trim().length() == 0 || line.trim().indexOf("#") == 0) continue;
            keyInstanceList.add(ProductKeyListInstance.parseAProductKeyListInstance(line));
            ++lineCount;
        }
        if (lineCount == 0) {
            throw new InvalidProductKeyListFormatException("There is no product key in list file!");
        }
        return keyInstanceList.toArray(new ProductKeyListInstance[0]);
    }

    public void activateProductKeyInstance(String aDefaultId, String aDefaultPw, ProductKeyListInstance aInstance) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException, IPMICannotLoginException, BadPaddingException, NoSWFRUSupportException {
        try {
            if (aInstance.getId() != null && aInstance.getPw() != null) {
                if (!this.isIpmiLoginable(aInstance.getIpAddress(), aInstance.getId(), aInstance.getPw())) {
                    throw new IPMICannotLoginException("Error! Can not log in IPMI with ID " + aInstance.getId() + " @" + aInstance.getIpAddress() + ".");
                }
                ProductKeyActivation pkActivation = new ProductKeyActivation(aInstance.getIpAddress(), aInstance.getId(), aInstance.getPw());
                pkActivation.activateProductKey(aInstance.getKey());
            } else {
                if (!this.isIpmiLoginable(aInstance.getIpAddress(), aDefaultId, aDefaultPw)) {
                    throw new IPMICannotLoginException("Error! Can not log in IPMI with ID " + aDefaultId + " @" + aInstance.getIpAddress() + ".");
                }
                ProductKeyActivation pkActivation = new ProductKeyActivation(aInstance.getIpAddress(), aDefaultId, aDefaultPw);
                pkActivation.activateProductKey(aInstance.getKey());
            }
        }
        catch (InvalidSWFRUIndexException e) {
            throw new InvalidSWFRUIndexException("Has problem in activating a product key for " + aInstance.getMacAddress() + "@" + aInstance.getIpAddress() + ". " + e.getMessage());
        }
        catch (IPMICmdErrorCompletionCodeException e) {
            throw new IPMICmdErrorCompletionCodeException(e.getCompletionCode(), "Has problem in activating a product key for " + aInstance.getMacAddress() + "@" + aInstance.getIpAddress() + ". " + e.getMessage());
        }
    }

    public void activateProductKeyInstance(ProductKeyListInstance aInstance) throws InvalidSWFRUIndexException, IPMICmdErrorCompletionCodeException, InvalidIpmiIdPwException, IPMICannotLoginException, BadPaddingException, NoSWFRUSupportException {
        if (aInstance.getId() == null || aInstance.getPw() == null) {
            throw new InvalidIpmiIdPwException("IPMI ID or PW can not be empry or null!");
        }
        if (!this.isIpmiLoginable(aInstance.getIpAddress(), aInstance.getId(), aInstance.getPw())) {
            throw new IPMICannotLoginException("Error! Can not log in IPMI with ID " + aInstance.getId() + " @" + aInstance.getIpAddress() + ".");
        }
        try {
            ProductKeyActivation pkActivation = new ProductKeyActivation(aInstance.getIpAddress(), aInstance.getId(), aInstance.getPw());
            pkActivation.activateProductKey(aInstance.getKey());
        }
        catch (InvalidSWFRUIndexException e) {
            throw new InvalidSWFRUIndexException("Has problem in activating a product key for " + aInstance.getMacAddress() + "@" + aInstance.getIpAddress() + ". " + e.getMessage());
        }
        catch (IPMICmdErrorCompletionCodeException e) {
            throw new IPMICmdErrorCompletionCodeException(e.getCompletionCode(), "Has problem in activating a product key for " + aInstance.getMacAddress() + "@" + aInstance.getIpAddress() + ". " + e.getMessage());
        }
    }

    private void printHeader() {
        System.out.println("===============================================================================");
        System.out.println("Supermicro SW product key activation tool (20150303)");
        System.out.println("===============================================================================");
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    private void printHelp(Options aOptions) {
        this.printHeader();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ActivationTool", aOptions);
        this.printExample();
    }

    private void printExample() {
        System.out.println("Example:");
        System.out.println("activationtool -c activate -l PKLISTFILE -u ADMIN -p ADMIN");
        System.out.println("activationtool -c query -i 192.168.1.1 -u ADMIN -p ADMIN");
        System.out.println("activationtool -c clear -i 192.168.1.1 -u ADMIN -p ADMIN -x 1");
        System.out.println("activationtool -c query -k");
        System.out.println("activationtool -c clear -k -x 1");
    }

    private boolean isIpmiLoginable(String aIP, String aId, String aPw) {
        return ProductKeyActivation.isIpmiLoginable(aIP, aId, aPw);
    }

    public static ProductKey getProductKeyAtIndex(ProductKeyActivation aPkActivation, int aFRUIdx) throws InvalidSWFRUIndexException, IPMICannotLoginException, IPMICmdErrorCompletionCodeException, InvalidProductKeyFormatException {
        if (aFRUIdx <= 0 || aFRUIdx >= 255) {
            throw new InvalidSWFRUIndexException("Invalid FRU index for product key: " + aFRUIdx);
        }
        if (aPkActivation == null) {
            throw new IPMICannotLoginException("Error! Can not log in IPMI. ProductKeyActivation is null.");
        }
        if (!aPkActivation.isIpmiLoginable()) {
            throw new IPMICannotLoginException("Error! Can not log in IPMI with ID " + aPkActivation.getID() + " @" + aPkActivation.getIP() + ".");
        }
        byte aSWID = aPkActivation.getProductKeySWID(aFRUIdx);
        boolean bDone = false;
        String mac = aPkActivation.getMacAddress();
        if (aSWID != -1 && aSWID != 0) {
            int nTryMac = 0;
            while (!bDone && nTryMac < 2) {
                try {
                    String tmpStr = Base64.encode(aPkActivation.getEncryptedProductKey(aFRUIdx));
                    return ProductKey.parseByteArray(AESTool.getBase64DecodeAndDecrypted(ProductKey.getNumOfUnencryptBlock(), mac, tmpStr));
                }
                catch (BadPaddingException e) {
                    if (e.getMessage().equals("Given final block not properly padded")) {
                        if (aPkActivation.getOriginalMac() == null) {
                            throw new InvalidProductKeyFormatException("Product key at [" + aFRUIdx + "] is not valid.");
                        }
                        mac = aPkActivation.getOriginalMac();
                        if (++nTryMac < 2) continue;
                        throw new InvalidProductKeyFormatException("Product key at [" + aFRUIdx + "] is not valid!");
                    }
                    logger.error("(" + aPkActivation.getIP() + ") " + e.getMessage());
                    throw new InvalidProductKeyFormatException(e.getMessage());
                }
                catch (Exception e) {
                    logger.error("(" + aPkActivation.getIP() + ") " + e.getMessage());
                    throw new InvalidProductKeyFormatException(e.getMessage());
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        block72: {
            if (!new File("log4j.properties").exists()) {
                org.apache.log4j.Logger.getRootLogger().removeAllAppenders();
                org.apache.log4j.Logger.getRootLogger().addAppender((Appender)new NullAppender());
            }
            ActivationTool tool = new ActivationTool();
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("c", "cmd", true, "Which command to run. [activate|query|clear]");
            options.addOption("l", "listfile", true, "Product key list file.");
            options.addOption("u", "user", true, "IPMI user account.");
            options.addOption("p", "password", true, "IPMI user password.");
            options.addOption("i", "ip", true, "IPMI IP address.");
            options.addOption("x", "index", true, "Specify the index of a product key.");
            options.addOption("k", "kcs", false, "Use KCS protocol.");
            options.addOption("h", "help", false, "Show this page.");
            try {
                CommandLine line = parser.parse(options, args);
                if (line.hasOption("h")) {
                    tool.printHelp(options);
                    System.exit(0);
                }
                if (!line.hasOption("c")) {
                    System.out.println("Error! Need to provide -c or --cmd option.");
                    tool.printHelp(options);
                    System.exit(0);
                }
                String cmd = line.getOptionValue("c");
                String msg = "";
                if (cmd.equals("activate")) {
                    ProductKeyListInstance aInstance;
                    if (!line.hasOption("l")) {
                        System.out.println("Error! Need to provide -l or --listfile for product key list file.");
                        System.exit(0);
                    }
                    String file = line.getOptionValue("l");
                    String id = null;
                    String pw = null;
                    ProductKeyListInstance[] pkList = null;
                    try {
                        pkList = tool.getProductKeyListFromFile(file);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(e.getMessage());
                        System.exit(0);
                    }
                    catch (InvalidProductKeyListFormatException e) {
                        System.out.println(e.getMessage());
                        System.exit(0);
                    }
                    if (line.hasOption("u")) {
                        id = line.getOptionValue("u");
                    }
                    if (line.hasOption("p")) {
                        pw = line.getOptionValue("p");
                    }
                    if (id != null && pw != null) {
                        ProductKeyListInstance[] productKeyListInstanceArray = pkList;
                        int n = pkList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            aInstance = productKeyListInstanceArray[n2];
                            try {
                                tool.activateProductKeyInstance(id, pw, aInstance);
                                msg = "Finish in activating a product key @" + aInstance.getIpAddress() + ".";
                                System.out.println(msg);
                                logger.debug("(" + aInstance.getIpAddress() + ") " + msg);
                            }
                            catch (BadPaddingException e) {
                                if (e.getMessage().equals("Given final block not properly padded")) {
                                    System.out.println("Error! Product key is not valid.");
                                } else {
                                    System.out.println(e.getMessage());
                                    logger.error("(" + aInstance.getIpAddress() + ") " + e.getMessage());
                                }
                            }
                            catch (NoSWFRUSupportException e) {
                                System.out.println(e.getMessage());
                                System.exit(0);
                            }
                            catch (Exception e) {
                                if (e.getMessage().indexOf("Duplicate") != -1) {
                                    System.out.println(e.getMessage());
                                }
                                logger.error("(" + aInstance.getIpAddress() + ") " + e.getMessage());
                            }
                            ++n2;
                        }
                        break block72;
                    }
                    ProductKeyListInstance[] productKeyListInstanceArray = pkList;
                    int n = pkList.length;
                    int n3 = 0;
                    while (n3 < n) {
                        aInstance = productKeyListInstanceArray[n3];
                        try {
                            tool.activateProductKeyInstance(aInstance);
                            msg = "Finish in activating a product key @" + aInstance.getIpAddress() + ".";
                            System.out.println(msg);
                            logger.debug("(" + aInstance.getIpAddress() + ") " + msg);
                        }
                        catch (BadPaddingException e) {
                            if (e.getMessage().equals("Given final block not properly padded")) {
                                System.out.println("Error! Product key is not valid.");
                            } else {
                                System.out.println(e.getMessage());
                                logger.error("(" + aInstance.getIpAddress() + ") " + e.getMessage());
                            }
                        }
                        catch (Exception e) {
                            if (e.getMessage().indexOf("Duplicate") != -1) {
                                System.out.println(e.getMessage());
                            }
                            logger.error("(" + aInstance.getIpAddress() + ") " + e.getMessage());
                        }
                        ++n3;
                    }
                    break block72;
                }
                if (cmd.equals("query") || cmd.equals("clear")) {
                    String pw;
                    String id;
                    String ip;
                    if (!line.hasOption("k")) {
                        if (!line.hasOption("i")) {
                            System.out.println("Error! Need to provide -i or --ip for IP address.");
                            System.exit(0);
                        }
                        if (!line.hasOption("u")) {
                            System.out.println("Error! Need to provide -u or --user for IPMI user account.");
                            System.exit(0);
                        }
                        if (!line.hasOption("p")) {
                            System.out.println("Error! Need to provide -p or --password for IPMI user password.");
                            System.exit(0);
                        }
                    }
                    if (!tool.isIpmiLoginable(ip = line.getOptionValue("i"), id = line.getOptionValue("u"), pw = line.getOptionValue("p"))) {
                        System.out.println("Error! Can not log in IPMI with ID " + id + " @" + ip + ".");
                        System.exit(0);
                    }
                    try {
                        String strIndex;
                        ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, pw);
                        if (cmd.equals("query")) {
                            int num = pkActivation.getNumOfProductKey();
                            msg = "Number of product keys: " + num;
                            System.out.println(msg);
                            logger.debug("(" + ip + ") " + msg);
                            if (num <= 0) break block72;
                            int i = 1;
                            while (i < 255) {
                                block73: {
                                    byte aSWID = pkActivation.getProductKeySWID(i);
                                    if (aSWID != -1 && aSWID != 0) {
                                        try {
                                            int nDoubleCheck;
                                            ProductKey pk;
                                            block74: {
                                                pk = ActivationTool.getProductKeyAtIndex(pkActivation, i);
                                                if (pk == null) break block73;
                                                System.out.print("[" + i + "] ");
                                                System.out.print(pk.getSWName());
                                                if (pk.getSWVersion().length() > 0) {
                                                    System.out.print(", version: " + pk.getSWVersion());
                                                }
                                                if (pk.getInvoiceNum().length() > 0) {
                                                    System.out.print(", invoice: " + pk.getInvoiceNum());
                                                }
                                                System.out.print(", creation date: " + pk.getKeyCreationDate());
                                                if (pk.getExpirationDate().getTime() != 0L) {
                                                    System.out.print(", expiration date: " + pk.getExpirationDate());
                                                }
                                                if (pk.getKeyProperty() != null && pk.getKeyProperty().length > 0) {
                                                    System.out.print(", property: ");
                                                    byte[] byArray = pk.getKeyProperty();
                                                    int n = byArray.length;
                                                    int n4 = 0;
                                                    while (n4 < n) {
                                                        byte b = byArray[n4];
                                                        System.out.format("%02X ", b);
                                                        ++n4;
                                                    }
                                                }
                                                nDoubleCheck = -1;
                                                byte[] orgSdBa = pk.getSecretData();
                                                if (orgSdBa != null) {
                                                    byte[] sdBa = null;
                                                    try {
                                                        String strMac0 = pkActivation.getOriginalMac();
                                                        String strMac1 = pkActivation.getMacAddress();
                                                        sdBa = AESSecretData.getEncryptedSecretData(strMac1, pk.getRawSecretData());
                                                        if (orgSdBa.length != sdBa.length) break block74;
                                                        int nDiff = 0;
                                                        int j = 0;
                                                        while (j < orgSdBa.length) {
                                                            if (orgSdBa[j] != sdBa[j]) {
                                                                ++nDiff;
                                                            }
                                                            ++j;
                                                        }
                                                        if (nDiff == 0) {
                                                            nDoubleCheck = 1;
                                                        } else if (strMac0 != null && strMac0 != strMac1 && orgSdBa.length == (sdBa = AESSecretData.getEncryptedSecretData(strMac0, pk.getRawSecretData())).length) {
                                                            nDiff = 0;
                                                            j = 0;
                                                            while (j < orgSdBa.length) {
                                                                if (orgSdBa[j] != sdBa[j]) {
                                                                    ++nDiff;
                                                                }
                                                                ++j;
                                                            }
                                                            if (nDiff == 0) {
                                                                nDoubleCheck = 2;
                                                            }
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        System.out.println("Has problem in double checking....");
                                                        e.printStackTrace();
                                                    }
                                                } else {
                                                    nDoubleCheck = 0;
                                                }
                                            }
                                            System.out.print(", DC:" + nDoubleCheck);
                                            if (pkActivation.isProductKeyExpired(pk)) {
                                                System.out.println(" (Key is expired.)");
                                            } else if (nDoubleCheck == -1) {
                                                System.out.println(" (Key is not good.)");
                                            } else {
                                                System.out.println(" (Key is good.)");
                                            }
                                            System.out.println();
                                        }
                                        catch (InvalidSWFRUIndexException e) {
                                            e.printStackTrace();
                                        }
                                        catch (IPMICannotLoginException e) {
                                            e.printStackTrace();
                                        }
                                        catch (InvalidProductKeyFormatException e) {
                                            System.out.println(e.getMessage());
                                        }
                                    }
                                }
                                ++i;
                            }
                            break block72;
                        }
                        if (!cmd.equals("clear")) break block72;
                        if (!line.hasOption("x")) {
                            System.out.println("Error! Need to provide -x or --index for the index of a product key.");
                            System.exit(0);
                        }
                        if ((strIndex = line.getOptionValue("x")) == null) {
                            System.out.println("Error! Invalid -x option value: " + strIndex);
                            System.exit(0);
                        }
                        try {
                            Integer aInt = Integer.parseInt(strIndex);
                            pkActivation.clearProductKey(aInt);
                            msg = "Clearing the product key at [" + aInt + "].";
                            System.out.println(msg);
                            logger.debug("(" + ip + ") " + msg);
                            break block72;
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error! Invalid -x option value: " + strIndex);
                            System.exit(0);
                            break block72;
                        }
                        catch (InvalidSWFRUIndexException e) {
                            msg = "Error! " + e.getMessage();
                            System.out.println(msg);
                            logger.error("(" + ip + ") " + msg);
                            System.exit(0);
                        }
                    }
                    catch (IPMICmdErrorCompletionCodeException e) {
                        e.printStackTrace();
                    }
                    catch (NoSWFRUSupportException e1) {
                        System.out.println(e1.getMessage());
                        System.exit(0);
                    }
                    break block72;
                }
                System.out.println("Error! Unsupported command: " + cmd);
                System.exit(0);
            }
            catch (MissingArgumentException e) {
                System.out.println("Error! " + e.getMessage());
            }
            catch (ParseException e) {
                if (e instanceof UnrecognizedOptionException) {
                    System.out.println("Error! " + e.getMessage());
                }
                e.printStackTrace();
            }
        }
    }
}

