/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.IconTextField;
import IPMIView20.L;
import IPMIView20.TableCellFilterRenderer;
import IPMIView20.blade.SWindow;
import IPMIView20.group.FilterCondition;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMELCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.redfish.RedfishHttpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class AbstractEventPanel
extends JPanel {
    private static final int EVENT_TYPE_HEL = 0;
    private static final int EVENT_TYPE_MEL = 1;
    private static final int QUERY_RANGE_ALL = 0;
    private static final int QUERY_RANGE_SUB = 1;
    private static final int QUERY_RANGE_LAST = 2;
    private static final String EVENT_INFO_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final String EVENT_INFO_TIMESTAMP_FORMAT_FULL = "yyyy/MM/dd HH:mm:ss EEE";
    private static final String EVENT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String ICON_PATH_LIST = "/images/list.gif";
    private static final String ICON_PATH_SAVE = "/images/toolbar_save.gif";
    private static final String ICON_PATH_DEL = "/images/delete.gif";
    private static final String ICON_PATH_TIP = "/images/information.png";
    private static final String ICON_PATH_REFRESH = "/images/Refresh24.gif";
    private static final String ICON_PATH_SEARCH = "/images/search.PNG";
    private int[] argsVecHEL = new int[]{0, 0, 0, 0};
    private int[] argsVecMEL = new int[]{0, 0, 0, 0};
    private boolean isRedfishSupported = false;
    protected static JFileChooser fileChooser;
    protected SELInfo healthInfo;
    protected RedfishHttpUtils utils;
    protected IPMIInterfaceConfig ipmiInterfaceConfig;
    protected SWindow sWindow;
    protected String exportFileName;
    protected int eventType = 0;
    protected EventMessageCenterObserver messageCenterObserver;
    protected TableCellFilterRenderer filterCellRender;
    protected TableSorter helTableSorter;
    protected TableSorter melTableSorter;
    protected Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    protected Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    protected Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    protected Icon refreshIcon = new ImageIcon(this.getClass().getResource("/images/Refresh24.gif"));
    protected Icon searchIcon = new ImageIcon(this.getClass().getResource("/images/search.PNG"));
    protected ImageIcon timeStampTipsIcon = new ImageIcon(this.getClass().getResource("/images/information.png"));
    protected JPanel jTopPanel = new JPanel();
    protected JPanel jTopPanelTop = new JPanel();
    protected JPanel jTopPanelCentral = new JPanel();
    protected JPanel jTopPanelCentralLine1 = new JPanel();
    protected JPanel jTopPanelCentralLine2 = new JPanel();
    protected JPanel jTopPanelCentralLine3 = new JPanel();
    protected JPanel jTopPanelBottom = new JPanel();
    protected JPanel jTopPanelTopBottom = new JPanel();
    protected JToolBar jTopToolBar = new JToolBar();
    protected JScrollPane jBottomScrollPane = new JScrollPane();
    protected JTable jEventTableTable = new JTable();
    protected ButtonGroup eventTypeButtonGroup = new ButtonGroup();
    protected ButtonGroup eventRangeButtonGroup = new ButtonGroup();
    protected JRadioButton jHELTypeRadioButton = new JRadioButton();
    protected JRadioButton jMELTypeRadioButton = new JRadioButton();
    protected JRadioButton jAllRadioButton = new JRadioButton();
    protected JRadioButton jFromRadioButton = new JRadioButton();
    protected JRadioButton jLastRadioButton = new JRadioButton();
    protected JButton jGetHELButton = new JButton();
    protected JButton jRefreshButton = new JButton();
    protected JButton jSaveButton = new JButton();
    protected JButton jDeleteButton = new JButton();
    protected IconTextField jKeywordTextField = new IconTextField();
    protected JTextField jEventRangeBeginTextField = new JTextField();
    protected JTextField jEventRangeEndTextField = new JTextField();
    protected JTextField jEventRangeLastTextField = new JTextField();
    protected JTextField jTextFieldHelTime = new JTextField();
    protected JLabel jEventRangeToLabel = new JLabel();
    protected JLabel jLastEeventsLabel = new JLabel();
    protected JLabel jHELVersionLabel = new JLabel();
    protected JLabel jHELVersionValueLabel = new JLabel();
    protected JLabel jTotalEntriesLabel = new JLabel();
    protected JLabel jTotalEntriesValueLabel = new JLabel();
    protected JLabel jFreeSpaceLabel = new JLabel();
    protected JLabel jFreeSpaceValueLabel = new JLabel();
    protected JLabel jRecentEntryAddedLabel = new JLabel();
    protected JLabel jRecentEntryAddedValueLabel = new JLabel();
    protected JLabel jRecentEntryErasedLabel = new JLabel();
    protected JLabel jRecentEntryErasedValueLabel = new JLabel();
    protected JLabel jLabelTimestamp = new JLabel();
    protected JLabel jLabelTimestampTips = new JLabel();
    protected JLabel bottomToolbarMessage;

    public AbstractEventPanel() {
        this.sWindow = new SWindow(IPMIView20.getInstance(), "", "", "");
        this.messageCenterObserver = new EventMessageCenterObserver(this);
        this.filterCellRender = new TableCellFilterRenderer();
        this.utils = new RedfishHttpUtils();
    }

    protected void initComponents() {
        this.setComponentsLayout();
        this.setComponents();
        this.setComponentsColor();
        this.setComponentsSize();
        this.setComponentsText();
        this.setComponentsListenser();
    }

    protected void setDeleteButtonEnable(boolean enable) {
        this.jDeleteButton.setEnabled(enable);
    }

    protected void setMessageBar(JLabel msg) {
        this.bottomToolbarMessage = msg;
    }

    protected void setConfig(IPMIInterfaceConfig config) {
        this.ipmiInterfaceConfig = config;
        this.setTableHeader();
        this.setPrivilegeDisable(config.getPrivilege());
    }

    protected void setComponentsLayout() {
        this.setLayout(new BorderLayout());
        this.jTopPanel.setLayout(new BorderLayout());
        this.jTopPanelTop.setLayout(new BorderLayout());
        this.jTopPanelTopBottom.setLayout(new FlowLayout(0, 10, 5));
        this.jTopPanelCentral.setLayout(new BoxLayout(this.jTopPanelCentral, 1));
        this.jTopPanelCentralLine1.setLayout(new BoxLayout(this.jTopPanelCentralLine1, 0));
        this.jTopPanelCentralLine2.setLayout(new BoxLayout(this.jTopPanelCentralLine2, 0));
        this.jTopPanelCentralLine3.setLayout(new BoxLayout(this.jTopPanelCentralLine3, 0));
        this.jTopPanelBottom.setLayout(new FlowLayout(0, 10, 5));
    }

    protected void setComponents() {
        this.add((Component)this.jTopPanel, "North");
        this.add((Component)this.jBottomScrollPane, "Center");
        this.jTopPanel.add((Component)this.jTopPanelTop, "North");
        this.jTopPanel.add((Component)this.jTopPanelCentral, "Center");
        this.jTopPanel.add((Component)this.jTopPanelBottom, "South");
        this.jTopPanelTop.add((Component)this.jTopToolBar, "North");
        this.jTopPanelTop.add((Component)this.jTopPanelTopBottom, "South");
        this.jTopToolBar.add(this.jGetHELButton);
        this.jTopToolBar.add(this.jRefreshButton);
        this.jTopToolBar.add(this.jSaveButton);
        this.jTopToolBar.add(this.jDeleteButton);
        Insets toolBtnMargin = new Insets(0, 0, 0, 10);
        this.jGetHELButton.setMargin(toolBtnMargin);
        this.jRefreshButton.setMargin(toolBtnMargin);
        this.jSaveButton.setMargin(toolBtnMargin);
        this.jDeleteButton.setMargin(toolBtnMargin);
        this.jTopPanelTopBottom.add(this.jHELTypeRadioButton);
        this.jTopPanelTopBottom.add(this.jMELTypeRadioButton);
        this.jTopPanelTopBottom.add(this.jKeywordTextField);
        this.jTopPanelCentral.add(this.jTopPanelCentralLine1);
        this.jTopPanelCentral.add(this.jTopPanelCentralLine2);
        this.jTopPanelCentral.add(this.jTopPanelCentralLine3);
        Dimension linePadding = new Dimension(20, 25);
        this.jTopPanelCentralLine1.add(Box.createRigidArea(linePadding));
        this.jTopPanelCentralLine1.add(this.jHELVersionLabel);
        this.jTopPanelCentralLine1.add(this.jHELVersionValueLabel);
        this.jTopPanelCentralLine1.add(this.jRecentEntryAddedLabel);
        this.jTopPanelCentralLine1.add(this.jRecentEntryAddedValueLabel);
        this.jTopPanelCentralLine1.add(Box.createHorizontalGlue());
        this.jTopPanelCentralLine2.add(Box.createRigidArea(linePadding));
        this.jTopPanelCentralLine2.add(this.jTotalEntriesLabel);
        this.jTopPanelCentralLine2.add(this.jTotalEntriesValueLabel);
        this.jTopPanelCentralLine2.add(this.jRecentEntryErasedLabel);
        this.jTopPanelCentralLine2.add(this.jRecentEntryErasedValueLabel);
        this.jTopPanelCentralLine2.add(Box.createHorizontalGlue());
        this.jTopPanelCentralLine3.add(Box.createRigidArea(linePadding));
        this.jTopPanelCentralLine3.add(this.jFreeSpaceLabel);
        this.jTopPanelCentralLine3.add(this.jFreeSpaceValueLabel);
        this.jTopPanelCentralLine3.add(this.jLabelTimestamp);
        this.jTopPanelCentralLine3.add(this.jTextFieldHelTime);
        this.jTopPanelCentralLine3.add(Box.createHorizontalStrut(10));
        this.jTopPanelCentralLine3.add(this.jLabelTimestampTips);
        this.jTopPanelCentralLine3.add(Box.createHorizontalGlue());
        this.jTopPanelBottom.add(this.jAllRadioButton);
        this.jTopPanelBottom.add(this.jFromRadioButton);
        this.jTopPanelBottom.add(this.jEventRangeBeginTextField);
        this.jTopPanelBottom.add(this.jEventRangeToLabel);
        this.jTopPanelBottom.add(this.jEventRangeEndTextField);
        this.jTopPanelBottom.add(this.jLastRadioButton);
        this.jTopPanelBottom.add(this.jEventRangeLastTextField);
        this.jTopPanelBottom.add(this.jLastEeventsLabel);
        this.eventRangeButtonGroup.add(this.jAllRadioButton);
        this.eventRangeButtonGroup.add(this.jFromRadioButton);
        this.eventRangeButtonGroup.add(this.jLastRadioButton);
        this.eventTypeButtonGroup.add(this.jHELTypeRadioButton);
        this.eventTypeButtonGroup.add(this.jMELTypeRadioButton);
        this.jKeywordTextField.setIcon(this.searchIcon);
        this.jGetHELButton.setIcon(this.listIcon);
        this.jRefreshButton.setIcon(this.refreshIcon);
        this.jSaveButton.setIcon(this.saveIcon);
        this.jDeleteButton.setIcon(this.deleteIcon);
        this.jLabelTimestampTips.setIcon(this.timeStampTipsIcon);
        this.jLabelTimestampTips.setToolTipText(this.dataTimeRangeHtml());
        this.jLastRadioButton.setMargin(new Insets(0, 20, 0, 0));
        this.jTopToolBar.setFloatable(false);
        this.jHELTypeRadioButton.setSelected(true);
        this.jAllRadioButton.setSelected(true);
        this.jEventRangeBeginTextField.setEditable(false);
        this.jEventRangeEndTextField.setEditable(false);
        this.jEventRangeLastTextField.setEditable(false);
        this.jBottomScrollPane.setViewportView(this.jEventTableTable);
    }

    protected void setComponentsColor() {
        this.jHELVersionLabel.setForeground(Color.blue);
        this.jTotalEntriesLabel.setForeground(Color.blue);
        this.jFreeSpaceLabel.setForeground(Color.blue);
        this.jRecentEntryAddedLabel.setForeground(Color.blue);
        this.jRecentEntryErasedLabel.setForeground(Color.blue);
        this.jLabelTimestamp.setForeground(Color.blue);
    }

    protected void setComponentsSize() {
        this.jHELTypeRadioButton.setPreferredSize(new Dimension(100, 20));
        this.jMELTypeRadioButton.setPreferredSize(new Dimension(120, 20));
        this.jKeywordTextField.setPreferredSize(new Dimension(120, 20));
        this.jHELVersionLabel.setPreferredSize(new Dimension(100, 20));
        this.jTotalEntriesLabel.setPreferredSize(new Dimension(100, 20));
        this.jFreeSpaceLabel.setPreferredSize(new Dimension(100, 20));
        this.jHELVersionValueLabel.setPreferredSize(new Dimension(100, 20));
        this.jTotalEntriesValueLabel.setPreferredSize(new Dimension(100, 20));
        this.jFreeSpaceValueLabel.setPreferredSize(new Dimension(100, 20));
        this.jRecentEntryAddedLabel.setPreferredSize(new Dimension(170, 20));
        this.jRecentEntryAddedValueLabel.setPreferredSize(new Dimension(170, 20));
        this.jRecentEntryErasedLabel.setPreferredSize(new Dimension(170, 20));
        this.jRecentEntryErasedValueLabel.setPreferredSize(new Dimension(170, 20));
        this.jLabelTimestamp.setPreferredSize(new Dimension(170, 20));
        this.jTextFieldHelTime.setPreferredSize(new Dimension(185, 20));
        this.jTextFieldHelTime.setMaximumSize(this.jTextFieldHelTime.getPreferredSize());
        this.jLabelTimestampTips.setPreferredSize(new Dimension(22, 22));
        this.jEventRangeBeginTextField.setPreferredSize(new Dimension(50, 20));
        this.jEventRangeEndTextField.setPreferredSize(new Dimension(50, 20));
        this.jEventRangeLastTextField.setPreferredSize(new Dimension(50, 20));
        this.jAllRadioButton.setPreferredSize(new Dimension(100, 20));
    }

    protected void setComponentsText() {
        this.jTopPanelTopBottom.setBorder(new TitledBorder(L.t("cmm.SEL.Event_Type")));
        this.jTopPanelCentral.setBorder(new TitledBorder(L.t("cmm.SEL.SEL_Information")));
        this.jTopPanelBottom.setBorder(new TitledBorder(L.t("cmm.SEL.Parameter_SEL")));
        this.jGetHELButton.setToolTipText(L.t("cmm.SEL.Get_SEL_Records"));
        this.jGetHELButton.setText(L.t("cmm.SEL.Get"));
        this.jRefreshButton.setToolTipText(L.t("cmm.SEL.Refresh_SEL_Information"));
        this.jRefreshButton.setText(L.t("cmm.SEL.Refresh"));
        this.jSaveButton.setToolTipText(L.t("cmm.SEL.Save_SEL_Records"));
        this.jSaveButton.setText(L.t("cmm.SEL.Save"));
        this.jDeleteButton.setToolTipText(L.t("cmm.SEL.Delete_SEL_Records"));
        this.jDeleteButton.setText(L.t("cmm.SEL.Delete"));
        this.jHELTypeRadioButton.setText(L.t("cmm.SEL.Event_Type_Health"));
        this.jMELTypeRadioButton.setText(L.t("cmm.SEL.Event_Type_Maintenance"));
        this.jHELVersionLabel.setText(L.t("cmm.SEL.SEL_Version"));
        this.jTotalEntriesLabel.setText(L.t("cmm.SEL.Total_Entries"));
        this.jFreeSpaceLabel.setText(L.t("cmm.SEL.Free_Space"));
        this.jRecentEntryAddedLabel.setText(L.t("cmm.SEL.Recent_Entry_Added"));
        this.jRecentEntryErasedLabel.setText(L.t("cmm.SEL.Recent_Entry_Erased"));
        this.jLabelTimestamp.setText(L.t("sel.Current_SEL_Device_Timestamp_colon"));
        this.jAllRadioButton.setText(L.t("cmm.SEL.All"));
        this.jFromRadioButton.setText(L.t("cmm.SEL.From"));
        this.jLastRadioButton.setText(L.t("cmm.SEL.Last"));
        this.jEventRangeToLabel.setText(L.t("cmm.SEL.To"));
        this.jLastEeventsLabel.setText(L.t("cmm.SEL.events"));
    }

    protected void setComponentsListenser() {
        this.jGetHELButton.addActionListener(e2 -> this.getEventButtonClicked(e2));
        this.jRefreshButton.addActionListener(e2 -> this.refreshButtonClicked(e2));
        this.jSaveButton.addActionListener(e2 -> this.saveButtonClicked(e2));
        this.jDeleteButton.addActionListener(e2 -> this.deleteEventButtonClicked(e2));
        this.jHELTypeRadioButton.addActionListener(e2 -> this.eventTypeRadioButtonSelected(e2));
        this.jMELTypeRadioButton.addActionListener(e2 -> this.eventTypeRadioButtonSelected(e2));
        this.jAllRadioButton.addActionListener(e2 -> this.eventTimeRangeRadioButtonSelected(e2));
        this.jFromRadioButton.addActionListener(e2 -> this.eventTimeRangeRadioButtonSelected(e2));
        this.jLastRadioButton.addActionListener(e2 -> this.eventTimeRangeRadioButtonSelected(e2));
        this.jEventRangeBeginTextField.getDocument().addDocumentListener(e2 -> this.setQueryRangeBeginTextField(e2));
        this.jEventRangeEndTextField.getDocument().addDocumentListener(e2 -> this.setQueryRangeEndTextField(e2));
        this.jEventRangeLastTextField.getDocument().addDocumentListener(e2 -> this.setQueryRangeLastTextField(e2));
        MouseListener listenser = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                e2.getComponent().requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        };
        this.jTopPanel.addMouseListener(listenser);
        this.jTopToolBar.addMouseListener(listenser);
        this.jBottomScrollPane.addMouseListener(listenser);
        this.jKeywordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e2) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.update();
            }

            public void update() {
                AbstractEventPanel.this.setKeywordTableFilterCondition((TableSorter)AbstractEventPanel.this.jEventTableTable.getModel(), AbstractEventPanel.this.jKeywordTextField.getText());
                ((TableSorter)AbstractEventPanel.this.jEventTableTable.getModel()).filter();
                AbstractEventPanel.this.filterCellRender.setKeyword(AbstractEventPanel.this.jKeywordTextField.getText());
            }
        });
        this.jTextFieldHelTime.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                Component comp = e2.getOppositeComponent();
                if (null == comp || null != comp && !comp.equals(AbstractEventPanel.this.jRefreshButton)) {
                    if (AbstractEventPanel.this.checkTimeRules()) {
                        AbstractEventPanel.this.setCurrentTimestamp();
                    } else {
                        AbstractEventPanel.this.dataTimeInvalidDialog();
                    }
                    AbstractEventPanel.this.getCurrentTimestamp();
                }
            }

            @Override
            public void focusGained(FocusEvent e2) {
            }
        });
        this.jTextFieldHelTime.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e2) {
                switch (e2.getKeyCode()) {
                    case 10: {
                        e2.getComponent().transferFocus();
                        break;
                    }
                    case 27: {
                        AbstractEventPanel.this.getCurrentTimestamp();
                        break;
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void keyReleased(KeyEvent e2) {
            }
        });
    }

    protected void getHealthInfo() {
        ISessionController sessionController = null;
        try {
            this.setCursor(new Cursor(3));
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiSELCommand, 10);
            if (sessionController != null) {
                this.healthInfo = ipmiSELCommand.getSELInfoModal();
                if (this.healthInfo != null) {
                    this.jHELVersionValueLabel.setText(this.healthInfo.getSELVersionString());
                    this.jTotalEntriesValueLabel.setText("" + this.healthInfo.getLogEntries());
                    this.jFreeSpaceValueLabel.setText(this.healthInfo.getFreeSpace() + " " + L.t("cmm.SEL.bytes"));
                    this.jRecentEntryAddedValueLabel.setText(ByteUtility.fourByteToDateFormat2(this.healthInfo.getMostRecentAdditionTimeStamp()));
                    this.jRecentEntryErasedValueLabel.setText(ByteUtility.fourByteToDateFormat2(this.healthInfo.getMostRecentEraseTimeStamp()));
                    this.jTextFieldHelTime.setText(ipmiSELCommand.getSELTimeWithSpecificFormat(EVENT_INFO_TIMESTAMP_FORMAT_FULL));
                    this.bottomToolbarMessage.setText(L.t("cmm.SEL.SEL_Information_refreshed"));
                }
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.toString());
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
        this.setCursor(new Cursor(0));
    }

    protected boolean isRedfishSupported() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand);
        if (null != sessionController) {
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            boolean isSupported = !IPMIMessagingCommand.isBeforeX12(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid);
            sessionController.closeSession();
            sessionController = null;
            return isSupported;
        }
        return false;
    }

    private String dataTimeRangeString() {
        String _template = " %s : %-12s\n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Year"), "2005 - 2037"));
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Month"), "1 - 12"));
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Day"), "1 - 31"));
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Hour"), "0 - 23"));
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Min"), "0 - 59"));
        fStr.append(String.format(" %s : %-12s\n", L.t("sel.Sec"), "0 - 59"));
        return fStr.toString();
    }

    private String dataTimeRangeHtml() {
        String msg = "<html>" + L.t("sel.Year") + ": " + 2005 + " - " + 2037 + "<br>" + L.t("sel.Month") + ": 1 - 12<br>" + L.t("sel.Day") + ": 1 - 31<br>" + L.t("sel.Hour") + ": 0 - 23<br>" + L.t("sel.Min") + ": 0 - 59<br>" + L.t("sel.Sec") + ": 0 - 59<br></html>";
        return msg;
    }

    private void dataTimeInvalidDialog() {
        String warningStr = L.t("sel.DateTime_invalid") + "\n\n" + this.dataTimeRangeString();
        JOptionPane.showMessageDialog(this, warningStr, L.t("sel.Warning"), 2);
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    private void setQueryRangeRadioButton(int type) {
        int[] args = type == 0 ? this.argsVecHEL : this.argsVecMEL;
        int queryType = args[0];
        int beginIndex = args[1];
        int endIndex = args[2];
        int lastIndex = args[3];
        this.jAllRadioButton.setSelected(queryType == 0);
        this.jFromRadioButton.setSelected(queryType == 1);
        this.jLastRadioButton.setSelected(queryType == 2);
        this.jEventRangeBeginTextField.setEditable(queryType == 1);
        this.jEventRangeEndTextField.setEditable(queryType == 1);
        this.jEventRangeLastTextField.setEditable(queryType == 2);
        this.jEventRangeBeginTextField.setText(beginIndex == 0 ? "" : String.valueOf(beginIndex));
        this.jEventRangeEndTextField.setText(endIndex == 0 ? "" : String.valueOf(endIndex));
        this.jEventRangeLastTextField.setText(lastIndex == 0 ? "" : String.valueOf(lastIndex));
    }

    private void setPrivilegeDisable(byte privilege) {
        if (privilege == 4) {
            this.jDeleteButton.setEnabled(true);
        } else {
            this.jDeleteButton.setEnabled(false);
        }
    }

    private void setTableHeader() {
        new Thread(() -> {
            this.isRedfishSupported = this.isRedfishSupported();
            this.setTableHeader(this.eventType, false);
        }).start();
    }

    private void setTableHeader(int type) {
        this.setTableHeader(type, false);
    }

    private void setTableHeader(int type, boolean clearAll) {
        this.jEventTableTable.removeAll();
        if (type == 0) {
            if (this.helTableSorter == null || clearAll) {
                this.helTableSorter = new TableSorter(new DefaultTableModel(this.getHELHeader().toArray(), 0));
            }
            this.jEventTableTable.setModel(this.helTableSorter);
        } else {
            if (this.melTableSorter == null || clearAll) {
                this.melTableSorter = new TableSorter(new DefaultTableModel(this.getMELHeader().toArray(), 0));
            }
            this.jEventTableTable.setModel(this.melTableSorter);
        }
        ((TableSorter)this.jEventTableTable.getModel()).cancelFilter();
        ((TableSorter)this.jEventTableTable.getModel()).filterConditions.clear();
        this.setTableHeaderWidth(type);
        this.jEventTableTable.invalidate();
    }

    private void setTableHeaderWidth(int type) {
        int[] helColWidths = new int[]{30, 140, 90, 80, 300};
        int[] helColX12Widths = new int[]{30, 60, 120, 80, 350};
        int[] melColWidths = new int[]{40, 120, 70, 100, 90, 230};
        int[] melColX12Widths = new int[]{40, 50, 115, 55, 100, 90, 230};
        int[] colWidths = type == 0 ? (this.isRedfishSupported ? helColX12Widths : helColWidths) : (this.isRedfishSupported ? melColX12Widths : melColWidths);
        int colCount = this.jEventTableTable.getColumnModel().getColumnCount();
        for (int idx = 0; idx < colCount; ++idx) {
            this.jEventTableTable.getColumnModel().getColumn(idx).setPreferredWidth(colWidths[idx]);
        }
    }

    private void setKeywordTableFilterCondition(TableSorter ts, String keyword) {
        ts.removeAllFilterCondition();
        ts.matchAll = false;
        int columeIdx = 0;
        while (columeIdx < ts.getColumnCount()) {
            FilterCondition keywordfilter = new FilterCondition();
            keywordfilter.filterOperator = 4;
            keywordfilter.filterColumnIndex = columeIdx++;
            keywordfilter.filterValue = keyword;
            ts.addFilterCondition(keywordfilter);
        }
    }

    private void setTableCellRenderer() {
        for (int i2 = 0; i2 < this.jEventTableTable.getColumnCount(); ++i2) {
            this.jEventTableTable.getColumnModel().getColumn(i2).setCellRenderer(this.filterCellRender);
        }
    }

    private Vector<String> getHELHeader() {
        Vector<String> headerList = new Vector<String>();
        headerList.add(L.t("sel.Event"));
        if (this.isRedfishSupported) {
            headerList.add(L.t("sel.Severity"));
        }
        headerList.add(L.t("sel.DateTime"));
        headerList.add(L.t("sel.Sensor_Type"));
        if (!this.isRedfishSupported) {
            headerList.add(L.t("sel.Sensor"));
        }
        headerList.add(L.t("sel.Description"));
        return headerList;
    }

    private Vector<String> getMELHeader() {
        Vector<String> headerList = new Vector<String>();
        headerList.add(L.t("cmm.SEL.Event"));
        if (this.isRedfishSupported) {
            headerList.add(L.t("sel.Severity"));
        }
        headerList.add(L.t("cmm.SEL.Time_Stamp"));
        headerList.add(L.t("cmm.SEL.Interface"));
        headerList.add(L.t("cmm.SEL.User"));
        headerList.add(L.t("cmm.SEL.Source"));
        headerList.add(L.t("cmm.SEL.Description"));
        return headerList;
    }

    private void setCurrentTimestamp() {
        new Thread(() -> this.setHealthInfo()).start();
    }

    private void getCurrentTimestamp() {
        new Thread(() -> this.getHealthInfo()).start();
    }

    private boolean checkTimeRules() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setLenient(false);
        sdf.applyPattern(EVENT_INFO_TIMESTAMP_FORMAT);
        try {
            Date time2Set = sdf.parse(this.jTextFieldHelTime.getText());
            String[] valueSet = this.jTextFieldHelTime.getText().split("/");
            int years = Integer.valueOf(valueSet[0]);
            if (2005 <= years && years <= 2037) {
                return true;
            }
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        return false;
    }

    private void setHealthInfo() {
        ISessionController sessionController = null;
        try {
            this.setCursor(new Cursor(3));
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiSELCommand);
            if (sessionController != null) {
                byte[] timeSecInByte = new byte[4];
                SimpleDateFormat sdf = new SimpleDateFormat(EVENT_INFO_TIMESTAMP_FORMAT_FULL);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
                Date time2Set = sdf.parse(this.jTextFieldHelTime.getText(), new ParsePosition(0));
                if (time2Set == null) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Date_Time_format_invalid"));
                } else {
                    try {
                        int secs = (int)(time2Set.getTime() / 1000L);
                        this.IntToByte(timeSecInByte, 0, secs);
                        ipmiSELCommand.setSELTime(timeSecInByte);
                    }
                    catch (NullPointerException ne) {
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Date_Time_format_invalid"));
                    }
                }
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.toString());
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
        this.setCursor(new Cursor(0));
    }

    private void handleMessageCenterObserver(Observable o, Object arg) {
        MessageCenter.ClassMessage classMessage = (MessageCenter.ClassMessage)arg;
        if (classMessage.from.equals("com.supermicro.ipmi.IPMISELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMIMELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMISDRCommand")) {
            this.bottomToolbarMessage.setText(classMessage.content);
        }
    }

    private void getEventButtonClicked(ActionEvent e2) {
        Runnable runnable = () -> {
            this.jGetHELButton.transferFocusBackward();
            this.jGetHELButton.setEnabled(false);
            this.jHELTypeRadioButton.setEnabled(false);
            this.jMELTypeRadioButton.setEnabled(false);
            this.jAllRadioButton.setEnabled(false);
            this.jFromRadioButton.setEnabled(false);
            this.jLastRadioButton.setEnabled(false);
            try {
                if (this.checkGetParameter()) {
                    this.setTableHeader(this.eventType, true);
                    MessageCenter.getInstance().addObserver(this.messageCenterObserver);
                    if (this.eventType == 0) {
                        if (this.isRedfishSupported) {
                            this.loadHELByRedFish();
                        } else {
                            this.loadHEL();
                        }
                    } else if (this.eventType == 1) {
                        if (this.isRedfishSupported) {
                            this.loadMELByRedFish();
                        } else {
                            this.loadMEL();
                        }
                    }
                    MessageCenter.getInstance().deleteObserver(this.messageCenterObserver);
                } else {
                    this.sWindow.setMessage("", "", "");
                    this.setCursor(new Cursor(0));
                }
                this.sWindow.setVisible(false);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), this.eventType == 0 ? L.t("cmm.SEL.Get_SEL_failed") : L.t("cmm.SEL.Get_MEL_failed"), L.t("sel.Warning"), 2);
            }
            this.jGetHELButton.setEnabled(true);
            this.jHELTypeRadioButton.setEnabled(true);
            this.jMELTypeRadioButton.setEnabled(true);
            this.jAllRadioButton.setEnabled(true);
            this.jFromRadioButton.setEnabled(true);
            this.jLastRadioButton.setEnabled(true);
            this.jGetHELButton.requestFocus();
        };
        new Thread(runnable).start();
    }

    private void refreshButtonClicked(ActionEvent e2) {
        Runnable runnable = () -> this.getHealthInfo();
        new Thread(runnable).start();
    }

    private boolean checkTableDataExists() {
        int rowCount = this.jEventTableTable.getModel().getRowCount();
        if (rowCount <= 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.No_data"));
            return false;
        }
        return true;
    }

    private boolean popupSaveFileDialog() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
        }
        fileChooser.resetChoosableFileFilters();
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("(*.txt or *.TXT)", "txt"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("(*.csv or *.CSV)", "csv"));
        fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[1]);
        if (fileChooser.showSaveDialog(null) == 0) {
            File xfi;
            String fileFormat = "";
            String fileDesc = fileChooser.getFileFilter().getDescription();
            if (fileDesc.contains("txt")) {
                fileFormat = ".txt";
            } else if (fileDesc.contains("csv")) {
                fileFormat = ".csv";
            }
            this.exportFileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (!this.exportFileName.contains(fileFormat)) {
                this.exportFileName = this.exportFileName + fileFormat;
            }
            if ((xfi = new File(this.exportFileName)).exists()) {
                return JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("sel.Do_you_want_to_overwrite_it"), L.t("sel.Request_Confirmation"), 0) == 0;
            }
            return true;
        }
        return false;
    }

    private StringBuffer getEventsFromTable() {
        int i2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> list = this.eventType == 0 ? this.getHELHeader() : this.getMELHeader();
        for (i2 = 0; i2 < list.size(); ++i2) {
            if (i2 != list.size() - 1) {
                stringBuffer.append(list.get(i2) + ",");
                continue;
            }
            stringBuffer.append(list.get(i2));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        for (i2 = 0; i2 < this.jEventTableTable.getRowCount(); ++i2) {
            for (int j2 = 0; j2 < this.jEventTableTable.getColumnCount(); ++j2) {
                if (j2 != this.jEventTableTable.getColumnCount() - 1) {
                    stringBuffer.append("\"" + (String)((TableSorter)this.jEventTableTable.getModel()).getValueAt(i2, j2) + "\",");
                    continue;
                }
                stringBuffer.append("\"" + (String)((TableSorter)this.jEventTableTable.getModel()).getValueAt(i2, j2) + "\"");
            }
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer;
    }

    private void setEventsToFile(StringBuffer buffer) {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.exportFileName);
            if (this.exportFileName.endsWith(".csv")) {
                byte[] utf8Bom = new byte[]{-17, -69, -65};
                outputStream.write(utf8Bom);
            }
            outputStream.write(buffer.toString().getBytes("UTF-8"));
            outputStream.close();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.save_to") + " " + this.exportFileName + " " + L.t("group.table.toolbar.completed"));
            this.bottomToolbarMessage.setText(L.t("sel.Event_Log_Export_done"));
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("sel.Warning"), 0);
            this.bottomToolbarMessage.setText(L.t("sel.Event_Log_Export_failed"));
        }
    }

    private void saveButtonClicked(ActionEvent e2) {
        if (this.checkTableDataExists() && this.popupSaveFileDialog()) {
            Runnable runnable = () -> this.setEventsToFile(this.getEventsFromTable());
            new Thread(runnable).start();
        }
    }

    private void deleteEventButtonClicked(ActionEvent e2) {
        Runnable runnable = () -> {
            int result = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Are_delete_logs"), L.t("cmm.SEL.Confirmation"), 0);
            if (result == 0) {
                if (this.eventType == 0) {
                    this.deleteAllSEL();
                } else {
                    this.deleteAllMEL();
                }
            }
        };
        new Thread(runnable).start();
    }

    private void setQueryRangeTextField(DocumentEvent e2, JTextField source) {
        int rangeInt = 0;
        int[] args = this.eventType == 0 ? this.argsVecHEL : this.argsVecMEL;
        boolean isNumbers = false;
        String rangeStr = null;
        Document doc = e2.getDocument();
        try {
            rangeStr = doc.getText(0, doc.getLength());
            rangeInt = rangeStr == null || rangeStr.isEmpty() ? 0 : Integer.parseInt(rangeStr);
            isNumbers = true;
        }
        catch (NumberFormatException | BadLocationException e1) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
        }
        if (isNumbers) {
            if (source.equals(this.jEventRangeBeginTextField)) {
                args[1] = rangeInt;
            } else if (source.equals(this.jEventRangeEndTextField)) {
                args[2] = rangeInt;
            } else if (source.equals(this.jEventRangeLastTextField)) {
                args[3] = rangeInt;
            }
        } else {
            Runnable runnable = () -> {
                if (source.equals(this.jEventRangeBeginTextField)) {
                    source.setText(args[1] == 0 ? "" : String.valueOf(args[1]));
                } else if (source.equals(this.jEventRangeEndTextField)) {
                    source.setText(args[2] == 0 ? "" : String.valueOf(args[2]));
                } else if (source.equals(this.jEventRangeLastTextField)) {
                    source.setText(args[3] == 0 ? "" : String.valueOf(args[3]));
                }
            };
            new Thread(runnable).start();
        }
    }

    private void setQueryRangeBeginTextField(DocumentEvent e2) {
        this.setQueryRangeTextField(e2, this.jEventRangeBeginTextField);
    }

    private void setQueryRangeEndTextField(DocumentEvent e2) {
        this.setQueryRangeTextField(e2, this.jEventRangeEndTextField);
    }

    private void setQueryRangeLastTextField(DocumentEvent e2) {
        this.setQueryRangeTextField(e2, this.jEventRangeLastTextField);
    }

    private void eventTypeRadioButtonSelected(ActionEvent e2) {
        if (e2.getSource().equals(this.jHELTypeRadioButton)) {
            this.eventType = 0;
            this.setQueryRangeRadioButton(this.eventType);
            this.setTableHeader(this.eventType);
            this.helTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
            this.jTopPanelCentral.setVisible(true);
            this.jRefreshButton.setEnabled(true);
        } else if (e2.getSource().equals(this.jMELTypeRadioButton)) {
            this.eventType = 1;
            this.setQueryRangeRadioButton(this.eventType);
            this.setTableHeader(this.eventType);
            this.melTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
            this.jTopPanelCentral.setVisible(false);
            this.jRefreshButton.setEnabled(false);
        }
        this.jKeywordTextField.setText("");
        ((TableSorter)this.jEventTableTable.getModel()).cancelSorting();
        this.filterCellRender.clearKeyword();
        this.setTableCellRenderer();
    }

    private void eventTimeRangeRadioButtonSelected(ActionEvent e2) {
        int[] args;
        int[] nArray = args = this.eventType == 0 ? this.argsVecHEL : this.argsVecMEL;
        if (e2.getSource().equals(this.jAllRadioButton)) {
            args[0] = 0;
        } else if (e2.getSource().equals(this.jFromRadioButton)) {
            args[0] = 1;
        } else if (e2.getSource().equals(this.jLastRadioButton)) {
            args[0] = 2;
        }
        this.jEventRangeBeginTextField.setEditable(e2.getSource().equals(this.jFromRadioButton));
        this.jEventRangeEndTextField.setEditable(e2.getSource().equals(this.jFromRadioButton));
        this.jEventRangeLastTextField.setEditable(e2.getSource().equals(this.jLastRadioButton));
    }

    private void deleteAllSEL() {
        ISessionController sessionController = null;
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiSELCommand);
        if (sessionController == null) {
            return;
        }
        ipmiSELCommand.clearSEL();
        sessionController.closeSession();
        this.setTableHeader(this.eventType, true);
        this.getHealthInfo();
    }

    private void deleteAllMEL() {
        IPMIOEMCommand ipmioemCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmioemCommand);
        if (sessionController == null) {
            return;
        }
        ipmioemCommand.clearSyslog();
        sessionController.closeSession();
        this.setTableHeader(this.eventType, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkGetParameter() throws Exception {
        if (!this.jAllRadioButton.isSelected()) {
            int entryCount = 0;
            if (this.eventType == 0) {
                if (this.healthInfo == null) {
                    this.getHealthInfo();
                }
                if (this.healthInfo == null) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Get_SEL_Info_failed"), L.t("sel.Warning"), 2);
                    return false;
                }
                entryCount = this.healthInfo.getLogEntries();
            } else {
                entryCount = this.loadMELEntryCount();
            }
            if (this.jFromRadioButton.isSelected()) {
                int from = 0;
                int to = 0;
                try {
                    from = Integer.parseInt(this.jEventRangeBeginTextField.getText());
                }
                catch (NullPointerException | NumberFormatException ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
                    return false;
                }
                try {
                    to = Integer.parseInt(this.jEventRangeEndTextField.getText());
                }
                catch (NullPointerException | NumberFormatException ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
                    return false;
                }
                if (from <= 0 || to <= 0 || from > to) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
                    return false;
                }
                if (from <= entryCount) {
                    if (to <= entryCount) return true;
                }
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Parameter_out_range"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (!this.jLastRadioButton.isSelected()) return true;
            int last = 0;
            try {
                last = Integer.parseInt(this.jEventRangeLastTextField.getText());
            }
            catch (NullPointerException | NumberFormatException ex) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (last <= 0) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Invalid_Index"), L.t("cmm.SEL.Warning"), 2);
                return false;
            }
            if (last <= entryCount) return true;
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Parameter_out_range"), L.t("cmm.SEL.Warning"), 2);
            return false;
        }
        if (!this.isRedfishSupported) return true;
        if (this.eventType != 1) return true;
        this.setCursor(new Cursor(3));
        this.sWindow.setVisible(true);
        this.sWindow.setMessage(L.t("cmm.SEL.Loading_MEL") + " ...", "", "");
        this.utils.clearRedfishResponse();
        try {
            Thread.sleep(500L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void loadMEL() {
        this.setCursor(new Cursor(3));
        this.sWindow.setVisible(true);
        this.sWindow.setMessage(L.t("cmm.SEL.Loading_MEL") + " ...", "", "");
        Object[][] entryDoubleArray = null;
        ArrayList<Object> entryArrayList = new ArrayList();
        try {
            int beginIndex = -1;
            int endIndex = -1;
            int last = -1;
            ISessionController sessionController = null;
            IPMIMELCommand command = new IPMIMELCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, command, 10);
            if (sessionController == null) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Session create failed");
                this.sWindow.setVisible(false);
                this.setCursor(new Cursor(0));
                return;
            }
            if (!command.update(EVENT_TIMESTAMP_FORMAT)) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "MEL parser get errors");
                this.sWindow.setVisible(false);
                this.setCursor(new Cursor(0));
                return;
            }
            sessionController.closeSession();
            if (this.jFromRadioButton.isSelected()) {
                beginIndex = Integer.parseInt(this.jEventRangeBeginTextField.getText());
                endIndex = Integer.parseInt(this.jEventRangeEndTextField.getText());
                entryArrayList = command.getEntryArrayList(beginIndex, endIndex);
            } else if (this.jLastRadioButton.isSelected()) {
                last = Integer.parseInt(this.jEventRangeLastTextField.getText());
                entryArrayList = command.getEntryArrayList(last);
            } else {
                entryArrayList = command.getEntryArrayList();
            }
            if (entryArrayList != null && entryArrayList.size() > 0) {
                entryDoubleArray = (Object[][])entryArrayList.toArray((T[])new Object[0][]);
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.MEL_is_empty"));
                this.sWindow.setVisible(false);
                this.setCursor(new Cursor(0));
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.getMessage());
            this.sWindow.setVisible(false);
            this.setCursor(new Cursor(0));
        }
        if (entryDoubleArray != null) {
            ((DefaultTableModel)this.melTableSorter.getTableModel()).setDataVector(entryDoubleArray, this.getMELHeader().toArray());
            this.jEventTableTable.setModel(this.melTableSorter);
            this.setTableHeaderWidth(this.eventType);
            this.melTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
            this.setTableCellRenderer();
            this.jEventTableTable.invalidate();
            this.sWindow.setMessage(L.t("cmm.SEL.Finished"), "", "");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sWindow.setMessage("", "", "");
        this.bottomToolbarMessage.setText(" ");
        this.setCursor(new Cursor(0));
    }

    private void loadMELByRedFish() {
        if (this.jAllRadioButton.isSelected()) {
            this.setCursor(new Cursor(3));
            this.sWindow.setVisible(true);
            this.sWindow.setMessage(L.t("cmm.SEL.Loading_MEL") + " ...", "", "");
        }
        Object[][] entryDoubleArray = null;
        List<HashMap<String, String>> entryMapList = null;
        ArrayList<Object[]> entryArrayList = new ArrayList<Object[]>();
        try {
            int beginIndex = -1;
            int endIndex = -1;
            int last = -1;
            if (this.utils.getRedfishResponse() == null) {
                String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/Managers/1/LogServices/Log1/Entries/";
                this.utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
            }
            if (this.jFromRadioButton.isSelected()) {
                beginIndex = Integer.parseInt(this.jEventRangeBeginTextField.getText());
                endIndex = Integer.parseInt(this.jEventRangeEndTextField.getText());
                entryMapList = this.utils.getEntryList(beginIndex, endIndex);
            } else if (this.jLastRadioButton.isSelected()) {
                last = Integer.parseInt(this.jEventRangeLastTextField.getText());
                entryMapList = this.utils.getEntryList(last);
            } else {
                entryMapList = this.utils.getEntryList();
            }
            if (entryMapList != null && entryMapList.size() > 0) {
                for (int index = 0; index < entryMapList.size(); ++index) {
                    ArrayList<String> singleEntry = new ArrayList<String>();
                    singleEntry.add(entryMapList.get(index).get("Id"));
                    singleEntry.add(entryMapList.get(index).get("Severity"));
                    singleEntry.add(this.utils.convertDatetimeFormat(entryMapList.get(index).get("Created")));
                    singleEntry.add(entryMapList.get(index).get("Oem/Supermicro/Interface"));
                    singleEntry.add(entryMapList.get(index).get("Oem/Supermicro/User"));
                    singleEntry.add(entryMapList.get(index).get("Oem/Supermicro/Source"));
                    singleEntry.add(entryMapList.get(index).get("Message"));
                    entryArrayList.add(singleEntry.toArray());
                }
                entryDoubleArray = (Object[][])entryArrayList.toArray((T[])new Object[0][]);
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.MEL_is_empty"));
                this.sWindow.setVisible(false);
                this.setCursor(new Cursor(0));
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.getMessage());
            this.sWindow.setVisible(false);
            this.setCursor(new Cursor(0));
        }
        if (entryDoubleArray != null) {
            ((DefaultTableModel)this.melTableSorter.getTableModel()).setDataVector(entryDoubleArray, this.getMELHeader().toArray());
            this.jEventTableTable.setModel(this.melTableSorter);
            this.setTableHeaderWidth(this.eventType);
            this.melTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
            this.setTableCellRenderer();
            this.jEventTableTable.invalidate();
            this.sWindow.setMessage(L.t("cmm.SEL.Finished"), "", "");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sWindow.setMessage("", "", "");
        this.bottomToolbarMessage.setText(" ");
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHEL() {
        int count = 1;
        byte[] productID = new byte[2];
        ISessionController sessionController = null;
        this.setCursor(new Cursor(3));
        try {
            this.sWindow.setVisible(true);
            this.sWindow.setMessage(L.t("cmm.SEL.Loading_HEL") + " ...", "", "");
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiSELCommand);
            if (sessionController != null) {
                ipmiSDRCommand.setIPMIInterface(ipmiSELCommand.getIPMIInterface());
                SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
                if (sdrInfo == null) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Get_SEL_failed"));
                } else {
                    ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
                    SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
                    if (selInfo == null) {
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.Get_SEL_failed"));
                    } else if (selInfo.getLogEntries() == 0) {
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.SEL_is_empty"));
                    } else {
                        ipmiOEMCommand.setIPMIInterface(ipmiSELCommand.getIPMIInterface());
                        productID = ipmiOEMCommand.getProductID();
                        if (productID == null) {
                            productID = new byte[2];
                        }
                        ArrayList list = null;
                        ArrayList<Object[]> entryArrayList = new ArrayList<Object[]>();
                        Object[][] entries = null;
                        if (this.jAllRadioButton.isSelected()) {
                            list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
                        } else if (this.jFromRadioButton.isSelected()) {
                            int from = Integer.parseInt(this.jEventRangeBeginTextField.getText());
                            int to = Integer.parseInt(this.jEventRangeEndTextField.getText());
                            list = ipmiSELCommand.getSELEntriesByRange(from, to);
                            count = from;
                        } else if (this.jLastRadioButton.isSelected()) {
                            int last = Integer.parseInt(this.jEventRangeLastTextField.getText());
                            list = ipmiSELCommand.getSELEntriesByRange(selInfo.getLogEntries() - last + 1, selInfo.getLogEntries());
                            count = selInfo.getLogEntries() - last + 1;
                        }
                        if (list != null && list.size() != 0) {
                            for (SELRecord item : list) {
                                ArrayList<String> raw = new ArrayList<String>();
                                raw.add("" + count);
                                raw.add(ByteUtility.fourByteToDateFormatSpecific(item.getTimeStamp(), EVENT_TIMESTAMP_FORMAT));
                                raw.add(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                                if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197 && (item.getEventType() & 0xFF) != 112) {
                                    byte data1 = item.getEventData1();
                                    if (data1 == -64 || data1 == -63 || data1 == -62 || data1 == -61) {
                                        raw.add(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()) + " " + (byte)(item.getSensorNumber() & 0xFF));
                                    } else {
                                        raw.add(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                                    }
                                } else {
                                    Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                                    raw.add((String)(sensorName != null ? sensorName : ""));
                                }
                                raw.add(GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3(), productID, item.getSensorNumber()));
                                entryArrayList.add(raw.toArray());
                                ++count;
                            }
                            if (entryArrayList != null && entryArrayList.size() > 0) {
                                entries = (Object[][])entryArrayList.toArray((T[])new Object[0][]);
                            }
                            this.sWindow.setMessage(L.t("cmm.SEL.Finished"), "", "");
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ((DefaultTableModel)this.helTableSorter.getTableModel()).setDataVector(entries, this.getHELHeader().toArray());
                            this.setTableHeaderWidth(this.eventType);
                            this.helTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
                            this.setTableCellRenderer();
                            this.jEventTableTable.invalidate();
                        } else {
                            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.SEL_is_Failed"));
                        }
                    }
                }
            }
            this.sWindow.setMessage("", "", "");
            this.bottomToolbarMessage.setText(" ");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.getMessage());
        }
        finally {
            if (sessionController != null) {
                sessionController.closeSession();
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void loadHELByRedFish() {
        this.setCursor(new Cursor(3));
        this.sWindow.setVisible(true);
        this.sWindow.setMessage(L.t("cmm.SEL.Loading_HEL") + " ...", "", "");
        Object[][] entryDoubleArray = null;
        List<HashMap<String, String>> entryMapList = null;
        ArrayList<Object[]> entryArrayList = new ArrayList<Object[]>();
        try {
            int beginIndex = -1;
            int endIndex = -1;
            int last = -1;
            String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
            this.utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
            if (this.jFromRadioButton.isSelected()) {
                beginIndex = Integer.parseInt(this.jEventRangeBeginTextField.getText());
                endIndex = Integer.parseInt(this.jEventRangeEndTextField.getText());
                entryMapList = this.utils.getEntryList(beginIndex, endIndex);
            } else if (this.jLastRadioButton.isSelected()) {
                last = Integer.parseInt(this.jEventRangeLastTextField.getText());
                entryMapList = this.utils.getEntryList(last);
            } else {
                entryMapList = this.utils.getEntryList();
            }
            if (entryMapList != null && entryMapList.size() > 0) {
                for (int index = 0; index < entryMapList.size(); ++index) {
                    ArrayList<String> singleEntry = new ArrayList<String>();
                    String sensorType = entryMapList.get(index).get("OemSensorType");
                    if (sensorType == null || sensorType.isEmpty()) {
                        sensorType = Optional.ofNullable(entryMapList.get(index).get("SensorType")).orElse("");
                    }
                    singleEntry.add(entryMapList.get(index).get("Id"));
                    singleEntry.add(entryMapList.get(index).get("Severity"));
                    singleEntry.add(this.utils.convertDatetimeFormat(entryMapList.get(index).get("Created")));
                    singleEntry.add(sensorType);
                    singleEntry.add(entryMapList.get(index).get("Message") + " - " + entryMapList.get(index).get("EntryCode"));
                    entryArrayList.add(singleEntry.toArray());
                }
                entryDoubleArray = (Object[][])entryArrayList.toArray((T[])new Object[0][]);
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.SEL.SEL_is_empty"));
                this.sWindow.setVisible(false);
                this.setCursor(new Cursor(0));
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), e2.getMessage());
            this.sWindow.setVisible(false);
            this.setCursor(new Cursor(0));
        }
        if (entryDoubleArray != null) {
            ((DefaultTableModel)this.helTableSorter.getTableModel()).setDataVector(entryDoubleArray, this.getHELHeader().toArray());
            this.jEventTableTable.setModel(this.helTableSorter);
            this.setTableHeaderWidth(this.eventType);
            this.helTableSorter.setTableHeader(this.jEventTableTable.getTableHeader());
            this.setTableCellRenderer();
            this.jEventTableTable.invalidate();
            this.sWindow.setMessage(L.t("cmm.SEL.Finished"), "", "");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sWindow.setMessage("", "", "");
        this.bottomToolbarMessage.setText(" ");
        this.setCursor(new Cursor(0));
    }

    private int loadMELEntryCount() throws Exception {
        int entryCount = 0;
        if (this.isRedfishSupported) {
            this.setCursor(new Cursor(3));
            this.sWindow.setVisible(true);
            this.sWindow.setMessage(L.t("cmm.SEL.Loading_MEL") + " ...", "", "");
            String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/Managers/1/LogServices/Log1/Entries/";
            this.utils.clearRedfishResponse();
            this.utils.sendRedfishGet(this.ipmiInterfaceConfig, url);
            entryCount = this.utils.getEntryListCount();
        } else {
            entryCount = Integer.MAX_VALUE;
        }
        if (entryCount == 0) {
            this.sWindow.setMessage("", "", "");
            this.sWindow.setVisible(false);
            this.setCursor(new Cursor(0));
        }
        return entryCount;
    }

    private class EventMessageCenterObserver
    implements Observer {
        private AbstractEventPanel adaptee;

        public EventMessageCenterObserver(AbstractEventPanel adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void update(Observable o, Object arg) {
            this.adaptee.handleMessageCenterObserver(o, arg);
        }
    }

    public static interface SimpleDocumentListener
    extends DocumentListener {
        public void update(DocumentEvent var1);

        @Override
        default public void insertUpdate(DocumentEvent e2) {
            this.update(e2);
        }

        @Override
        default public void removeUpdate(DocumentEvent e2) {
            this.update(e2);
        }

        @Override
        default public void changedUpdate(DocumentEvent e2) {
            this.update(e2);
        }
    }
}

