/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.JPMBusPanel;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class BBPDischargeSettingDialog
extends JDialog {
    IPMIInterfaceConfig config;
    byte slaveAddress;
    JPMBusPanel jpmBusPanel = null;
    private JTextField remaingDaysTextField;
    private JRadioButton rdbtnAutoRadioButton;
    private JRadioButton rdbtnUserRadioButton;

    public BBPDischargeSettingDialog() {
        this.setTitle("Battery Discharge Setting");
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "Discharge", 4, 2, null, null));
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        this.rdbtnAutoRadioButton = new JRadioButton("Auto");
        this.rdbtnAutoRadioButton.setToolTipText("Auto Discharge by day");
        this.rdbtnAutoRadioButton.setBounds(6, 24, 96, 23);
        panel.add(this.rdbtnAutoRadioButton);
        this.rdbtnUserRadioButton = new JRadioButton("User");
        this.rdbtnUserRadioButton.setToolTipText("Manually Discharge by user");
        this.rdbtnUserRadioButton.setBounds(6, 49, 87, 23);
        panel.add(this.rdbtnUserRadioButton);
        this.remaingDaysTextField = new JTextField();
        this.remaingDaysTextField.setBounds(149, 25, 55, 21);
        panel.add(this.remaingDaysTextField);
        this.remaingDaysTextField.setColumns(10);
        JLabel lblDays = new JLabel("Days");
        lblDays.setBounds(214, 28, 46, 15);
        panel.add(lblDays);
        JButton btnUpdate = new JButton("Update");
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        BBPDischargeSettingDialog.this.updateButtonActionPerformed();
                    }
                };
                thread.start();
            }
        });
        btnUpdate.setBounds(331, 24, 87, 23);
        panel.add(btnUpdate);
        JLabel lblDischargeImmediately = new JLabel("(Will discharge immediately)");
        lblDischargeImmediately.setForeground(Color.BLUE);
        lblDischargeImmediately.setBounds(93, 53, 222, 15);
        panel.add(lblDischargeImmediately);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbtnAutoRadioButton);
        buttonGroup.add(this.rdbtnUserRadioButton);
        JLabel lblAfter = new JLabel("After");
        lblAfter.setHorizontalAlignment(11);
        lblAfter.setBounds(93, 28, 46, 15);
        panel.add(lblAfter);
        this.setSize(434, 112);
        this.setResizable(false);
    }

    public JPMBusPanel getJPMBusPanel() {
        return this.jpmBusPanel;
    }

    public void setJPMBusPanel(JPMBusPanel jpmBusPanel) {
        this.jpmBusPanel = jpmBusPanel;
    }

    public void updateButtonActionPerformed() {
        boolean result = false;
        try {
            result = this.update();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
        }
        if (result) {
            this.dispose();
        }
    }

    public boolean update() throws Exception {
        if (this.rdbtnAutoRadioButton.isSelected()) {
            int day = 0;
            try {
                day = Integer.parseInt(this.remaingDaysTextField.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid days");
                return false;
            }
            if (day > 63 || day < 1) {
                JOptionPane.showMessageDialog(this, "Day out of range");
                return false;
            }
            this.helpUpdateDischarge(true, day);
        } else {
            this.helpUpdateDischarge(false, 0);
        }
        return true;
    }

    private void helpUpdateDischarge(boolean isAuto, int days) throws Exception {
        ISessionController sessionController = IPMIVersion.getSessionController(this.config);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(this.config);
        if (rmcp == null) {
            return;
        }
        ipmiI2CPMBusCommand.setIPMIInterface(rmcp);
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(this.slaveAddress);
        if (isAuto) {
            ipmiI2CPMBusCommand.setAutoDischargeCommand((byte)days);
        } else {
            ipmiI2CPMBusCommand.setUserDischargeCommand();
        }
        if (this.jpmBusPanel != null) {
            this.jpmBusPanel.loadBBP(false);
        }
        sessionController.closeSession();
    }

    public void load(IPMIInterfaceConfig config, byte slaveAddress) throws Exception {
        this.config = config;
        this.slaveAddress = slaveAddress;
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiI2CPMBusCommand.setIPMIInterface(rmcp);
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(slaveAddress);
        IPMII2CPMBusCommand.BBPHealth bbpHealth = ipmiI2CPMBusCommand.getAllBBP();
        sessionController.closeSession();
        if ((byte)(bbpHealth.getBatteryDischargeTimerCommand() & 0x80) == -128) {
            this.rdbtnAutoRadioButton.setSelected(true);
        } else {
            this.rdbtnUserRadioButton.setSelected(true);
        }
        int dischargeDay = bbpHealth.getBatteryDischargeTimerCommand() & 0x3F;
        this.remaingDaysTextField.setText("" + dischargeDay);
    }
}

