/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.DeviceFile;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;

public class ConfigAccessor {
    private String fileName;
    private String path;
    private static ConfigAccessor instance = null;

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConfigAccessor(String path, String fileName) {
        this.path = path;
        this.fileName = path + File.separator + fileName;
        File aPath = new File(this.path);
        File aFile = new File(this.fileName);
        if (!aPath.isDirectory()) {
            aPath.mkdirs();
        }
        if (!aFile.isFile()) {
            this.createFile(aFile);
        }
    }

    public static ConfigAccessor getInstance() {
        if (instance == null) {
            instance = new ConfigAccessor(".\\", "msr2.ini");
        }
        return instance;
    }

    public static ConfigAccessor getInstance(String path, String fileName) {
        if (instance == null) {
            instance = new ConfigAccessor(path, fileName);
        }
        return instance;
    }

    public static ConfigAccessor getInstance(String fileName) {
        if (instance == null) {
            instance = new ConfigAccessor(".", fileName);
        }
        return instance;
    }

    private void createFile(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.close();
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    private String getChineseUnicode(String str) {
        String result = "";
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char chr1 = str.charAt(i2);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + "\\u" + Integer.toHexString(chr1) : result + str.charAt(i2);
        }
        return result;
    }

    private void updatePropertyAsWindowsAdmin(String key, String value) {
        boolean isRemoveAction = value == null;
        boolean isRemoveTargetExists = false;
        try {
            String tempString;
            FileReader fileReader = new FileReader(this.fileName);
            BufferedReader bufferReader = new BufferedReader(fileReader);
            Vector<String> propVec = new Vector<String>();
            key = key.replaceAll("\\\\", "\\\\\\\\");
            key = key.replaceAll("\\s", "\\\\ ");
            key = this.getChineseUnicode(key);
            while ((tempString = bufferReader.readLine()) != null) {
                try {
                    String[] token = tempString.split("=");
                    if (token == null || token.length <= 0) continue;
                    if (isRemoveAction) {
                        if (!token[0].equals(key)) {
                            propVec.add(tempString);
                            continue;
                        }
                        isRemoveTargetExists = true;
                        continue;
                    }
                    if (token[0].equals(key)) {
                        fileReader.close();
                        return;
                    }
                    propVec.add(tempString);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
            fileReader.close();
            if (!isRemoveAction) {
                propVec.add(key + "=" + value);
            }
            if (isRemoveAction && !isRemoveTargetExists) {
                return;
            }
            DeviceFile.saveFileAsWindowsAdmin(this.fileName, propVec);
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
    }

    public void removeProperty(String key) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.remove(key);
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, "MyTitle");
            fis.close();
            fos.close();
        }
        catch (IOException ioe) {
            if (DeviceFile.isPermissionDeniedOnWindows(ioe.getMessage())) {
                this.updatePropertyAsWindowsAdmin(key, null);
            }
            System.out.println(ioe.toString());
        }
    }

    public void setProperty(String key, String value) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.put(key, value);
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, "MyTitle");
            fis.close();
            fos.close();
        }
        catch (IOException ioe) {
            if (DeviceFile.isPermissionDeniedOnWindows(ioe.getMessage())) {
                this.updatePropertyAsWindowsAdmin(key, value);
            }
            System.out.println(ioe.toString());
        }
    }

    public String getProperty(String key) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            String retStr = p.getProperty(key);
            fis.close();
            return retStr;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

