/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ComboTabListener;
import IPMIView20.DateTimeInterface;
import IPMIView20.ErrorStatusTextField;
import IPMIView20.ExpandableComponent;
import IPMIView20.IPMIDateTimeControl;
import IPMIView20.IPMIView20;
import IPMIView20.NTPTimeZoneItems;
import IPMIView20.NetworkSettingUtility;
import IPMIView20.RoundTextField;
import IPMIView20.ToggleSwitch;
import IPMIView20.WideComboBox;
import IPMIView20.WideComboBoxItem;
import IPMIView20.blade.SWindow;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.redfish.text.NTPConfigurationHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DateTimePanel
extends ExpandableComponent
implements DateTimeInterface {
    private JPanel bodyPanel = new JPanel();
    private JPanel parantPanel = null;
    private JPanel ntpStatusRowPanel = new JPanel();
    private JPanel timeZoneRowPanel = new JPanel();
    private JPanel primaryServerRowPanel = new JPanel();
    private JPanel secondaryServerRowPanel = new JPanel();
    private JPanel currentDateTimeRowPanel = new JPanel();
    private JPanel dateTimeSavingStatusRowPanel = new JPanel();
    private JPanel autoRefreshRowPanel = new JPanel();
    private JLabel ntpStatusLabel = new JLabel();
    private JLabel timeZoneLabel = new JLabel();
    private JLabel primaryServerLabel = new JLabel();
    private JLabel secondaryServerLabel = new JLabel();
    private JLabel currentDateTimeLabel = new JLabel();
    private JLabel dateTimeSavingStatusLabel = new JLabel();
    private JLabel autoRefreshStatusLabel = new JLabel();
    private ToggleSwitch ntpStatusToggleSwitch = new ToggleSwitch();
    private ToggleSwitch daylightSavingStatusToggleSwitch = new ToggleSwitch();
    private ToggleSwitch autoRefreshStatusToggleSwitch = new ToggleSwitch();
    private WideComboBox<WideComboBoxItem<String>> timeZoneWComboBox = new WideComboBox();
    private RoundTextField primaryServerTextField = new RoundTextField();
    private RoundTextField secondaryServerTextField = new RoundTextField();
    private RoundTextField currentDateTimeTextField = new RoundTextField();
    private ErrorStatusTextField primaryNTPStatusLabel = new ErrorStatusTextField();
    private ErrorStatusTextField secondaryNTPStatusLabel = new ErrorStatusTextField();
    private NTPTimeZoneItems timeZoneItems = new NTPTimeZoneItems();
    private NTPConfigurationHelper.NTPAttributes attributeBackup = null;
    private Timer pollingTimer;
    private SWindow popupWindow;
    private ComboTabListener comboTabListener = null;
    private IPMIDateTimeControl controller = new IPMIDateTimeControl(this);
    private JLabel bottomMessage = null;

    public DateTimePanel(JPanel parant) {
        this.parantPanel = parant;
        this.setComponetsMisc();
        this.setComponentsText();
        this.setComponentsSize();
        this.setComponentsLayout();
        this.setComponentsListenser();
    }

    public void setLayoutSettings(JLabel label) {
        this.bottomMessage = label;
    }

    public void setIPMIConfig(IPMIInterfaceConfig config) {
        this.controller.setConfig(config);
    }

    public void setTabListener(ComboTabListener listener) {
        this.comboTabListener = listener;
    }

    public void startTimer(long delay) {
        if (this.pollingTimer == null) {
            this.pollingTimer = new Timer();
            this.pollingTimer.schedule((TimerTask)new PollingTask(), delay, 5000L);
        }
    }

    public void stopTimer() {
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
            this.pollingTimer = null;
        }
    }

    private void reload() {
        this.controller.getNTPSettings();
    }

    public synchronized void refresh() {
        if (this.autoRefreshStatusToggleSwitch.isActivated()) {
            this.stopTimer();
        }
        this.reload();
    }

    public synchronized void save() {
        if (this.autoRefreshStatusToggleSwitch.isActivated()) {
            this.stopTimer();
        }
        if (this.isConfigurationValid()) {
            this.controller.setNTPSettings(this.snapshot());
        }
    }

    public synchronized void stop() {
        if (this.autoRefreshStatusToggleSwitch.isActivated()) {
            this.stopTimer();
        }
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        super.setExpanded(isExpanded);
    }

    @Override
    protected void setComponetLocked(boolean locked) {
        SwingUtilities.invokeLater(() -> {
            if (locked) {
                this.comboTabListener.toolbarStatus(1, new int[0]);
                this.comboTabListener.toolbarStatus(2, new int[0]);
            } else {
                this.comboTabListener.toolbarStatus(0, new int[0]);
            }
            this.ntpStatusToggleSwitch.setEnabled(!locked);
            this.autoRefreshStatusToggleSwitch.setEnabled(!locked);
            this.setOptionsEnable(!locked && this.ntpStatusToggleSwitch.isActivated());
            this.setCursor(new Cursor(locked ? 3 : 0));
            this.parantPanel.setCursor(new Cursor(locked ? 3 : 0));
        });
    }

    private void setWholePanelDisable() {
        this.comboTabListener.toolbarStatus(0, new int[0]);
        this.comboTabListener.toolbarStatus(3, 4, 1);
        this.ntpStatusToggleSwitch.setEnabled(false);
        this.autoRefreshStatusToggleSwitch.setEnabled(false);
        this.setOptionsEnable(false);
        this.setCursor(new Cursor(0));
        this.parantPanel.setCursor(new Cursor(0));
    }

    private void setComponetsMisc() {
        this.timeZoneItems.getItems().forEach(e2 -> this.timeZoneWComboBox.addItem(new WideComboBoxItem<String>(this.timeZoneItems.getDispalyFormat((String)e2))));
        this.primaryNTPStatusLabel.setEditable(false);
        this.secondaryNTPStatusLabel.setEditable(false);
        this.primaryNTPStatusLabel.setHidColor(new Color(240, 240, 240));
        this.secondaryNTPStatusLabel.setHidColor(new Color(240, 240, 240));
        this.primaryServerTextField.setValid(true);
        this.secondaryServerTextField.setValid(true);
        this.currentDateTimeTextField.setEditable(false);
        this.currentDateTimeTextField.setEnabled(false);
        this.currentDateTimeTextField.setValid(true);
        this.popupWindow = new SWindow(IPMIView20.getInstance());
    }

    private void setComponentsText() {
        super.setHeaderText("Date and Time");
        this.ntpStatusLabel.setText("NTP Enable");
        this.timeZoneLabel.setText("Time Zone");
        this.primaryServerLabel.setText("Primary NTP Server");
        this.secondaryServerLabel.setText("Secondary NTP Server");
        this.currentDateTimeLabel.setText("Date and Time");
        this.dateTimeSavingStatusLabel.setText("Daylight Savings Time");
        this.autoRefreshStatusLabel.setText("Auto Refresh");
        this.primaryNTPStatusLabel.setTextField("");
        this.secondaryNTPStatusLabel.setTextField("");
    }

    private void setComponentsSize() {
        this.ntpStatusToggleSwitch.setMinimumSize(new Dimension(57, 20));
        this.ntpStatusToggleSwitch.setMaximumSize(new Dimension(57, 20));
        this.ntpStatusToggleSwitch.setPreferredSize(new Dimension(57, 20));
        this.daylightSavingStatusToggleSwitch.setMinimumSize(new Dimension(57, 20));
        this.daylightSavingStatusToggleSwitch.setMaximumSize(new Dimension(57, 20));
        this.daylightSavingStatusToggleSwitch.setPreferredSize(new Dimension(57, 20));
        this.autoRefreshStatusToggleSwitch.setMinimumSize(new Dimension(57, 20));
        this.autoRefreshStatusToggleSwitch.setMaximumSize(new Dimension(57, 20));
        this.autoRefreshStatusToggleSwitch.setPreferredSize(new Dimension(57, 20));
        int maxPanelW = Integer.MAX_VALUE;
        int maxPanelH = 60;
        this.ntpStatusRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.timeZoneRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.primaryServerRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.secondaryServerRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.currentDateTimeRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.dateTimeSavingStatusRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        this.autoRefreshRowPanel.setMaximumSize(new Dimension(maxPanelW, maxPanelH));
        int maxLabelW = 200;
        int maxLabelH = 30;
        this.ntpStatusLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.timeZoneLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.primaryServerLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.secondaryServerLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.currentDateTimeLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.dateTimeSavingStatusLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.autoRefreshStatusLabel.setMinimumSize(new Dimension(maxLabelW, maxLabelH));
        this.ntpStatusLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.timeZoneLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.primaryServerLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.secondaryServerLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.currentDateTimeLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.dateTimeSavingStatusLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.autoRefreshStatusLabel.setPreferredSize(new Dimension(maxLabelW, maxLabelH));
        this.ntpStatusLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.timeZoneLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.primaryServerLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.secondaryServerLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.currentDateTimeLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.dateTimeSavingStatusLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        this.autoRefreshStatusLabel.setMaximumSize(new Dimension(maxLabelW, maxLabelH));
        int textFieldMinW = 150;
        int textFieldMinH = 20;
        this.timeZoneWComboBox.setMinimumSize(new Dimension(textFieldMinW, textFieldMinH));
        this.primaryServerTextField.setMinimumSize(new Dimension(textFieldMinW, textFieldMinH));
        this.secondaryServerTextField.setMinimumSize(new Dimension(textFieldMinW, textFieldMinH));
        this.currentDateTimeTextField.setMinimumSize(new Dimension(textFieldMinW, textFieldMinH));
        this.timeZoneWComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, textFieldMinH));
        this.primaryServerTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, textFieldMinH));
        this.secondaryServerTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, textFieldMinH));
        this.currentDateTimeTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, textFieldMinH));
        int errorLabelMinW = 260;
        this.primaryNTPStatusLabel.setMinimumSize(new Dimension(errorLabelMinW, textFieldMinH));
        this.primaryNTPStatusLabel.setMaximumSize(new Dimension(errorLabelMinW, textFieldMinH));
        this.primaryNTPStatusLabel.setPreferredSize(new Dimension(errorLabelMinW, textFieldMinH));
        this.secondaryNTPStatusLabel.setMinimumSize(new Dimension(errorLabelMinW, textFieldMinH));
        this.secondaryNTPStatusLabel.setMaximumSize(new Dimension(errorLabelMinW, textFieldMinH));
        this.secondaryNTPStatusLabel.setPreferredSize(new Dimension(errorLabelMinW, textFieldMinH));
    }

    private void setComponentsLayout() {
        int verticalStrut = 5;
        this.bodyPanel.setLayout(new BoxLayout(this.bodyPanel, 1));
        this.bodyPanel.add(this.ntpStatusRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.timeZoneRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.primaryServerRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.secondaryServerRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.currentDateTimeRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.dateTimeSavingStatusRowPanel);
        this.bodyPanel.add(Box.createVerticalStrut(verticalStrut));
        this.bodyPanel.add(this.autoRefreshRowPanel);
        this.bodyPanel.add(Box.createVerticalGlue());
        super.setBodyComponet(this.bodyPanel, 260);
        this.ntpStatusRowPanel.setLayout(new BoxLayout(this.ntpStatusRowPanel, 0));
        this.timeZoneRowPanel.setLayout(new BoxLayout(this.timeZoneRowPanel, 0));
        this.primaryServerRowPanel.setLayout(new BoxLayout(this.primaryServerRowPanel, 0));
        this.secondaryServerRowPanel.setLayout(new BoxLayout(this.secondaryServerRowPanel, 0));
        this.currentDateTimeRowPanel.setLayout(new BoxLayout(this.currentDateTimeRowPanel, 0));
        this.dateTimeSavingStatusRowPanel.setLayout(new BoxLayout(this.dateTimeSavingStatusRowPanel, 0));
        this.autoRefreshRowPanel.setLayout(new BoxLayout(this.autoRefreshRowPanel, 0));
        int leftPadding = 40;
        int midPadding = 40;
        int rightPadding = 40;
        int errorLabelPadding = 10;
        this.ntpStatusRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.ntpStatusRowPanel.add(this.ntpStatusLabel);
        this.ntpStatusRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.ntpStatusRowPanel.add(this.ntpStatusToggleSwitch);
        this.ntpStatusRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.timeZoneRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.timeZoneRowPanel.add(this.timeZoneLabel);
        this.timeZoneRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.timeZoneRowPanel.add(this.timeZoneWComboBox);
        this.timeZoneRowPanel.add(Box.createHorizontalStrut(errorLabelPadding));
        this.timeZoneRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.primaryServerRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.primaryServerRowPanel.add(this.primaryServerLabel);
        this.primaryServerRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.primaryServerRowPanel.add(this.primaryServerTextField);
        this.primaryServerRowPanel.add(Box.createHorizontalStrut(errorLabelPadding));
        this.primaryServerRowPanel.add(this.primaryNTPStatusLabel);
        this.primaryServerRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.secondaryServerRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.secondaryServerRowPanel.add(this.secondaryServerLabel);
        this.secondaryServerRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.secondaryServerRowPanel.add(this.secondaryServerTextField);
        this.secondaryServerRowPanel.add(Box.createHorizontalStrut(errorLabelPadding));
        this.secondaryServerRowPanel.add(this.secondaryNTPStatusLabel);
        this.secondaryServerRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.currentDateTimeRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.currentDateTimeRowPanel.add(this.currentDateTimeLabel);
        this.currentDateTimeRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.currentDateTimeRowPanel.add(this.currentDateTimeTextField);
        this.currentDateTimeRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.dateTimeSavingStatusRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.dateTimeSavingStatusRowPanel.add(this.dateTimeSavingStatusLabel);
        this.dateTimeSavingStatusRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.dateTimeSavingStatusRowPanel.add(this.daylightSavingStatusToggleSwitch);
        this.dateTimeSavingStatusRowPanel.add(Box.createHorizontalStrut(rightPadding));
        this.autoRefreshRowPanel.add(Box.createHorizontalStrut(leftPadding));
        this.autoRefreshRowPanel.add(this.autoRefreshStatusLabel);
        this.autoRefreshRowPanel.add(Box.createHorizontalStrut(midPadding));
        this.autoRefreshRowPanel.add(this.autoRefreshStatusToggleSwitch);
        this.autoRefreshRowPanel.add(Box.createHorizontalStrut(rightPadding));
    }

    private void setComponentsListenser() {
        this.ntpStatusToggleSwitch.addActionListenser(e2 -> this.setOptionsEnable(e2));
        this.autoRefreshStatusToggleSwitch.addActionListenser(e2 -> {
            this.stopTimer();
            if (e2) {
                this.startTimer(0L);
            }
        });
        FocusListener textFieldFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                DateTimePanel.this.eventHandler(e2);
            }

            @Override
            public void focusGained(FocusEvent e2) {
            }
        };
        this.primaryServerTextField.addFocusListener(textFieldFocusListener);
        this.secondaryServerTextField.addFocusListener(textFieldFocusListener);
        this.timeZoneWComboBox.addItemListener(e2 -> {
            if (e2.getStateChange() == 1 && this.timeZoneItems.isAutoDstSupported()) {
                ArrayList<Boolean> supportedAutoList = this.timeZoneItems.getSupportList();
                WideComboBoxItem item = (WideComboBoxItem)e2.getItem();
                int selectedIndex = item.getIndex();
                this.daylightSavingStatusToggleSwitch.setEnabled(supportedAutoList.get(selectedIndex));
                if (selectedIndex == this.timeZoneItems.getCurrentTimezoneIndex()) {
                    this.daylightSavingStatusToggleSwitch.setActivated(this.timeZoneItems.isCurrentItemAutoDstEnabled());
                } else {
                    this.daylightSavingStatusToggleSwitch.setActivated(false);
                }
            }
        });
    }

    private void eventHandler(ComponentEvent e2) {
        this.verifyInputTextField((JTextField)e2.getSource());
    }

    private boolean isValidNTPServer(String address) {
        boolean isValid = NetworkSettingUtility.isValidIPv4(address) || NetworkSettingUtility.isValidIPv6(address, false) || NetworkSettingUtility.isValidDomainName(address);
        return isValid;
    }

    private void verifyInputTextField(JTextField textField) {
        String content = textField.getText();
        boolean isValid = this.isValidNTPServer(content);
        if (textField.equals(this.primaryServerTextField)) {
            this.setPrimaryNTPStatus(isValid);
        } else if (textField.equals(this.secondaryServerTextField)) {
            this.setSecondaryNTPStatus(isValid);
        }
    }

    private void setPrimaryNTPStatus(boolean isValid) {
        SwingUtilities.invokeLater(() -> {
            this.primaryNTPStatusLabel.setTextField(isValid ? "" : "      It is illegal IPv4/IPv6 address or domain name!");
            this.primaryNTPStatusLabel.invalidate();
            this.primaryNTPStatusLabel.repaint();
            this.primaryServerTextField.setValid(isValid);
            this.primaryServerRowPanel.updateUI();
        });
    }

    private void setSecondaryNTPStatus(boolean isValid) {
        SwingUtilities.invokeLater(() -> {
            this.secondaryNTPStatusLabel.setTextField(isValid ? "" : "      It is illegal IPv4/IPv6 address or domain name!");
            this.secondaryNTPStatusLabel.invalidate();
            this.secondaryNTPStatusLabel.repaint();
            this.secondaryServerTextField.setValid(isValid);
            this.secondaryServerRowPanel.updateUI();
        });
    }

    private void setOptionsEnable(boolean enable) {
        this.timeZoneWComboBox.setEnabled(enable);
        this.primaryServerTextField.setEnabled(enable);
        this.secondaryServerTextField.setEnabled(enable);
        if (!enable) {
            if (!this.isValidNTPServer(this.primaryServerTextField.getText()) && this.attributeBackup != null) {
                this.primaryServerTextField.setText(this.attributeBackup.getPrimaryNTPServer());
            }
            if (!this.isValidNTPServer(this.secondaryServerTextField.getText()) && this.attributeBackup != null) {
                this.secondaryServerTextField.setText(this.attributeBackup.getSecondaryNTPServer());
            }
            if (this.primaryNTPStatusLabel.isVisible()) {
                this.setPrimaryNTPStatus(true);
            }
            if (this.secondaryNTPStatusLabel.isVisible()) {
                this.setSecondaryNTPStatus(true);
            }
        }
        if (this.timeZoneItems.isAutoDstSupported()) {
            boolean toggleSwitchStatus = enable ? this.timeZoneItems.getSupportList().get(this.timeZoneWComboBox.getSelectedIndex()) : false;
            this.daylightSavingStatusToggleSwitch.setEnabled(toggleSwitchStatus);
        } else {
            this.daylightSavingStatusToggleSwitch.setEnabled(enable);
        }
    }

    private NTPConfigurationHelper.NTPAttributes snapshot() {
        NTPConfigurationHelper helper = this.controller.getConfigurationHelper();
        NTPConfigurationHelper.NTPAttributes attributes = helper.getConfigurationInstance();
        attributes.setTimezoneCountrySupported(this.timeZoneItems.isTimezoneCountrySupported());
        attributes.setAutoDstSupported(this.timeZoneItems.isAutoDstSupported());
        attributes.setNTPEnable(this.ntpStatusToggleSwitch.isActivated());
        attributes.setDaylightSavingTimeEnable(this.daylightSavingStatusToggleSwitch.isActivated());
        attributes.setPrimaryNTPServer(this.primaryServerTextField.getText());
        attributes.setSecondaryNTPServer(this.secondaryServerTextField.getText());
        attributes.setTimezone(this.timeZoneItems.getItemValue(this.timeZoneWComboBox.getSelectedIndex(), false));
        attributes.setTimezoneIndex(this.timeZoneWComboBox.getSelectedIndex() + 1);
        return attributes;
    }

    private void update(NTPConfigurationHelper.NTPAttributes attributes) {
        if (attributes != null) {
            this.attributeBackup = attributes;
            if (!this.timeZoneItems.isTimezoneSetup()) {
                if (attributes.isTimezoneCountrySupported()) {
                    this.timeZoneItems.setItems(IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList());
                    this.timeZoneItems.setSupportList(IPMIOEMWebSettingCommand.getNTPTimeZoneSupportAutoList());
                } else {
                    this.timeZoneItems.setItems(IPMIOEMWebSettingCommand.getNTPTimeZoneList());
                }
                if (attributes.isAutoDstSupported()) {
                    this.dateTimeSavingStatusLabel.setText("Auto Daylight Savings Time");
                }
                this.timeZoneItems.setAutoDstSupported(attributes.isAutoDstSupported());
                this.timeZoneItems.setTimezoneCountrySupported(attributes.isTimezoneCountrySupported());
                this.timeZoneItems.getItems().forEach(e2 -> this.timeZoneWComboBox.addItem(new WideComboBoxItem<String>(this.timeZoneItems.getDispalyFormat((String)e2))));
            }
            int selectedIndex = this.timeZoneItems.getItemIndex(attributes.getTimezone());
            this.ntpStatusToggleSwitch.setActivated(attributes.isNTPEnable());
            this.daylightSavingStatusToggleSwitch.setActivated(attributes.isDaylightSavingTimeEnable());
            this.primaryServerTextField.setText(attributes.getPrimaryNTPServer());
            this.secondaryServerTextField.setText(attributes.getSecondaryNTPServer());
            this.timeZoneItems.setCurrentTimezoneIndex(selectedIndex);
            this.timeZoneItems.setCurrentItemAutoDstEnabled(attributes.isDaylightSavingTimeEnable());
            this.timeZoneWComboBox.setSelectedIndex(selectedIndex);
            this.currentDateTimeTextField.setText(attributes.getDateTime());
            if (attributes.isAutoDstSupported()) {
                this.daylightSavingStatusToggleSwitch.setEnabled(this.timeZoneItems.getSupportList().get(selectedIndex));
            } else {
                this.daylightSavingStatusToggleSwitch.setEnabled(true);
            }
            this.verifyInputTextField(this.primaryServerTextField);
            this.verifyInputTextField(this.secondaryServerTextField);
        } else {
            if (this.timeZoneWComboBox.getSelectedIndex() > 0) {
                this.timeZoneWComboBox.setSelectedIndex(0);
            }
            this.ntpStatusToggleSwitch.setActivated(false);
            this.daylightSavingStatusToggleSwitch.setActivated(false);
            this.autoRefreshStatusToggleSwitch.setActivated(false);
            this.primaryServerTextField.setText("");
            this.secondaryServerTextField.setText("");
            this.currentDateTimeTextField.setText("");
        }
    }

    private boolean isConfigurationValid() {
        if (this.primaryNTPStatusLabel.isVisible() || this.secondaryNTPStatusLabel.isVisible()) {
            Object[] options = new Object[]{"OK"};
            JOptionPane.showOptionDialog(this, "Invalid NTP server setting", "Error", -1, 0, null, options, options[0]);
            return false;
        }
        return true;
    }

    @Override
    public void updateStatus(int status, Object obj) {
        if (status == 1) {
            this.setComponetLocked(true);
        } else if (status == 0) {
            this.update((NTPConfigurationHelper.NTPAttributes)obj);
            this.setComponetLocked(false);
            this.bottomMessage.setText("Get NTP settings done");
            if (this.autoRefreshStatusToggleSwitch.isActivated()) {
                this.startTimer(5000L);
            }
        } else if (status == 4) {
            if (this.autoRefreshStatusToggleSwitch.isActivated()) {
                this.stopTimer();
            }
            this.setComponetLocked(true);
            String suffix = obj != null && obj instanceof Integer ? "(" + ((Integer)obj).toString() + ")" : "";
            this.popupWindow.setMessage("Saving... It may take a while to see changes" + suffix + ".", "", "");
            this.popupWindow.setVisible(true);
        } else if (status == 5) {
            this.popupWindow.setMessage("Done", "", "");
            this.bottomMessage.setText("Set NTP settings done");
        } else if (status == 3) {
            this.setComponetLocked(false);
            this.popupWindow.setVisible(false);
            if (this.autoRefreshStatusToggleSwitch.isActivated()) {
                this.startTimer(0L);
            } else {
                this.reload();
            }
        } else if (status == 7) {
            this.stopTimer();
            this.update((NTPConfigurationHelper.NTPAttributes)obj);
            this.setWholePanelDisable();
            this.popupWindow.setVisible(false);
            this.bottomMessage.setText("Insufficient privilege to get NTP information");
        } else {
            this.setComponetLocked(false);
            this.popupWindow.setVisible(false);
            if (status == 2) {
                this.bottomMessage.setText("Get NTP settings failed");
            } else if (status == 6) {
                this.bottomMessage.setText("Set NTP settings failed");
            }
        }
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        @Override
        public void run() {
            DateTimePanel.this.reload();
        }
    }
}

