/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.DropShadowPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExpandableComponent
extends DropShadowPanel {
    private static final int HEADER_HEIGHT = 40;
    private static final int COMPONENT_HEIGHT = 50;
    private Icon advIcon = new ImageIcon(this.getClass().getResource("/images/advanced.png"));
    private Icon addIcon = new ImageIcon(this.getClass().getResource("/images/btn_Add.png"));
    private Icon minusIcon = new ImageIcon(this.getClass().getResource("/images/btn_minus.png"));
    private JLabel advancedLabel = new JLabel();
    private JLabel addLabel = new JLabel();
    private JLabel titleLabel = new JLabel();
    private JPanel headerPanel = new JPanel();
    private JPanel bodyPanel = new JPanel();
    private int componentHeight = 50;
    private int expandHeight = 0;

    public ExpandableComponent() {
        this(50);
    }

    public ExpandableComponent(int height) {
        this.componentHeight = height;
        this.setComponentsLayout();
        this.setComponentMisc();
        this.setComponentsColor();
        this.setComponentsSize();
        this.setComponentsFontAndText();
        this.setComponentsListenser();
    }

    private void setComponentsLayout() {
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
        this.bodyPanel.setLayout(new BoxLayout(this.bodyPanel, 1));
        this.headerPanel.add(Box.createHorizontalStrut(10));
        this.headerPanel.add(this.advancedLabel);
        this.headerPanel.add(Box.createHorizontalStrut(5));
        this.headerPanel.add(this.titleLabel);
        this.headerPanel.add(Box.createHorizontalGlue());
        this.headerPanel.add(this.addLabel);
        this.headerPanel.add(Box.createHorizontalStrut(10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.headerPanel);
    }

    private void setComponentMisc() {
        this.bodyPanel.setVisible(false);
        this.advancedLabel.setIcon(this.advIcon);
        this.addLabel.setIcon(this.addIcon);
    }

    private void setComponentsColor() {
        this.headerPanel.setBackground(Color.WHITE);
    }

    private void setComponentsSize() {
        this.headerPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 40));
        this.headerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        this.headerPanel.setPreferredSize(new Dimension(320, 40));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, this.componentHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setPreferredSize(new Dimension(320, this.componentHeight));
    }

    private void setComponentsFontAndText() {
        Color color = new Color(96, 96, 96);
        Font font = this.titleLabel.getFont();
        font = font.deriveFont(font.getStyle() | 1);
        font = font.deriveFont(12.0f);
        this.titleLabel.setFont(font);
        this.titleLabel.setForeground(color);
    }

    private void setComponentsListenser() {
        MouseListener advancedSettingListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                ExpandableComponent.this.setExpanded(ExpandableComponent.this.bodyPanel.isVisible());
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                ExpandableComponent.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                ExpandableComponent.this.setCursor(new Cursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }
        };
        this.headerPanel.addMouseListener(advancedSettingListener);
        this.advancedLabel.addMouseListener(advancedSettingListener);
        this.addLabel.addMouseListener(advancedSettingListener);
        this.titleLabel.addMouseListener(advancedSettingListener);
    }

    protected void setExpanded(boolean isExpanded) {
        this.bodyPanel.setVisible(!isExpanded);
        this.addLabel.setIcon(isExpanded ? this.addIcon : this.minusIcon);
        Dimension collapseDimension = new Dimension(this.getWidth(), this.componentHeight);
        Dimension expandDimension = new Dimension(this.getWidth(), 40 + this.expandHeight);
        this.setPreferredSize(isExpanded ? collapseDimension : expandDimension);
    }

    public void setHeaderText(String text) {
        this.titleLabel.setText(text);
    }

    public void setBodyComponet(JComponent component, int height) {
        this.bodyPanel.add(Box.createVerticalGlue());
        this.bodyPanel.add(component);
        this.bodyPanel.add(Box.createVerticalGlue());
        this.add(this.bodyPanel);
        this.expandHeight = height;
    }

    protected void setComponetLocked(boolean locked) {
    }
}

