/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FlashRedFishBaseControl;
import IPMIView20.FlashRedFishInterface;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;

public class FlashFirmwareRedFishControl
extends FlashRedFishBaseControl {
    public FlashFirmwareRedFishControl(FlashRedFishInterface redfishInterface) {
        super(redfishInterface);
    }

    @Override
    protected void setConfiguration(boolean preserveCFG, boolean preserveSDR, boolean preserveSSL, boolean backupImage) {
        this.requestBody = "{\"Targets\":[\"/redfish/v1/Managers/1\"],\"@Redfish.OperationApplyTime\":\"Immediate\",\"Oem\":{\"Supermicro\":{\"BMC\":{\"PreserveCfg\": " + (preserveCFG ? "true" : "false") + ",\"PreserveSdr\": " + (preserveSDR ? "true" : "false") + ",\"PreserveSsl\": " + (preserveSSL ? "true" : "false") + ",\"BackupBMC\": " + (backupImage ? "true" : "false") + "}}}}";
    }

    @Override
    protected String getTargetVersion(String ip, String username, String password) {
        if (!this.checkStringNotEmpty(ip)) {
            this.listenser.updateMessage("IP cannot be empty");
            return null;
        }
        if (!this.checkStringNotEmpty(username)) {
            this.listenser.updateMessage("Username cannot be empty");
            return null;
        }
        if (!this.checkStringNotEmpty(password)) {
            this.listenser.updateMessage("Password cannot be empty");
            return null;
        }
        this.loginIP = ip;
        this.loginID = username;
        this.loginPWD = password;
        this.interfaceConfig.setIp(ip);
        this.interfaceConfig.setUserName(username);
        this.interfaceConfig.setPassword(password);
        this.interfaceConfig.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.interfaceConfig, ipmiGlobalCommand);
        if (sessionController == null) {
            return null;
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        sessionController.closeSession();
        if (deviceInfo.usingAuxiliaryFWVesion) {
            return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]);
        }
        return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
    }

    @Override
    protected String getImageVersion(String ip, String filename) throws Exception {
        if (!this.checkStringNotEmpty(ip)) {
            this.listenser.updateMessage("IP cannot be empty");
            return null;
        }
        if (!this.checkStringNotEmpty(filename)) {
            this.listenser.updateMessage("filename cannot be empty");
            return null;
        }
        String imageVersion = null;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
        try {
            if (IPMIMessagingCommand.isX12GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12(filename);
            } else if (IPMIMessagingCommand.isX12RoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12RoT(filename);
            } else if (IPMIMessagingCommand.isX12RoTHW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12RoTHW1(filename);
            } else if (IPMIMessagingCommand.isX12RoTHW2GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12RoTHW2(filename);
            } else if (IPMIMessagingCommand.isAST2600GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionAST2600(filename);
            } else if (IPMIMessagingCommand.isAST2600HW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionAST2600HW1(filename);
            } else if (IPMIMessagingCommand.isH12RoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH12RoT(filename);
            } else if (IPMIMessagingCommand.isH13ROTMAC12GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13RoTMAC12(filename);
            } else if (IPMIMessagingCommand.isH13ROTMAC34GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13RoTMAC34(filename);
            } else if (IPMIMessagingCommand.isH12SSFFGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH12SSFF(filename);
            } else if (IPMIMessagingCommand.isH12SSFRGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH12SSFR(filename);
            } else if (IPMIMessagingCommand.isB12RoTHW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB12RoTHW1(filename);
            } else if (IPMIMessagingCommand.isB12AST2600GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB12AST2600RoTHW1(filename);
            } else if (IPMIMessagingCommand.isX12DGOGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12DGO(filename);
            } else if (IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionAST2600HW1ROT20(filename);
            } else if (IPMIMessagingCommand.isB12AST2600MAC1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB12AST2600MAC1(filename);
            } else if (IPMIMessagingCommand.isM12GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionM12(filename);
            } else if (IPMIMessagingCommand.isH13GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13(filename);
            } else if (IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13AST2600NonROT(filename);
            } else if (IPMIMessagingCommand.isX12AST2600NonRoT(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12SDV(filename);
            } else if (IPMIMessagingCommand.isAST2600NonRoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionAST2600NonRoT(filename);
            } else if (IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12STW(filename);
            } else if (IPMIMessagingCommand.isX12DSCGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12DSC(filename);
            } else if (IPMIMessagingCommand.isH12SSGGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH12SSG(filename);
            } else if (IPMIMessagingCommand.isB3ST1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB3AST2500(filename);
            } else if (IPMIMessagingCommand.isB3SD1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB3AST2600(filename);
            } else if (IPMIMessagingCommand.isB4SA1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB4AST2600(filename);
            } else if (IPMIMessagingCommand.isX12DGQGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12DGQ(filename);
            } else if (IPMIMessagingCommand.isH12DSGGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH12DSG(filename);
            } else if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionHGIMEZZ(filename);
            } else if (IPMIMessagingCommand.isX13ROTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13ROT(filename);
            } else if (IPMIMessagingCommand.isX13ROTHW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13ROTHW1(filename);
            } else if (IPMIMessagingCommand.isX13ROT8WAYSGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13ROT8WAYS(filename);
            } else if (IPMIMessagingCommand.isX13ROTMAC1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13ROTMAC1(filename);
            } else if (IPMIMessagingCommand.isX12SPTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12SPT(filename);
            } else if (IPMIMessagingCommand.isB13AST2600RoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB13ROT(filename);
            } else if (IPMIMessagingCommand.isX12DGUGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX12DGU(filename);
            } else if (IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionMicroBladeCMMAST2600(filename);
            } else if (IPMIMessagingCommand.isX13DeltaNextGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13DeltaNext(filename);
            } else if (IPMIMessagingCommand.isH13DeltaNextGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13DeltaNext(filename);
            } else if (IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13DeltaNextHW1(filename);
            } else if (IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13AST2600HW1Rot20(filename);
            } else if (IPMIMessagingCommand.isX13AST2600NonRoTGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13AST2600NonRoT(filename);
            } else if (IPMIMessagingCommand.isX13AST2600NonRoTHW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13AST2600NonRoTHW1(filename);
            } else if (IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13AST2600ROT20Lego(filename);
            } else if (IPMIMessagingCommand.isJBOF2600GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionJBOFAST2600(filename);
            } else if (IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionG1AST2600ROT20Lego(filename);
            } else if (IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX14AST2600ROT20(filename);
            } else if (IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH14AST2600ROT20HW2(filename);
            } else if (IPMIMessagingCommand.isX13OpenBMCHW2GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13OpenBmcHW2(filename);
            } else if (IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionH13OpenBMCHW2(filename);
            } else if (IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX14AST2600ROT20HW2(filename);
            } else if (IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX13AST2600ROT20SBB(filename);
            } else if (IPMIMessagingCommand.isAOMSCMOpenBMCLegoGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionAOMSCMOpenBMCLego(filename);
            } else if (IPMIMessagingCommand.isB14AST2600RoT20GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionB14ROT(filename);
            } else if (IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX14AST2600ROT20DCMHS(filename);
            } else if (IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid)) {
                imageVersion = this.redfishFlash.checkFirmwareVersionX14AST2600ROT20MAC1(filename);
            } else {
                this.listenser.updateMessage("Target BMC type error");
            }
        }
        catch (Exception e2) {
            this.listenser.updateMessage(e2.getMessage());
        }
        return imageVersion;
    }

    @Override
    protected void doFlashing() {
        this.listenser.updateState(1);
        if (!this.checkStringNotEmpty(this.requestBody)) {
            this.listenser.updateState(0);
            return;
        }
        if (!this.checkLogin()) {
            this.listenser.updateState(2);
            return;
        }
        if (!this.checkFileExists()) {
            this.listenser.updateState(4);
            return;
        }
        Runnable runnable = () -> {
            try {
                this.redfishFlash.flashWorker(this.interfaceConfig, this.imageFile, this.requestBody, true);
            }
            catch (Exception e2) {
                this.listenser.updateMessage(e2.toString());
            }
            this.listenser.updateState(7);
        };
        new Thread(runnable).start();
    }
}

