/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIDeviceControlInterface;
import IPMIView20.IPMIDeviceProfile;
import IPMIView20.IPMIView20;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class IPMIDeviceControl {
    private final int THREAD_POOL_MAXIMUN = 2;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    private IPMIDeviceControlInterface deviceStateListener;
    private ThreadPoolExecutor excutor;
    private IPMIDeviceProfile profile;

    public IPMIDeviceControl(IPMIInterfaceConfig config, IPMIDeviceControlInterface listener) {
        this.ipmiInterfaceConfig = config;
        this.deviceStateListener = listener;
        this.excutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        this.profile = new IPMIDeviceProfile();
    }

    public void getSystemInformation() {
        this.excutor.submit(() -> {
            this.deviceStateListener.updateState(1, new Integer[0]);
            ISessionController sessionController = null;
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
            IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
            IPMII2CPMBusCommand ipmiI2cPMBusCommand = new IPMII2CPMBusCommand(null);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.clearInfo();
            } else {
                byte[] guid = ipmiMessagingCommand.getSystemGUID();
                IPMIInterface ipmiInterface = ipmiMessagingCommand.getIPMIInterface();
                ipmiOEMCommand.setIPMIInterface(ipmiInterface);
                ipmiLanCommand.setIPMIInterface(ipmiInterface);
                ipmiGlobalCommand.setIPMIInterface(ipmiInterface);
                ipmiI2cPMBusCommand.setIPMIInterface(ipmiInterface);
                ipmiChassisCommand.setIPMIInterface(ipmiInterface);
                DeviceInfo devInfo = this.getDeviceInfo(ipmiGlobalCommand);
                this.getBmcFwVersion(devInfo);
                this.getIpmiVersion(devInfo);
                this.getModelName(devInfo);
                this.getRedfishVersion();
                this.getBmcMacAddress(ipmiLanCommand);
                this.getBmcFwBuildTime(ipmiOEMCommand);
                this.getPowerState(ipmiChassisCommand);
                this.getBiosInfo(ipmiOEMCommand, guid);
                this.getCpldVersion(ipmiOEMCommand, ipmiI2cPMBusCommand, guid);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            this.deviceStateListener.updateState(0, new Integer[0]);
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void getChassisPowerState() {
        this.excutor.submit(() -> {
            this.deviceStateListener.updateState(1, new Integer[0]);
            ISessionController sessionController = null;
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiChassisCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setChassisPowerState(false);
            } else {
                this.getPowerState(ipmiChassisCommand);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            this.deviceStateListener.updateState(0, new Integer[0]);
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void setChassisPowerState(int state) {
        this.excutor.submit(() -> this.lambda$setChassisPowerState$2(state));
    }

    public void getUidMode() {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setUidState(false);
            } else {
                int state = 0;
                try {
                    state = ipmiOEMCommand.isUIDLit() ? 1 : 0;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.deviceStateListener.updateState(6, state);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void getFanSpeed() {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setFanSpeedMode(-1);
            } else {
                int state = -1;
                try {
                    state = ipmiOEMCommand.getFANSpeedMode();
                    this.profile.setFanSpeedMode(state);
                }
                catch (IPMIException e2) {
                    e2.printStackTrace();
                }
                this.deviceStateListener.updateState(10, state);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void getFanCapability() {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setFanSpeedMode(-1);
            } else {
                int capability = -1;
                try {
                    capability = ipmiOEMCommand.getFANSpeedModeCapability();
                    this.profile.setFanSpeedCapability((byte)capability);
                }
                catch (IPMIException e2) {
                    e2.printStackTrace();
                }
                this.deviceStateListener.updateState(9, capability);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void getBootOption() {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
            } else {
                ipmiChassisCommand.setIPMIInterface(ipmiOEMCommand.getIPMIInterface());
                boolean isOlderBootOrder = ipmiOEMCommand.isOlderBootOptionDevice();
                GlobalDefine.BootDevice bDevice = GlobalDefine.BootDevice.NONE;
                try {
                    bDevice = ipmiChassisCommand.getBootDeviceOption(isOlderBootOrder);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (bDevice == null) {
                    this.deviceStateListener.updateState(2, new Integer[0]);
                } else {
                    this.deviceStateListener.updateState(13, this.getBootDeviceIndex(bDevice));
                    if (sessionController.closeSession()) {
                        sessionController = null;
                    }
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void setUidMode(boolean enable) {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setUidState(false);
            } else {
                boolean result = enable ? ipmiOEMCommand.enableUIDLED() : ipmiOEMCommand.disableUIDLED();
                this.deviceStateListener.updateState(7, enable ? 1 : 0, result ? 1 : 0);
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void setFanSpeed(int mode) {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
                this.profile.setFanSpeedMode(-1);
            } else {
                try {
                    ipmiOEMCommand.setFanSpeedModeCommand((byte)mode);
                    this.deviceStateListener.updateState(11, 1);
                }
                catch (Exception e2) {
                    this.deviceStateListener.updateState(11, 0);
                }
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public void setBootOption(int index) {
        this.excutor.submit(() -> {
            ISessionController sessionController = null;
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiOEMCommand, 10);
            if (sessionController == null) {
                this.deviceStateListener.updateState(2, new Integer[0]);
            } else {
                boolean result;
                ipmiChassisCommand.setIPMIInterface(ipmiOEMCommand.getIPMIInterface());
                boolean isOlderBootOrder = ipmiOEMCommand.isOlderBootOptionDevice();
                GlobalDefine.BootDevice bootDevice = this.getBootDeviceEnum(index);
                boolean bl = result = bootDevice != null ? ipmiChassisCommand.setBootDeviceOption(bootDevice, isOlderBootOrder) : false;
                if (!result) {
                    this.deviceStateListener.updateState(2, new Integer[0]);
                } else {
                    result = ipmiChassisCommand.keepBootFlagValidBit();
                    this.deviceStateListener.updateState(14, result ? 1 : 0, index);
                    if (sessionController.closeSession()) {
                        sessionController = null;
                    }
                }
            }
            if (sessionController != null) {
                sessionController.closeSession();
            }
        });
    }

    public IPMIDeviceProfile getDeviceProfile() {
        return this.profile;
    }

    private DeviceInfo getDeviceInfo(IPMIGlobalCommand command) {
        return command.getDevice();
    }

    private void getBmcMacAddress(IPMILanCommand command) {
        String macAddr = command.getMAC();
        this.profile.setBmcMacAddress(macAddr);
    }

    private void getBmcFwVersion(DeviceInfo deviceInfo) {
        String fwVer = null;
        if (deviceInfo != null) {
            fwVer = deviceInfo.usingAuxiliaryFWVesion ? String.format("%02d", deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]) : String.format("%02d", deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
        }
        this.profile.setBmcFwVersion(fwVer);
    }

    private void getBmcFwBuildTime(IPMIOEMCommand command) {
        String fwBuildTime = null;
        try {
            byte[] bytes = command.getFirmwareBuild();
            String s = new String(bytes);
            char c2 = s.toCharArray()[0];
            if (bytes != null && c2 != '\u0000') {
                fwBuildTime = ByteUtility.transferDateFormat(s);
            }
        }
        catch (IPMIException e2) {
            fwBuildTime = null;
        }
        this.profile.setBmcFwBuildTime(fwBuildTime);
    }

    private void getBiosInfo(IPMIOEMCommand command, byte[] guid) {
        if (!(IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid))) {
            try {
                byte[] bytes = command.getBiosVer();
                String s = null;
                char c2 = '\u0000';
                if (bytes != null) {
                    s = new String(bytes);
                    c2 = s.toCharArray()[0];
                }
                if (bytes != null && c2 != '\u0000') {
                    s = s.trim();
                    this.profile.setBiosFwVersion(s);
                } else {
                    this.profile.setBiosFwVersion("");
                }
                bytes = command.getBiosDate();
                if (bytes != null) {
                    s = new String(bytes);
                    c2 = s.toCharArray()[0];
                }
                if (bytes != null && c2 != '\u0000') {
                    this.profile.setBiosFwBuildTime(ByteUtility.transferDateFormatFromBiosFormat(s));
                } else {
                    this.profile.setBiosFwBuildTime("");
                }
            }
            catch (IPMIException e2) {
                this.profile.setBiosFwVersion("");
                this.profile.setBiosFwBuildTime("");
            }
        }
    }

    private void getCpldVersion(IPMIOEMCommand oemCommand, IPMII2CPMBusCommand busCommand, byte[] guid) {
        String cpld = null;
        cpld = IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isJBOF2500GUID(guid) || IPMIMessagingCommand.isJBOD2500GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) ? busCommand.getPLLDversion2500() : (IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) || IPMIMessagingCommand.isX12DGUGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isX12RoTHW2GUID(guid) || IPMIMessagingCommand.isX13ROTGUID(guid) || IPMIMessagingCommand.isX13ROTHW1GUID(guid) || IPMIMessagingCommand.isX13ROTMAC1GUID(guid) || IPMIMessagingCommand.isX13ROT8WAYSGUID(guid) || IPMIMessagingCommand.isX13DeltaNextGUID(guid) || IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isB14AST2600RoT20GUID(guid) || IPMIMessagingCommand.isB13AST2600RoTGUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isB3SD1GUID(guid) || IPMIMessagingCommand.isB4SA1GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isH13ROTMAC12GUID(guid) || IPMIMessagingCommand.isH13ROTMAC34GUID(guid) || IPMIMessagingCommand.isH13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid) || IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid) || IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid) || IPMIMessagingCommand.isJBOF2600GUID(guid) || IPMIMessagingCommand.isAOMSCMOpenBMCLegoGUID(guid) ? oemCommand.getRotCPLDversion() : (IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isH13GUID(guid) ? busCommand.getTatlowCPLDVersion() : (IPMIMessagingCommand.isHGIMEZZGUID(guid) ? busCommand.getHGICarrierBoardCPLDVersion() : busCommand.getCPLDversion())));
        this.profile.setCpldVersion(cpld);
    }

    private void getRedfishVersion() {
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.ipmiInterfaceConfig.getIp()) + "/redfish/v1/";
        BasicAuthClient bc = new BasicAuthClient(this.ipmiInterfaceConfig);
        try {
            int result = bc.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode version = node.path("RedfishVersion");
                String versionStr = version.asText();
                this.profile.setRedfishVersion(versionStr);
            } else {
                this.profile.setRedfishVersion("N/A");
            }
        }
        catch (Exception e2) {
            this.profile.setRedfishVersion("N/A");
        }
    }

    private void getIpmiVersion(DeviceInfo deviceInfo) {
        String ipmiVer = null;
        if (deviceInfo != null) {
            ipmiVer = deviceInfo.IPMIVersion == 2 ? "2.0" : "Unknown";
        }
        this.profile.setIpmiVersion(ipmiVer);
    }

    private void getModelName(DeviceInfo deviceInfo) {
        String modelName = null;
        if (deviceInfo != null) {
            modelName = IPMIOEMCommand.getBoardModel(deviceInfo.productID);
        }
        this.profile.setModelName(modelName);
    }

    private void getPowerState(IPMIChassisCommand command) {
        try {
            if (command.isPowerOn()) {
                this.profile.setPowerState(true);
            } else {
                this.profile.setPowerState(false);
            }
        }
        catch (IPMIException e2) {
            this.profile.setPowerState(false);
        }
    }

    public GlobalDefine.BootDevice getBootDeviceEnum(int index) {
        switch (index) {
            case 0: {
                return GlobalDefine.BootDevice.NONE;
            }
            case 1: {
                return GlobalDefine.BootDevice.PXE;
            }
            case 2: {
                return GlobalDefine.BootDevice.HD_DEFAULT;
            }
            case 3: {
                return GlobalDefine.BootDevice.CD_DVD;
            }
            case 4: {
                return GlobalDefine.BootDevice.BIOS;
            }
            case 5: {
                return GlobalDefine.BootDevice.USB_KEY;
            }
            case 6: {
                return GlobalDefine.BootDevice.USB_HDD;
            }
            case 7: {
                return GlobalDefine.BootDevice.USB_FLOPPY;
            }
            case 8: {
                return GlobalDefine.BootDevice.USB_CD_DVD;
            }
            case 9: {
                return GlobalDefine.BootDevice.UEFI_HD;
            }
            case 10: {
                return GlobalDefine.BootDevice.UEFI_CD_DVD;
            }
            case 11: {
                return GlobalDefine.BootDevice.UEFI_USB_KEY;
            }
            case 12: {
                return GlobalDefine.BootDevice.UEFI_USB_HDD;
            }
            case 13: {
                return GlobalDefine.BootDevice.UEFI_USB_CDDVD;
            }
            case 14: {
                return GlobalDefine.BootDevice.UEFI_PXE;
            }
        }
        return null;
    }

    private int getBootDeviceIndex(GlobalDefine.BootDevice device) {
        switch (device) {
            case PXE: {
                return 1;
            }
            case HD_DEFAULT: {
                return 2;
            }
            case CD_DVD: {
                return 3;
            }
            case BIOS: {
                return 4;
            }
            case USB_KEY: {
                return 5;
            }
            case USB_HDD: {
                return 6;
            }
            case USB_FLOPPY: {
                return 7;
            }
            case USB_CD_DVD: {
                return 8;
            }
            case UEFI_HD: {
                return 9;
            }
            case UEFI_CD_DVD: {
                return 10;
            }
            case UEFI_USB_KEY: {
                return 11;
            }
            case UEFI_USB_HDD: {
                return 12;
            }
            case UEFI_USB_CDDVD: {
                return 13;
            }
            case UEFI_PXE: {
                return 14;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$setChassisPowerState$2(int state) {
        block7: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    sessionController = null;
                                    ipmiChassisCommand = new IPMIChassisCommand(null);
                                    ipmiGlobalCommand = new IPMIGlobalCommand(null);
                                    sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiChassisCommand, 10);
                                    if (sessionController != null) break block6;
                                    this.deviceStateListener.updateState(2, new Integer[0]);
                                    this.profile.setChassisPowerState(false);
                                    break block7;
                                }
                                result = false;
                                if (state != 0) break block8;
                                result = ipmiChassisCommand.powerUp();
                                ** GOTO lbl-1000
                            }
                            if (state != 1) break block9;
                            result = ipmiChassisCommand.powerDown();
                            ** GOTO lbl-1000
                        }
                        if (state != 2) break block10;
                        result = ipmiChassisCommand.softShutdown();
                        ** GOTO lbl-1000
                    }
                    if (state != 3) break block11;
                    result = ipmiChassisCommand.powerCycle();
                    ** GOTO lbl-1000
                }
                if (state != 4) break block12;
                result = ipmiChassisCommand.reset();
                ** GOTO lbl-1000
            }
            if (state == 5 || state == 6) {
                ipmiGlobalCommand.setIPMIInterface(ipmiChassisCommand.getIPMIInterface());
                result = state == 5 ? ipmiGlobalCommand.warmReset() : ipmiGlobalCommand.coldReset();
                IPMIView20.getInstance().closeActivatelySession();
            } else lbl-1000:
            // 6 sources

            {
                if (!result) {
                    this.deviceStateListener.updateState(2, new Integer[0]);
                } else {
                    this.deviceStateListener.updateState(5, new Integer[]{state});
                }
                if (sessionController.closeSession()) {
                    sessionController = null;
                }
            }
        }
        if (sessionController != null) {
            sessionController.closeSession();
        }
    }
}

