/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ExpandableComponent;
import IPMIView20.IPMIDeviceControlInterface;
import IPMIView20.L;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IPMIDevicePowerPanel
extends ExpandableComponent {
    public static final int ACTION_POWER_ON = 0;
    public static final int ACTION_POWER_DOWN = 1;
    public static final int ACTION_GRACEFUL_SHUTDOWN = 2;
    public static final int ACTION_POWER_CYCLE = 3;
    public static final int ACTION_POWER_RESET = 4;
    public static final int ACTION_WARM_RESET = 5;
    public static final int ACTION_COLD_RESET = 6;
    private JPanel bodyPanel = new JPanel();
    private JPanel bodyInsideLeftPanel = new JPanel();
    private JPanel bodyInsideMiddlePanel = new JPanel();
    private JPanel bodyInsideRightPanel = new JPanel();
    private IndexRadioButtion powerOnBtn = new IndexRadioButtion(0);
    private IndexRadioButtion powerDownBtn = new IndexRadioButtion(1);
    private IndexRadioButtion gracefulShutdownBtn = new IndexRadioButtion(2);
    private IndexRadioButtion powerCycleBtn = new IndexRadioButtion(3);
    private IndexRadioButtion powerResetBtn = new IndexRadioButtion(4);
    private IndexRadioButtion warmResetBtn = new IndexRadioButtion(5);
    private IndexRadioButtion coldResetBtn = new IndexRadioButtion(6);
    private ButtonGroup buttonGroup = new ButtonGroup();
    private final int RADIO_BUTTON_WIDTH = 220;
    private final int RADIO_BUTTON_HEIGHT = 25;
    private IPMIDeviceControlInterface deviceStateListener;
    private boolean isCurrentPowerOn;
    private boolean isOperatorEnable;
    private boolean isAdministratorEnable;

    public IPMIDevicePowerPanel(IPMIDeviceControlInterface listener) {
        this.deviceStateListener = listener;
        this.init();
    }

    public void init() {
        this.powerOnBtn.setMaximumSize(new Dimension(220, 25));
        this.powerDownBtn.setMaximumSize(new Dimension(220, 25));
        this.gracefulShutdownBtn.setMaximumSize(new Dimension(220, 25));
        this.powerCycleBtn.setMaximumSize(new Dimension(220, 25));
        this.powerResetBtn.setMaximumSize(new Dimension(220, 25));
        this.warmResetBtn.setMaximumSize(new Dimension(220, 25));
        this.coldResetBtn.setMaximumSize(new Dimension(220, 25));
        this.warmResetBtn.setBackground(Color.LIGHT_GRAY);
        this.warmResetBtn.setForeground(new Color(198, 0, 0));
        this.coldResetBtn.setBackground(Color.LIGHT_GRAY);
        this.coldResetBtn.setForeground(new Color(198, 0, 0));
        this.setHeaderText("Power Control");
        this.powerOnBtn.setText("Power ON");
        this.powerDownBtn.setText("Power Down - Immediate");
        this.gracefulShutdownBtn.setText("Graceful Shutdown");
        this.powerCycleBtn.setText("Power Cycle");
        this.powerResetBtn.setText("Power Reset");
        this.warmResetBtn.setText("Warm Reset");
        this.coldResetBtn.setText("Cold Reset");
        this.buttonGroup.add(this.powerOnBtn);
        this.buttonGroup.add(this.powerDownBtn);
        this.buttonGroup.add(this.gracefulShutdownBtn);
        this.buttonGroup.add(this.powerCycleBtn);
        this.buttonGroup.add(this.powerResetBtn);
        this.buttonGroup.add(this.warmResetBtn);
        this.buttonGroup.add(this.coldResetBtn);
        this.fixedButtonDimension(this.powerOnBtn, 220, 25);
        this.fixedButtonDimension(this.powerDownBtn, 220, 25);
        this.fixedButtonDimension(this.gracefulShutdownBtn, 220, 25);
        this.fixedButtonDimension(this.powerCycleBtn, 220, 25);
        this.fixedButtonDimension(this.powerResetBtn, 220, 25);
        this.fixedButtonDimension(this.warmResetBtn, 120, 25);
        this.fixedButtonDimension(this.coldResetBtn, 120, 25);
        this.bodyPanel.setLayout(new BoxLayout(this.bodyPanel, 0));
        this.bodyInsideLeftPanel.setLayout(new BoxLayout(this.bodyInsideLeftPanel, 1));
        this.bodyInsideMiddlePanel.setLayout(new BoxLayout(this.bodyInsideMiddlePanel, 1));
        this.bodyInsideRightPanel.setLayout(new BoxLayout(this.bodyInsideRightPanel, 1));
        this.bodyPanel.add(Box.createHorizontalStrut(40));
        this.bodyPanel.add(this.bodyInsideLeftPanel);
        this.bodyPanel.add(Box.createHorizontalGlue());
        this.bodyPanel.add(this.bodyInsideMiddlePanel);
        this.bodyPanel.add(Box.createHorizontalGlue());
        this.bodyPanel.add(this.bodyInsideRightPanel);
        this.bodyPanel.add(Box.createHorizontalStrut(40));
        this.bodyInsideLeftPanel.add(this.powerOnBtn);
        this.bodyInsideLeftPanel.add(this.powerDownBtn);
        this.bodyInsideLeftPanel.add(this.gracefulShutdownBtn);
        this.bodyInsideLeftPanel.add(Box.createVerticalGlue());
        this.bodyInsideMiddlePanel.add(this.powerCycleBtn);
        this.bodyInsideMiddlePanel.add(this.powerResetBtn);
        this.bodyInsideMiddlePanel.add(Box.createVerticalGlue());
        this.bodyInsideRightPanel.add(this.warmResetBtn);
        this.bodyInsideRightPanel.add(this.coldResetBtn);
        this.bodyInsideRightPanel.add(Box.createVerticalGlue());
        super.setBodyComponet(this.bodyPanel, 120);
        this.powerOnBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.powerDownBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.gracefulShutdownBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.powerCycleBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.powerResetBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.warmResetBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.coldResetBtn.addActionListener(e2 -> this.setRadioButtonAction(e2));
        this.powerOnBtn.setToolTipText("(Administrator and Operator only) Turn on the power of a managed system.");
        this.powerDownBtn.setToolTipText("(Administrator and Operator only) Turn off the power of a managed system.");
        this.gracefulShutdownBtn.setToolTipText("<html>(Administrator and Operator only) This feature has the same function as \u00a1\u00a7shutdown\u00a1\u00a8 in the Windows.<br>Using this feature will cause the managed system to enter the S5 state.</html>");
        this.powerCycleBtn.setToolTipText("<html>(Administrator and Operator only) Turn off the power of a managed system for a few seconds and then<br>turn on the power of the system again.</html>");
        this.powerResetBtn.setToolTipText("(Administrator and Operator only) Resets a managed system");
        this.warmResetBtn.setToolTipText("(Administrator only) Reset the BMC. It is only used for an event when you suspect a system malfunction for example");
        this.coldResetBtn.setToolTipText("(Administrator only) Reset the BMC. It is only used for an event when you suspect a system malfunction for example");
    }

    private void fixedButtonDimension(IndexRadioButtion button, int width, int height) {
        button.setMaximumSize(new Dimension(width, height));
        button.setMinimumSize(new Dimension(width, height));
        button.setPreferredSize(new Dimension(width, height));
    }

    private void setRadioButtonAction(ActionEvent e2) {
        this.setComponetLocked(true);
        this.deviceStateListener.updateState(3, 0);
        IndexRadioButtion irButton = (IndexRadioButtion)e2.getSource();
        int index = irButton.getIndex();
        if (index == 0) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_to_power_up_the_system"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 0);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 1) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_to_power_down_the_system"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 1);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 2) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_to_shutdown_the_system"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 2);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 3) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_that_you_want_to_reboot_the_system"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 3);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 4) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_to_reset_the_system"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 4);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 5) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_that_you_want_to_warm_reset_the_BMC_This_session_will_be_terminated"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 5);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        } else if (index == 6) {
            int result = JOptionPane.showConfirmDialog(this, L.t("device.Are_you_sure_that_you_want_to_cold_reset_the_BMC_This_session_will_be_terminated"), L.t("device.Request_Confirmation"), 0);
            if (result == 0) {
                JOptionPane.showMessageDialog(this, L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
                this.deviceStateListener.updateState(4, 6);
            } else {
                this.setComponetLocked(false);
                this.deviceStateListener.updateState(3, 1);
            }
        }
        this.buttonGroup.clearSelection();
        this.requestFocusInWindow();
    }

    public void setCurrentEnable(boolean isPowerOn) {
        this.buttonGroup.clearSelection();
        this.powerOnBtn.setSelected(isPowerOn);
        this.powerOnBtn.setEnabled(this.isOperatorEnable ? !isPowerOn : false);
        this.powerDownBtn.setEnabled(this.isOperatorEnable ? isPowerOn : false);
        this.gracefulShutdownBtn.setEnabled(this.isOperatorEnable ? isPowerOn : false);
        this.powerCycleBtn.setEnabled(this.isOperatorEnable ? isPowerOn : false);
        this.powerResetBtn.setEnabled(this.isOperatorEnable ? isPowerOn : false);
        this.warmResetBtn.setEnabled(this.isAdministratorEnable);
        this.coldResetBtn.setEnabled(this.isAdministratorEnable);
    }

    public void setComponentEnable(boolean enable) {
        boolean status = this.isOperatorEnable ? enable : false;
        this.powerOnBtn.setEnabled(status);
        this.powerDownBtn.setEnabled(status);
        this.gracefulShutdownBtn.setEnabled(status);
        this.powerCycleBtn.setEnabled(status);
        this.powerResetBtn.setEnabled(status);
        this.warmResetBtn.setEnabled(this.isAdministratorEnable);
        this.coldResetBtn.setEnabled(this.isAdministratorEnable);
    }

    public void setCurrentPowerOn(boolean isPowerOn) {
        this.isCurrentPowerOn = isPowerOn;
    }

    public void setAccountPermission(int permission) {
        this.isOperatorEnable = permission == 3 || permission == 4;
        this.isAdministratorEnable = permission == 4;
    }

    @Override
    protected void setComponetLocked(boolean locked) {
        if (locked) {
            this.setComponentEnable(false);
        } else {
            this.setCurrentEnable(this.isCurrentPowerOn);
        }
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        super.setExpanded(isExpanded);
    }

    private class IndexRadioButtion
    extends JRadioButton {
        private int index;

        public IndexRadioButtion(int buttonIndex) {
            this.index = buttonIndex;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

