/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.HistoryMonitor;
import IPMIView20.Readable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JVolPanel
extends JPanel
implements Readable {
    JVolMeter volMeter = new JVolMeter();
    HistoryMonitor hm = null;
    JLabel NameLabel = new JLabel();
    int SensorNumber;
    int M;
    int B;
    int RExp;
    int BExp;
    float offset = 0.0f;

    public JVolPanel(int sensorNumber, int m, int b2, int rexp, int bexp) {
        this.initComponents();
        this.SensorNumber = sensorNumber;
        this.M = m;
        this.B = b2;
        this.RExp = rexp;
        this.BExp = bexp;
    }

    public void updateValue(byte value, String valueString) {
        this.volMeter.m_VoltReading = value;
        this.volMeter.m_ShowString = valueString;
        this.volMeter.paintBufferImage();
        this.volMeter.repaint();
        this.hm.updateHistory();
    }

    public void init(String labelName, byte value, byte high, byte low, String valueString, String highString, String lowString) {
        this.volMeter.setValue(value, high, low);
        this.volMeter.setString(valueString, highString, lowString);
        this.volMeter.setBorder(new EtchedBorder());
        this.add((Component)this.volMeter, "Center");
        this.NameLabel.setText(labelName);
        this.NameLabel.setBorder(new EtchedBorder());
        this.NameLabel.setForeground(Color.blue);
        this.NameLabel.setHorizontalAlignment(0);
        this.add((Component)this.NameLabel, "South");
        this.hm = new HistoryMonitor(this);
        this.hm.surf.setPreferredSize(new Dimension(98, 90));
        this.add((Component)this.hm, "Center");
        this.add((Component)this.volMeter, "Center");
    }

    public void showVol() {
        this.add((Component)this.volMeter, "Center");
    }

    public void showHisotry() {
        this.add((Component)this.hm, "Center");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            intdes = (intdes << 8) + (bytesrc[i2] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    @Override
    public float maxValue() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value >= 0.0f) {
            this.offset = 0.0f;
            return 15.0f;
        }
        this.offset = 15.0f;
        return 15.0f;
    }

    @Override
    public float getValue() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_ShowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public float getOffset() {
        return this.offset;
    }

    @Override
    public String getTitle() {
        return this.NameLabel.getText();
    }

    @Override
    public float highLimit() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public float lowLimit() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_LowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public void showHistory() {
        this.remove(this.volMeter);
        this.remove(this.hm);
        this.add((Component)this.hm, "Center");
    }

    public void showMeter() {
        this.remove(this.volMeter);
        this.remove(this.hm);
        this.add((Component)this.volMeter, "Center");
    }

    public class JVolMeter
    extends JPanel {
        int value;
        Color colorvalue;
        byte m_HighLimit = (byte)-64;
        byte m_LowLimit = (byte)-128;
        byte m_VoltReading = (byte)-48;
        String m_ShowString = "12.34V";
        String m_HighString = "15.00V";
        String m_LowString = "0.0V";
        private BufferedImage bimg;

        public JVolMeter() {
            super.setPreferredSize(new Dimension(98, 58));
        }

        public void setValue(byte value, byte hight, byte low) {
            this.m_VoltReading = value;
            this.m_HighLimit = hight;
            this.m_LowLimit = low;
        }

        public void setString(String valueString, String HeightString, String LowString) {
            this.m_ShowString = valueString;
            this.m_HighString = HeightString;
            this.m_LowString = LowString;
        }

        @Override
        public void paintComponent(Graphics g1) {
            if (this.bimg != null) {
                g1.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void paintBufferImage() {
            int angle;
            Dimension d2 = this.getPreferredSize();
            if (this.bimg == null) {
                this.bimg = new BufferedImage((int)d2.getWidth(), (int)d2.getHeight(), 2);
            }
            Graphics2D g1 = this.bimg.createGraphics();
            super.paintComponent(g1);
            Graphics2D g2 = g1;
            RenderingHints hints = new RenderingHints(null);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(hints);
            int[] cPointx = new int[180];
            int[] cPointy = new int[180];
            Dimension rcBounds = this.getPreferredSize();
            int m_Radius = (int)((double)rcBounds.height > (double)rcBounds.width / 2.0 / Math.cos(0.5235986666666667) ? (double)rcBounds.width / 2.0 / Math.cos(0.5235986666666667) : (double)rcBounds.height);
            int centerx = (int)((double)rcBounds.width / 2.0);
            int centery = m_Radius;
            g2.setColor(Color.lightGray);
            int xleft = centerx - (int)((double)m_Radius * Math.cos(0.5235986666666667));
            int xtop = 0;
            int xright = centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667));
            int xbottom = centery;
            GradientPaint comet = new GradientPaint(xleft, xtop, Color.gray, xleft, xbottom - xtop, Color.gray);
            g2.setPaint(comet);
            g2.fillRect(xleft, xtop, xright - xleft, xbottom - xtop);
            g2.setColor(Color.white);
            g2.drawLine(centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), 0, centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), centery);
            g2.drawLine(centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), centery, 0, centery);
            g2.setColor(Color.red);
            int ix2 = centerx + (int)((double)m_Radius * 0.7 * Math.cos(0.5235993333333333));
            int iy2 = centery - (int)((double)m_Radius * 0.7 * Math.sin(0.5235993333333333));
            cPointx[0] = ix2;
            cPointy[0] = iy2;
            int i2 = 1;
            for (angle = 30; angle < 30 + (int)((double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0); angle += 10) {
                cPointx[i2] = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i2] = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i2;
            }
            int ix1 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((30.0 + (double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            int iy1 = centery - (int)((double)m_Radius * 0.9 * Math.sin((30.0 + (double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            cPointx[i2] = ix1;
            cPointy[i2] = iy1;
            ++i2;
            for (angle = 30 + (int)((double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0); angle >= 30; angle -= 10) {
                cPointx[i2] = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i2] = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i2;
            }
            g2.fillPolygon(cPointx, cPointy, i2);
            ix2 = centerx + (int)((double)m_Radius * 0.7 * Math.cos(2.6179966666666665));
            iy2 = centery - (int)((double)m_Radius * 0.7 * Math.sin(2.6179966666666665));
            cPointx[0] = ix2;
            cPointy[0] = iy2;
            i2 = 1;
            for (angle = 150; angle >= 30 + (int)((double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0); angle -= 10) {
                cPointx[i2] = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i2] = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i2;
            }
            ix1 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((30.0 + (double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.9 * Math.sin((30.0 + (double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            cPointx[i2] = ix1;
            cPointy[i2] = iy1;
            ++i2;
            for (angle = 30 + (int)((double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0); angle <= 150; angle += 10) {
                cPointx[i2] = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i2] = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i2;
            }
            g2.fillPolygon(cPointx, cPointy, i2);
            g2.setColor(Color.black);
            angle = 30;
            ix1 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            angle = 30;
            ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
            g2.drawLine(ix1, iy1, ix2, iy2);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 40; angle < 151; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1, iy1, ix2, iy2);
                ix1 = ix2;
                iy1 = iy2;
            }
            angle = 150;
            ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            g2.drawLine(ix1, iy1, ix2, iy2);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 150; angle > 29; angle -= 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1, iy1, ix2, iy2);
                ix1 = ix2;
                iy1 = iy2;
            }
            g2.setColor(Color.white);
            angle = 30;
            ix1 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            angle = 30;
            ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
            g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 40; angle < 151; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
                ix1 = ix2;
                iy1 = iy2;
            }
            angle = 150;
            ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 150; angle > 29; angle -= 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
                ix1 = ix2;
                iy1 = iy2;
            }
            g2.setColor(Color.black);
            for (angle = 30; angle < 151; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1, iy1, ix2, iy2);
            }
            g2.setColor(Color.white);
            for (angle = 30; angle < 151; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g2.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            }
            g2.setColor(Color.WHITE);
            Font mFont = new Font("New Times Roman", 1, 12);
            FontMetrics fm = g2.getFontMetrics(mFont);
            int fwidth = fm.stringWidth("V");
            g2.drawString("V", centerx - (int)((double)fwidth / 2.0) + 2, (int)((double)rcBounds.height / 2.0) + 3);
            g2.setColor(Color.black);
            angle = (int)(30.0 + (double)(256 - (this.m_VoltReading & 0xFF)) / 256.0 * 120.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.97 * Math.cos((double)angle / 180.0 * 3.141596));
            cPointy[0] = centery - (int)((double)m_Radius * 0.97 * Math.sin((double)angle / 180.0 * 3.141596));
            ix1 = centerx + (int)((double)m_Radius * 0.35 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.35 * Math.sin((double)angle / 180.0 * 3.141596));
            cPointx[1] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(90 + angle) / 180.0 * 3.141596));
            cPointy[1] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(90 + angle) / 180.0 * 3.141596));
            cPointx[2] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(270 + angle) / 180.0 * 3.141596));
            cPointy[2] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(270 + angle) / 180.0 * 3.141596));
            g2.fillPolygon(cPointx, cPointy, 3);
            g2.setColor(Color.white);
            angle = (int)(30.0 + (double)(256 - (this.m_VoltReading & 0xFF)) / 256.0 * 120.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.97 * Math.cos((double)angle / 180.0 * 3.141596)) - 1;
            cPointy[0] = centery - (int)((double)m_Radius * 0.97 * Math.sin((double)angle / 180.0 * 3.141596)) - 1;
            ix1 = centerx + (int)((double)m_Radius * 0.35 * Math.cos((double)angle / 180.0 * 3.141596)) - 1;
            iy1 = centery - (int)((double)m_Radius * 0.35 * Math.sin((double)angle / 180.0 * 3.141596)) - 1;
            cPointx[1] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[1] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointx[2] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[2] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            g2.fillPolygon(cPointx, cPointy, 3);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.addRenderingHints(hints);
            mFont = new Font("New Times Roman", 0, 11);
            fm = g2.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_ShowString);
            g2.setColor(Color.black);
            g2.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0) + 1, centery - 3 + 1);
            g2.setColor(Color.yellow);
            g2.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0), centery - 3);
            mFont = new Font("New Times Roman", 0, 10);
            fm = g2.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_LowString);
            g2.setColor(Color.black);
            g2.drawString(this.m_LowString, 2, centery - 3 + 1);
            g2.setColor(Color.red);
            g2.drawString(this.m_LowString, 1, centery - 3);
            fwidth = fm.stringWidth(this.m_HighString);
            g2.setColor(Color.black);
            g2.drawString(this.m_HighString, rcBounds.width - fwidth - 5 + 1, centery - 3 + 1);
            g2.setColor(Color.red);
            g2.drawString(this.m_HighString, rcBounds.width - fwidth - 5, centery - 3);
        }
    }
}

