/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMISession;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.iKVMLunchar;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.kvm.authentication.KVMRedfishState;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class KVMATENPanel
extends JPanel {
    private static final int KVM_INTERFACE_JAVA = 0;
    private static final int KVM_INTERFACE_HTML5 = 1;
    private static final int KVM_INTERFACE_UNKNOW = -1;
    private int kvmInterface = -1;
    private KVMRedfishState kvmRedfishState = null;
    byte[] guid;
    String userID;
    String userPassword;
    String ip;
    boolean isCreateUI = false;
    JPanel jPanelMain = new JPanel();
    JPanel jPanelFisrtLine = new JPanel();
    JPanel jPanelSecondLine = new JPanel();
    JPanel jPanelThirdLine = new JPanel();
    JPanel jPanelFourthLine = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    TitledBorder titledBorder1 = new TitledBorder("");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonLaunch = new JButton();
    JLabel jLabelDescription = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabelCurrentKVM = new JLabel();
    JLabel jLabelWindowsMsgBar = new JLabel();
    Icon icon = new ImageIcon(this.getClass().getResource("/images/device_aten.gif"));
    IPMIInterfaceConfig config = new IPMIInterfaceConfig();
    ISessionController sessionController;
    IPMIInterface rmcp;
    KVMSessionConnection kvmSession;
    ButtonGroup kvmInterfaceButtonGroup = new ButtonGroup();
    JRadioButton javaRadioButton = new JRadioButton();
    JRadioButton htmlRadioButton = new JRadioButton();
    boolean enableRedfishKVM;
    boolean enableSMCRAKP;
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private Icon lightBulbIcon = new ImageIcon(this.getClass().getResource("/images/lightBulb.png"));
    private JTextArea descTextField = new JTextArea(){

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            KVMATENPanel.this.lightBulbIcon.paintIcon(this, g2, 20, 15);
        }
    };

    public KVMATENPanel(String userID, String userPassword, String ip, byte[] guid, JLabel message, boolean isSMCRAKP) {
        try {
            this.userID = userID;
            this.userPassword = userPassword.trim();
            this.ip = ip;
            this.guid = guid;
            this.jLabelWindowsMsgBar = message;
            this.enableSMCRAKP = isSMCRAKP;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.javaRadioButton.addActionListener(e2 -> this.kvmInterfaceRadioButtonSelected(e2));
        this.htmlRadioButton.addActionListener(e2 -> this.kvmInterfaceRadioButtonSelected(e2));
        new Thread(() -> {
            this.initial();
            this.createSessionController();
            this.startSessionConnect();
            this.getKVMSession();
            this.getKVMInterface();
            this.checkRedfishKVM();
            this.refreshUI();
            this.sessionController.closeSession();
        }).start();
    }

    private void getKVMSession() {
        this.kvmSession = new KVMSessionConnection(this.config.getIp(), this.config.getUserName(), this.config.getPassword(), this.guid);
        this.kvmSession.setWarning(false);
    }

    private void getKVMInterface() {
        this.kvmInterface = this.kvmSession.getKVMInterface();
    }

    private void enableUI(boolean enable) {
        this.jButtonLaunch.setEnabled(enable);
        this.javaRadioButton.setEnabled(enable);
        this.htmlRadioButton.setEnabled(enable && this.enableRedfishKVM);
    }

    private void invokeUI(boolean enable) {
        SwingUtilities.invokeLater(() -> this.enableUI(enable));
    }

    private void refreshUI() {
        SwingUtilities.invokeLater(() -> {
            if (this.kvmInterface == 0) {
                this.javaRadioButton.setSelected(true);
            } else if (this.kvmInterface == 1) {
                this.htmlRadioButton.setSelected(true);
            } else {
                this.javaRadioButton.setSelected(false);
                this.htmlRadioButton.setSelected(false);
            }
            this.enableUI(true);
        });
    }

    private void updateTaskbarMessage(String messsage) {
        this.updateTaskbarMessage(messsage, false);
    }

    private void setWaitingCursor(boolean isWaitingState) {
        SwingUtilities.invokeLater(() -> this.setCursor(isWaitingState ? this.waitCursor : this.defaultCursor));
    }

    private void updateTaskbarMessage(String messsage, boolean invokeLater) {
        if (invokeLater) {
            SwingUtilities.invokeLater(() -> this.jLabelWindowsMsgBar.setText(messsage));
        } else {
            this.jLabelWindowsMsgBar.setText(messsage);
        }
    }

    private void kvmInterfaceRadioButtonSelected(ActionEvent e2) {
        if (e2.getSource().equals(this.javaRadioButton)) {
            if (this.kvmInterface == 0) {
                return;
            }
            this.invokeUI(false);
            this.setWaitingCursor(true);
            new Thread(() -> {
                boolean switchResult = this.kvmSession.switchKVMInterface(0);
                if (!switchResult) {
                    this.kvmInterface = 1;
                    this.refreshUI();
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(null, "Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.", "Warning", 2);
                        this.updateTaskbarMessage(L.t("kvm.Switch_Interface_Faild"));
                    });
                } else {
                    this.kvmInterface = 0;
                    this.invokeUI(true);
                    this.updateTaskbarMessage(L.t("kvm.Switch_Interface") + L.t("kvm.Interface_Java") + " " + L.t("kvm.Switch_Successfully"), true);
                }
                this.setWaitingCursor(false);
            }).start();
        } else if (e2.getSource().equals(this.htmlRadioButton)) {
            if (this.kvmInterface == 1) {
                return;
            }
            this.invokeUI(false);
            this.setWaitingCursor(true);
            new Thread(() -> {
                boolean switchResult;
                if (this.rmcp == null) {
                    this.rmcp = this.startSessionConnect();
                }
                if (!(switchResult = this.kvmSession.switchKVMInterface(1))) {
                    this.kvmInterface = 0;
                    this.refreshUI();
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(null, "Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.", "Warning", 2);
                        this.updateTaskbarMessage(L.t("kvm.Switch_Interface_Faild"));
                    });
                } else {
                    this.kvmInterface = 1;
                    this.kvmRedfishState = this.kvmSession.getKvmRedfishState();
                    this.invokeUI(true);
                    this.updateTaskbarMessage(L.t("kvm.Switch_Interface") + L.t("kvm.Interface_HTML5") + " " + L.t("kvm.Switch_Successfully"), true);
                }
                this.setWaitingCursor(false);
            }).start();
        }
    }

    void checkRedfishKVM() {
        block5: {
            if (IPMIMessagingCommand.isBeforeX12(this.guid)) {
                try {
                    LicenseManager lm = new LicenseManager(this.rmcp, this.config);
                    if (lm.checkIfDCMSLicenseExist()) {
                        this.enableRedfishKVM = true;
                        break block5;
                    }
                    this.enableRedfishKVM = false;
                }
                catch (Exception e2) {
                    this.enableRedfishKVM = true;
                    if (IPMIView20.showException) {
                        e2.printStackTrace();
                    }
                    break block5;
                }
            }
            this.enableRedfishKVM = true;
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(L.t("kvm.Console_Redirection"));
        this.setLayout(this.borderLayout1);
        this.jPanelMain.setBorder(this.titledBorder1);
        this.jPanelMain.setLayout(new BoxLayout(this.jPanelMain, 1));
        this.jPanelFisrtLine.setLayout(new BoxLayout(this.jPanelFisrtLine, 0));
        this.jPanelSecondLine.setLayout(new BoxLayout(this.jPanelSecondLine, 0));
        this.jPanelThirdLine.setLayout(new BoxLayout(this.jPanelThirdLine, 0));
        this.jPanelFourthLine.setLayout(new BoxLayout(this.jPanelFourthLine, 0));
        this.javaRadioButton.setPreferredSize(new Dimension(80, 20));
        this.htmlRadioButton.setPreferredSize(new Dimension(80, 20));
        this.javaRadioButton.setText(L.t("kvm.Interface_Java"));
        this.htmlRadioButton.setText(L.t("kvm.Interface_HTML5"));
        this.kvmInterfaceButtonGroup.add(this.javaRadioButton);
        this.kvmInterfaceButtonGroup.add(this.htmlRadioButton);
        this.javaRadioButton.setSelected(true);
        this.jLabelCurrentKVM.setText(L.t("kvm.Interface_Current"));
        this.jButtonLaunch.setText(L.t("kvm.Launch_KVM_Console"));
        this.jButtonLaunch.addActionListener(e2 -> this.jButton1_actionPerformed(e2));
        this.jLabelDescription.setHorizontalAlignment(0);
        this.jLabelDescription.setIcon(this.icon);
        this.jLabelDescription.setText(L.t("kvm.Launch_Console_Redirection"));
        this.jLabel2.setToolTipText("");
        this.jLabel2.setText(" ");
        this.javaRadioButton.setEnabled(false);
        this.htmlRadioButton.setEnabled(false);
        this.jButtonLaunch.setEnabled(false);
        Border descBorder = BorderFactory.createLineBorder(new Color(38, 123, 204), 2);
        this.descTextField.setBorder(BorderFactory.createCompoundBorder(descBorder, BorderFactory.createEmptyBorder(10, 45, 10, 25)));
        this.descTextField.setMargin(new Insets(2, 20, 2, 2));
        this.descTextField.setBackground(new Color(239, 247, 255));
        this.descTextField.setForeground(new Color(38, 123, 204));
        this.descTextField.setLineWrap(true);
        this.descTextField.setMinimumSize(new Dimension(500, 60));
        this.descTextField.setMaximumSize(new Dimension(500, 60));
        this.descTextField.setPreferredSize(new Dimension(500, 60));
        this.descTextField.setEditable(false);
        this.descTextField.setText(L.t("kvm.HTML5_Description"));
        this.jPanelFisrtLine.add(this.jLabelDescription);
        this.jPanelSecondLine.add(this.jLabelCurrentKVM);
        this.jPanelSecondLine.add(Box.createRigidArea(new Dimension(5, 5)));
        this.jPanelSecondLine.add(this.javaRadioButton);
        this.jPanelSecondLine.add(this.htmlRadioButton);
        this.jPanelThirdLine.add(this.jButtonLaunch);
        this.jPanelFourthLine.add(Box.createHorizontalGlue());
        this.jPanelFourthLine.add(this.descTextField);
        this.jPanelFourthLine.add(Box.createHorizontalGlue());
        this.jPanelMain.add(Box.createVerticalGlue());
        this.jPanelMain.add(this.jPanelFisrtLine);
        this.jPanelMain.add(Box.createVerticalStrut(15));
        this.jPanelMain.add(this.jPanelSecondLine);
        this.jPanelMain.add(Box.createVerticalStrut(15));
        this.jPanelMain.add(this.jPanelThirdLine);
        this.jPanelMain.add(Box.createVerticalGlue());
        this.jPanelMain.add(this.jPanelFourthLine);
        this.jPanelMain.add(Box.createVerticalStrut(10));
        this.add(this.jPanelMain);
    }

    public void stopVM() {
    }

    public void close() {
    }

    public void jButton1_actionPerformed(ActionEvent e2) {
        this.updateTaskbarMessage(L.t("kvm.Loading"), true);
        this.invokeUI(false);
        this.setWaitingCursor(true);
        if (this.isSystemLockdown()) {
            this.invokeUI(true);
            this.setWaitingCursor(false);
            this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
            return;
        }
        if (IPMIMessagingCommand.isHGIMEZZGUID(this.guid)) {
            JOptionPane.showOptionDialog(IPMIView20.getInstance(), "This device is not supported", "Message", -1, 1, null, null, 0);
            this.setWaitingCursor(false);
            this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
            return;
        }
        if (this.kvmInterface == 1) {
            if (this.enableRedfishKVM) {
                new Thread(() -> {
                    this.runHTML5KVM();
                    this.invokeUI(true);
                    this.setWaitingCursor(false);
                }).start();
            } else {
                JOptionPane.showMessageDialog(null, "DCMS-single needs to be activated for this device", "Warning", 2);
                this.invokeUI(true);
                this.setWaitingCursor(false);
                this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
            }
            return;
        }
        new Thread(() -> {
            int vmType = 0;
            if (this.guid != null && (IPMIMessagingCommand.isATENGUID(this.guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(this.guid) || IPMIMessagingCommand.isATENSuperBladeGUID(this.guid) || IPMIMessagingCommand.isCMMGUID(this.guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(this.guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(this.guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(this.guid) || IPMIMessagingCommand.isSIMBL(this.guid) || IPMIMessagingCommand.isPepperconGUID(this.guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(this.guid) || IPMIMessagingCommand.isOSAGUID(this.guid) || IPMIMessagingCommand.isAMIGUID(this.guid) || IPMIMessagingCommand.isAMISIMBLGUID(this.guid) || IPMIMessagingCommand.isAMIX9GUID(this.guid) || IPMIMessagingCommand.isAMIAspeedGUID(this.guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(this.guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(this.guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(this.guid) || IPMIMessagingCommand.isCB3GUID(this.guid) || IPMIMessagingCommand.isAMIOnBoardGUID(this.guid) || IPMIMessagingCommand.isAMIAddOnGUID(this.guid) || IPMIMessagingCommand.isRenesasATENGUID(this.guid))) {
                vmType = 2;
            }
            this.createSessionController();
            this.startSessionConnect();
            IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(this.rmcp);
            int port = 5900;
            try {
                port = ipmiOEMPortServiceCommand.getPort((byte)2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            iKVMLunchar.launchKVM(this.ip.trim(), this.userID.trim(), this.userPassword.trim(), port, vmType, ipmiOEMPortServiceCommand, this.guid, this.config);
            this.sessionController.closeSession();
            this.invokeUI(true);
            this.setWaitingCursor(false);
            this.updateTaskbarMessage(L.t("kvm.Loading_Done"), true);
        }).start();
    }

    private void runHTML5KVM() {
        String root = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp());
        if (this.kvmRedfishState != null && this.kvmRedfishState.getCurrentInterface() == 1 && this.kvmRedfishState.getKvmURI() != null) {
            String kvmRUI = root + this.kvmRedfishState.getKvmURI();
            this.openKVM(kvmRUI);
            this.updateTaskbarMessage(L.t("kvm.Loading_Done"), true);
            return;
        }
        try {
            String url = root + "/redfish/v1/Managers/1/";
            BasicAuthClient bc = new BasicAuthClient(this.config);
            int result = bc.send_https_get(url);
            if (result == 404) {
                JOptionPane.showMessageDialog(null, "Manager API, 404 not found");
            }
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode oem = node.path("Oem");
                JsonNode supermicro = oem.path("Supermicro");
                JsonNode ikvm = supermicro.path("IKVM");
                JsonNode ikvmOdataId = ikvm.path("@odata.id");
                String ikvmOdataIdValue = ikvmOdataId.textValue();
                int KVMResult = bc.send_https_get(root + ikvmOdataIdValue);
                if (KVMResult >= 200 && KVMResult <= 210) {
                    node = mapper.readTree(bc.getResponseString());
                    String uri = node.path("URI").textValue();
                    String kvmRUI = root + uri;
                    this.openKVM(kvmRUI);
                    this.updateTaskbarMessage(L.t("kvm.Loading_Done"), true);
                    IPMIView20.kvmSessionMap.put(this.ip, 1);
                } else {
                    this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
                    this.printFailMessage(KVMResult, bc.getResponseString());
                }
            } else {
                this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
                this.printFailMessage(result, bc.getResponseString());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.updateTaskbarMessage(L.t("kvm.Loading_Failed"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openKVM(String kvmRUI) {
        block18: {
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(kvmRUI));
                    break block18;
                }
                Process process = Runtime.getRuntime().exec(new String[]{"which", "xdg-open"});
                InputStream inputStream = process.getInputStream();
                try {
                    if (inputStream != null && inputStream.read() != -1) {
                        Runtime.getRuntime().exec(new String[]{"xdg-open", kvmRUI});
                        break block18;
                    }
                    JOptionPane.showMessageDialog(null, "Can't launch HTML version KVM in this environment due to no available browser found");
                    return;
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Open KVM exception " + e2.getMessage());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e3) {
                JOptionPane.showMessageDialog(null, "Open KVM exception " + e3.getMessage());
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printFailMessage(int result, String responseString) {
        if (result >= 400 && result < 500) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = mapper.readTree(responseString);
                JsonNode error = node.path("error");
                JsonNode extendInfo = error.path("@Message.ExtendedInfo");
                if (!extendInfo.isArray()) return;
                for (JsonNode l : extendInfo) {
                    JsonNode messageArgs = l.path("MessageArgs");
                    JsonNode message = l.findPath("Message");
                    JOptionPane.showMessageDialog(null, message.asText());
                    if (!messageArgs.isArray()) continue;
                }
                return;
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "Failed to execute command, completion code " + result);
                return;
            }
        }
        JOptionPane.showMessageDialog(null, "Failed to execute command, completion code " + result);
    }

    private boolean isSystemLockdown() {
        if (IPMISession.checkIfSystemLockdown(this.config)) {
            if (this.jLabelWindowsMsgBar != null) {
                this.jLabelWindowsMsgBar.setText(L.t("kvm.InSystemLockdownMode"));
            }
            JOptionPane.showMessageDialog(this, L.t("kvm.InSystemLockdownMode"), L.t("kvm.Forbidden"), 0);
            return true;
        }
        return false;
    }

    void initial() {
        this.config.setIp(this.ip);
        this.config.setUserName(this.userID);
        this.config.setPassword(this.userPassword);
        this.config.setRetry(2);
        this.config.setTimeout(5);
        this.config.setCipherSuiteID((byte)3);
        this.config.setSmcRAKP(this.enableSMCRAKP);
    }

    ISessionController createSessionController() {
        this.sessionController = IPMIVersion.getSessionController(this.config);
        if (this.sessionController == null) {
            System.out.println("divice didn't exist");
            return null;
        }
        return this.sessionController;
    }

    IPMIInterface startSessionConnect() {
        this.rmcp = this.sessionController.startup(this.config);
        if (this.rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        return this.rmcp;
    }
}

